/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish.lazy;

import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class OpenLEhCacheHolder {
    private static final String CACHE_NAME = "modulesCache";
    private static final String OPENL_EHCACHE_FILE_NAME = "openl-ehcache.xml";
    private volatile Cache modulesCache = null;
    private CacheManager cacheManager = null;

    private OpenLEhCacheHolder() {
    }

    public static OpenLEhCacheHolder getInstance() {
        return OpenLEhCacheHolderHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getModulesCache() {
        if (this.modulesCache == null) {
            OpenLEhCacheHolder openLEhCacheHolder = this;
            synchronized (openLEhCacheHolder) {
                if (this.modulesCache == null) {
                    try {
                        CacheManager cacheManager = this.getCacheManager();
                        this.modulesCache = cacheManager.getCache(CACHE_NAME);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.modulesCache;
    }

    private synchronized CacheManager getCacheManager() throws IOException {
        if (this.cacheManager == null) {
            PathMatchingResourcePatternResolver prpr = new PathMatchingResourcePatternResolver();
            Resource[] resources = prpr.getResources("classpath:openl-ehcache.xml");
            if (resources == null || resources.length == 0) {
                resources = prpr.getResources("classpath*:openl-ehcache.xml");
            }
            if (resources == null || resources.length == 0) {
                throw new IllegalStateException("openl-ehcache.xml hasn't been found!");
            }
            if (resources.length > 1) {
                throw new IllegalStateException("Multiple openl-ehcache.xml exist in classpath!");
            }
            this.cacheManager = new CacheManager(resources[0].getURL());
        }
        return this.cacheManager;
    }

    private static class OpenLEhCacheHolderHolder {
        public static final OpenLEhCacheHolder INSTANCE = new OpenLEhCacheHolder();

        private OpenLEhCacheHolderHolder() {
        }
    }
}

