/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.servlet;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openl.rules.ruleservice.publish.MultipleRuleServicePublisher;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.rules.ruleservice.servlet.AvailableServicesPresenter;
import org.openl.rules.ruleservice.servlet.ServiceInfo;

public final class PublisherUtils {
    private PublisherUtils() {
    }

    public static Collection<ServiceInfo> getServicesInfo(RuleServicePublisher publisher) {
        TreeMap<String, ServiceInfo> serviceInfos = new TreeMap<String, ServiceInfo>();
        if (publisher instanceof MultipleRuleServicePublisher) {
            MultipleRuleServicePublisher multiplePublisher = (MultipleRuleServicePublisher)publisher;
            Collection<RuleServicePublisher> defaultPublishers = multiplePublisher.getDefaultRuleServicePublishers();
            HashSet<RuleServicePublisher> publishers = new HashSet<RuleServicePublisher>(defaultPublishers);
            Map<String, RuleServicePublisher> supportedPublishers = multiplePublisher.getSupportedPublishers();
            if (supportedPublishers != null) {
                publishers.addAll(supportedPublishers.values());
            }
            for (RuleServicePublisher p : publishers) {
                PublisherUtils.collectServicesInfo(serviceInfos, p);
            }
        } else {
            PublisherUtils.collectServicesInfo(serviceInfos, publisher);
        }
        return serviceInfos.values();
    }

    private static void collectServicesInfo(Map<String, ServiceInfo> servicesInfo, RuleServicePublisher publisher) {
        if (publisher instanceof AvailableServicesPresenter) {
            List<ServiceInfo> services = ((AvailableServicesPresenter)((Object)publisher)).getAvailableServices();
            for (ServiceInfo serviceInfo : services) {
                String serviceName = serviceInfo.getName();
                ServiceInfo current = servicesInfo.get(serviceName);
                if (current == null) {
                    servicesInfo.put(serviceName, serviceInfo);
                    continue;
                }
                TreeMap<String, String> urls = new TreeMap<String, String>(current.getUrls());
                urls.putAll(serviceInfo.getUrls());
                Date startedTime = current.getStartedTime();
                Date newStartedTime = serviceInfo.getStartedTime();
                if (startedTime.before(newStartedTime)) {
                    startedTime = newStartedTime;
                }
                List<String> methodNames = current.getMethodNames();
                ServiceInfo newServiceInfo = new ServiceInfo(startedTime, serviceName, methodNames, urls);
                servicesInfo.put(serviceName, newServiceInfo);
            }
        }
    }
}

