/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.util.concurrent.Semaphore;
import org.openl.rules.ruleservice.core.RuleServiceStaticConfigurationUtil;

public final class MaxThreadsForCompileSemaphore {
    private final Semaphore limitCompilationThreadsSemaphore = new Semaphore(RuleServiceStaticConfigurationUtil.getMaxThreadsForCompile());
    private final ThreadLocal<Object> threadsMarker = new ThreadLocal();

    private MaxThreadsForCompileSemaphore() {
    }

    public static MaxThreadsForCompileSemaphore getInstance() {
        return MaxThreadsForCompileSemaphoreHolder.INSTANCE;
    }

    private Semaphore getLimitCompilationThreadsSemaphore() {
        return this.limitCompilationThreadsSemaphore;
    }

    private ThreadLocal<Object> getThreadsMarker() {
        return this.threadsMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Callable<T> callable) throws Exception {
        boolean requiredSemaphore = MaxThreadsForCompileSemaphore.getInstance().getThreadsMarker().get() == null;
        try {
            if (requiredSemaphore) {
                MaxThreadsForCompileSemaphore.getInstance().getThreadsMarker().set(Thread.currentThread());
                MaxThreadsForCompileSemaphore.getInstance().getLimitCompilationThreadsSemaphore().acquire();
            }
            T t = callable.call();
            return t;
        }
        finally {
            if (requiredSemaphore) {
                MaxThreadsForCompileSemaphore.getInstance().getThreadsMarker().remove();
                MaxThreadsForCompileSemaphore.getInstance().getLimitCompilationThreadsSemaphore().release();
            }
        }
    }

    public static interface Callable<T> {
        public T call() throws Exception;
    }

    private static class MaxThreadsForCompileSemaphoreHolder {
        private static final MaxThreadsForCompileSemaphore INSTANCE = new MaxThreadsForCompileSemaphore();

        private MaxThreadsForCompileSemaphoreHolder() {
        }
    }
}

