/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.core;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.ResolvedDependency;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.project.abstraction.IDeployment;
import org.openl.rules.project.abstraction.IProject;
import org.openl.rules.project.instantiation.AbstractDependencyManager;
import org.openl.rules.project.instantiation.DependencyLoaderInitializationException;
import org.openl.rules.project.instantiation.IDependencyLoader;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.MaxThreadsForCompileSemaphore;
import org.openl.rules.ruleservice.core.RuleServiceDependencyLoader;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleServiceDependencyManager
extends AbstractDependencyManager {
    private final Logger log = LoggerFactory.getLogger(RuleServiceDependencyManager.class);
    private final RuleServiceLoader ruleServiceLoader;
    private final DeploymentDescription deployment;
    private final ThreadLocal<Deque<CompilationInfo>> compilationInfoThreadLocal = ThreadLocal.withInitial(ArrayDeque::new);

    public void compilationBegin() {
        CompilationInfo compilationInfo = new CompilationInfo();
        compilationInfo.time = System.currentTimeMillis();
        Deque<CompilationInfo> compilationInfoStack = this.compilationInfoThreadLocal.get();
        compilationInfoStack.push(compilationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compilationCompleted(IDependencyLoader dependencyLoader, boolean writeToLog) {
        Deque<CompilationInfo> compilationInfoStack = this.compilationInfoThreadLocal.get();
        try {
            CompilationInfo compilationInfo = compilationInfoStack.pop();
            long t = System.currentTimeMillis() - compilationInfo.time;
            if (this.log.isInfoEnabled() && !dependencyLoader.isProjectLoader() && writeToLog) {
                this.log.info("SUCCESS COMPILATION - Module '{}',  project '{}', deployment '{}' in [{}] ms.", new Object[]{dependencyLoader.getModule().getName(), dependencyLoader.getProject().getName(), this.deployment.getName(), t - compilationInfo.embeddedTime});
            }
            if (!compilationInfoStack.isEmpty()) {
                CompilationInfo compilationInfoParent = compilationInfoStack.peek();
                compilationInfoParent.embeddedTime += t;
            }
        }
        catch (Exception e) {
            this.log.error("Unexpected exception.", (Throwable)e);
        }
        finally {
            if (compilationInfoStack.isEmpty()) {
                this.compilationInfoThreadLocal.remove();
            }
        }
    }

    public CompiledDependency loadDependency(ResolvedDependency dependency) throws OpenLCompilationException {
        try {
            return MaxThreadsForCompileSemaphore.getInstance().run(() -> RuleServiceDependencyManager.super.loadDependency(dependency));
        }
        catch (OpenLCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenLCompilationException("Failed to compile dependency.", (Throwable)e);
        }
    }

    public RuleServiceDependencyManager(DeploymentDescription deploymentDescription, RuleServiceLoader ruleServiceLoader, ClassLoader rootClassLoader, Map<String, Object> externalParameters) {
        super(rootClassLoader, true, externalParameters);
        this.deployment = Objects.requireNonNull(deploymentDescription, "deploymentDescription cannot be null");
        this.ruleServiceLoader = Objects.requireNonNull(ruleServiceLoader, "ruleService cannot be null");
    }

    public synchronized void reset(ResolvedDependency dependency) {
        throw new UnsupportedOperationException();
    }

    protected Set<IDependencyLoader> initDependencyLoaders() {
        HashSet<IDependencyLoader> dependencyLoaders = new HashSet<IDependencyLoader>();
        IDeployment rslDeployment = this.ruleServiceLoader.getDeployment(this.deployment.getName(), this.deployment.getVersion());
        String deploymentName = rslDeployment.getDeploymentName();
        CommonVersion deploymentVersion = rslDeployment.getCommonVersion();
        for (IProject aProject : rslDeployment.getProjects()) {
            String projectName = aProject.getName();
            try {
                ProjectDescriptor project = this.ruleServiceLoader.resolveProject(deploymentName, deploymentVersion, projectName);
                if (project == null) continue;
                List modules = project.getModules();
                if (!modules.isEmpty()) {
                    project = ((Module)modules.iterator().next()).getProject();
                    for (Module m : modules) {
                        dependencyLoaders.add((IDependencyLoader)new RuleServiceDependencyLoader(project, m, this));
                    }
                }
                if (project == null) continue;
                dependencyLoaders.add((IDependencyLoader)new RuleServiceDependencyLoader(project, null, this));
            }
            catch (Exception e) {
                throw new DependencyLoaderInitializationException(String.format("Failed to initialize dependency loaders for project '%s' in deployment '%s'.", projectName, deploymentName), (Throwable)e);
            }
        }
        return dependencyLoaders;
    }

    private static class CompilationInfo {
        long time;
        long embeddedTime;

        private CompilationInfo() {
        }
    }
}

