/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.CompiledOpenClass;
import org.openl.OpenClassUtil;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.Severity;
import org.openl.rules.common.CommonVersion;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.ruleservice.conf.ServiceConfigurer;
import org.openl.rules.ruleservice.core.DeploymentDescription;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationException;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactory;
import org.openl.rules.ruleservice.core.RuleServiceRedeployLock;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.core.ServiceDescription;
import org.openl.rules.ruleservice.loader.DataSourceListener;
import org.openl.rules.ruleservice.loader.DeploymentsUpdatedEvent;
import org.openl.rules.ruleservice.loader.RuleServiceLoader;
import org.openl.rules.ruleservice.management.ServiceManager;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.rules.ruleservice.publish.RuleServicePublisherListener;
import org.openl.rules.ruleservice.servlet.ServiceInfo;
import org.openl.rules.ruleservice.servlet.ServiceInfoProvider;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.EventListener;

public class ServiceManagerImpl
implements ServiceManager,
DataSourceListener,
ServiceInfoProvider,
InitializingBean {
    private final Logger log = LoggerFactory.getLogger(ServiceManagerImpl.class);
    private RuleServiceInstantiationFactory ruleServiceInstantiationFactory;
    private ServiceConfigurer serviceConfigurer;
    private RuleServiceLoader ruleServiceLoader;
    private final Map<String, ServiceDescription> services = new ConcurrentHashMap<String, ServiceDescription>();
    private final Map<String, OpenLService> services2 = new ConcurrentHashMap<String, OpenLService>();
    private final Map<String, Date> startDates = new ConcurrentHashMap<String, Date>();
    private Collection<RuleServicePublisher> supportedPublishers;
    private Collection<RuleServicePublisherListener> listeners = Collections.emptyList();
    private ServiceDescription serviceDescriptionInProcess;

    public void setRuleServiceLoader(RuleServiceLoader ruleServiceLoader) {
        if (this.ruleServiceLoader != null) {
            this.ruleServiceLoader.setListener(null);
        }
        this.ruleServiceLoader = ruleServiceLoader;
        if (this.ruleServiceLoader != null) {
            this.ruleServiceLoader.setListener(this);
        }
    }

    public void setRuleServiceInstantiationFactory(RuleServiceInstantiationFactory ruleServiceInstantiationFactory) {
        this.ruleServiceInstantiationFactory = Objects.requireNonNull(ruleServiceInstantiationFactory, "ruleServiceInstantiationFactory cannot be null");
    }

    public void setServiceConfigurer(ServiceConfigurer serviceConfigurer) {
        this.serviceConfigurer = Objects.requireNonNull(serviceConfigurer, "serviceConfigurer cannot be null");
    }

    @Autowired(required=false)
    public void setListeners(Collection<RuleServicePublisherListener> listeners) {
        this.listeners = listeners;
    }

    @Autowired
    public void setSupportedPublishers(Collection<RuleServicePublisher> supportedPublishers) {
        this.supportedPublishers = supportedPublishers;
    }

    @Override
    public void start() {
        this.log.info("Assembling services after service manager start.");
        this.processServices();
    }

    @Override
    @EventListener(value={DeploymentsUpdatedEvent.class})
    public void onDeploymentAdded() {
        this.log.info("Assembling services after data source modification.");
        this.processServices();
    }

    private synchronized void processServices() {
        Map<String, ServiceDescription> newServices = this.gatherServicesToBeDeployed();
        this.undeployUnnecessary(newServices);
        this.deployServices(newServices);
    }

    private Map<String, ServiceDescription> gatherServicesToBeDeployed() {
        try {
            Collection<ServiceDescription> servicesToBeDeployed = this.serviceConfigurer.getServicesToBeDeployed(this.ruleServiceLoader);
            HashMap<String, ServiceDescription> services = new HashMap<String, ServiceDescription>();
            for (ServiceDescription serviceDescription : servicesToBeDeployed) {
                services.put(serviceDescription.getDeployPath(), serviceDescription);
            }
            return services;
        }
        catch (Exception e) {
            this.log.error("Failed to gather services to be deployed.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private void undeployUnnecessary(Map<String, ServiceDescription> newServices) {
        for (String deployPath : this.services.keySet().toArray(StringUtils.EMPTY_STRING_ARRAY)) {
            if (newServices.containsKey(deployPath)) continue;
            try {
                this.undeploy(this.services.get(deployPath));
            }
            catch (Exception e) {
                this.log.error("Failed to undeploy service '{}'.", (Object)deployPath, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployServices(Map<String, ServiceDescription> newServices) {
        Map<DeploymentDescription, List<ServiceDescription>> groupedServices = newServices.values().stream().collect(Collectors.groupingBy(ServiceDescription::getDeployment));
        Lock lock = RuleServiceRedeployLock.getInstance().getWriteLock();
        try {
            lock.lock();
            for (List<ServiceDescription> serviceDescriptionsForDeployment : groupedServices.values()) {
                if (!this.hasAtLeastOneToDeploy(serviceDescriptionsForDeployment)) continue;
                for (ServiceDescription serviceDescription : serviceDescriptionsForDeployment) {
                    ServiceDescription old = this.services.get(serviceDescription.getDeployPath());
                    if (old == null) continue;
                    try {
                        this.undeploy(old);
                    }
                    catch (Exception e) {
                        this.log.error("Failed to undeploy service '{}'.", (Object)serviceDescription.getDeployPath(), (Object)e);
                    }
                }
                for (ServiceDescription serviceDescription : serviceDescriptionsForDeployment) {
                    try {
                        this.deploy(serviceDescription);
                    }
                    catch (Exception | LinkageError e) {
                        this.log.error("Failed to deploy service '{}'.", (Object)serviceDescription.getDeployPath(), (Object)e);
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private boolean hasAtLeastOneToDeploy(List<ServiceDescription> serviceDescriptionsForCurrentDeployment) {
        for (ServiceDescription serviceDescription : serviceDescriptionsForCurrentDeployment) {
            ServiceDescription old = this.services.get(serviceDescription.getDeployPath());
            if (old != null) {
                CommonVersion oldVersion = old.getDeployment().getVersion();
                if (oldVersion.compareTo((Object)serviceDescription.getDeployment().getVersion()) == 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(ServiceDescription serviceDescription) throws RuleServiceUndeployException {
        Objects.requireNonNull(serviceDescription, "service cannot be null");
        String serviceName = serviceDescription.getDeployPath();
        OpenLService service = this.getServiceByDeploy(serviceName);
        try {
            this.serviceDescriptionInProcess = serviceDescription;
            this.undeploy(serviceName);
            this.log.info("Service '{}' has been undeployed successfully.", (Object)serviceName);
        }
        finally {
            this.serviceDescriptionInProcess = null;
            this.startDates.remove(serviceName);
            this.services.remove(serviceName);
            try {
                ClassLoader classloader = service.getClassLoader();
                OpenClassUtil.releaseClassLoader((ClassLoader)classloader);
            }
            catch (RuleServiceInstantiationException ruleServiceInstantiationException) {}
            this.cleanDeploymentResources(serviceDescription);
        }
    }

    private void cleanDeploymentResources(ServiceDescription serviceDescription) {
        boolean foundServiceWithThisDeployment = false;
        for (ServiceDescription sd : this.services.values()) {
            if (!sd.getDeployment().equals(serviceDescription.getDeployment())) continue;
            foundServiceWithThisDeployment = true;
            break;
        }
        if (!foundServiceWithThisDeployment) {
            this.ruleServiceInstantiationFactory.clean(serviceDescription);
        }
    }

    private void deploy(ServiceDescription serviceDescription) throws RuleServiceDeployException {
        String servicePath = serviceDescription.getDeployPath();
        if (this.getServiceByDeploy(servicePath) != null) {
            throw new RuleServiceDeployException(String.format("The service with path '%s' is already deployed.", servicePath));
        }
        try {
            this.serviceDescriptionInProcess = serviceDescription;
            OpenLService newService = this.ruleServiceInstantiationFactory.createService(serviceDescription);
            this.serviceDescriptionInProcess = serviceDescription;
            this.deploy(newService);
            this.log.info("Service '{}' has been deployed successfully.", (Object)servicePath);
        }
        catch (RuleServiceInstantiationException e) {
            throw new RuleServiceDeployException("Failed on deploy a service.", (Throwable)((Object)e));
        }
        finally {
            this.serviceDescriptionInProcess = null;
            this.services.put(servicePath, serviceDescription);
            this.startDates.put(servicePath, new Date());
        }
    }

    public RulesDeploy getRulesDeployInProcess() {
        return this.serviceDescriptionInProcess != null ? this.serviceDescriptionInProcess.getRulesDeploy() : null;
    }

    public ServiceDescription getServiceDescriptionInProcess() {
        return this.serviceDescriptionInProcess;
    }

    @Override
    public Collection<String> getServiceErrors(String deployPath) {
        Collection messages;
        Collection openLMessages;
        List<String> errors;
        OpenLService service = this.getServiceByDeploy(deployPath);
        if (service == null) {
            return null;
        }
        CompiledOpenClass openClass = service.getCompiledOpenClass();
        if (openClass != null && !(errors = (openLMessages = OpenLMessagesUtils.filterMessagesBySeverity((Collection)(messages = openClass.getAllMessages()), (Severity)Severity.ERROR)).stream().map(OpenLMessage::getSummary).collect(Collectors.toList())).isEmpty()) {
            return errors;
        }
        Throwable exception = service.getException();
        return exception != null ? Collections.singleton(exception.toString()) : Collections.emptyList();
    }

    @Override
    public Manifest getManifest(String deployPath) {
        ServiceDescription service = this.services.get(deployPath);
        if (service == null) {
            return null;
        }
        return service.getManifest();
    }

    @Override
    public Collection<ServiceInfo> getServicesInfo() {
        return this.services.values().stream().map(s -> {
            Optional<OpenLService> serviceByName = Optional.ofNullable(this.getServiceByDeploy(s.getDeployPath()));
            return new ServiceInfo(this.startDates.get(s.getDeployPath()), s.getName(), serviceByName.map(ServiceManagerImpl::hasError).orElse(true), serviceByName.map(OpenLService::getUrls).orElseGet(Collections::emptyMap), s.getDeployPath(), s.getManifest() != null, serviceByName.map(OpenLService::getDeployment).map(DeploymentDescription::getName).orElse(null));
        }).sorted(Comparator.comparing(ServiceInfo::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    @Override
    public boolean isReady() {
        return this.ruleServiceLoader.isReady();
    }

    private void setUrls(OpenLService service) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.supportedPublishers.forEach(publisher -> {
            if (publisher.getServiceByDeploy(service.getDeployPath()) != null) {
                String url = publisher.getUrl(service);
                result.put(publisher.name(), url);
            }
        });
        service.setUrls(result);
    }

    private static boolean hasError(OpenLService service) {
        CompiledOpenClass compiledOpenClass;
        if (service.getCompiledOpenClass() == null && service.getException() == null) {
            try {
                service.getClassLoader();
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                service.setException(rootCause);
            }
        }
        return (compiledOpenClass = service.getCompiledOpenClass()) == null || service.getException() != null || compiledOpenClass.hasErrors();
    }

    @Override
    public void deploy(OpenLService service) throws RuleServiceDeployException {
        Objects.requireNonNull(service, "service cannot be null");
        String servicePath = service.getDeployPath();
        Collection<String> sp = service.getPublishers();
        ArrayList<RuleServicePublisher> publishers = new ArrayList<RuleServicePublisher>();
        if (this.supportedPublishers.size() > 1) {
            for (String p : sp) {
                Optional<RuleServicePublisher> publisher = this.supportedPublishers.stream().filter(n -> n.name().equalsIgnoreCase(p)).findFirst();
                if (publisher.isPresent()) {
                    publishers.add((RuleServicePublisher)publisher.get());
                    continue;
                }
                this.log.warn("Publisher for '{}' is not registered. Please, check the configuration for service '{}'.", (Object)p, (Object)servicePath);
            }
        } else {
            publishers.addAll(this.supportedPublishers);
        }
        Object e1 = null;
        ArrayList<RuleServicePublisher> deployedPublishers = new ArrayList<RuleServicePublisher>();
        if (!publishers.isEmpty()) {
            for (RuleServicePublisher publisher : publishers) {
                try {
                    publisher.deploy(service);
                    deployedPublishers.add(publisher);
                }
                catch (RuleServiceDeployException e) {
                    Throwable rootCause = ExceptionUtils.getRootCause((Throwable)((Object)e));
                    service.setException(rootCause);
                    e1 = e;
                    break;
                }
            }
        } else {
            try {
                service.getClassLoader();
            }
            catch (Exception e) {
                e1 = e;
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                service.setException(rootCause);
            }
        }
        this.services2.put(servicePath, service);
        if (e1 != null) {
            for (RuleServicePublisher publisher : deployedPublishers) {
                try {
                    publisher.undeploy(service);
                }
                catch (RuleServiceUndeployException e) {
                    this.log.error("Failed to undeploy service '{}'.", (Object)servicePath, (Object)e);
                }
            }
            throw new RuleServiceDeployException("Failed to deploy service.", (Throwable)e1);
        }
        this.setUrls(service);
        this.fireDeployListeners(service);
    }

    private void fireDeployListeners(OpenLService service) {
        for (RuleServicePublisherListener listener : this.listeners) {
            listener.onDeploy(service);
        }
    }

    @Override
    public OpenLService getServiceByDeploy(String deployPath) {
        Objects.requireNonNull(deployPath, "servicePath cannot be null");
        return this.services2.get(deployPath);
    }

    @Override
    public Collection<OpenLService> getServices() {
        return Collections.unmodifiableCollection(this.services2.values());
    }

    @Override
    public Collection<OpenLService> getServicesByDeployment(String deploymentName) {
        return this.services2.values().stream().filter(service -> service.getDeployment().getName().equals(deploymentName)).collect(Collectors.toList());
    }

    @Override
    public void undeploy(String deployPath) throws RuleServiceUndeployException {
        Objects.requireNonNull(deployPath, "deployPath cannot be null");
        OpenLService undeployService = this.services2.get(deployPath);
        Objects.requireNonNull(undeployService, String.format("Service '%s' has not been found.", deployPath));
        RuleServiceUndeployException e1 = null;
        for (RuleServicePublisher publisher : this.supportedPublishers) {
            if (publisher.getServiceByDeploy(deployPath) == null) continue;
            try {
                publisher.undeploy(undeployService);
            }
            catch (RuleServiceUndeployException e) {
                e1 = e;
            }
        }
        if (e1 == null) {
            ConfigurableApplicationContext serviceContext = undeployService.getServiceContext();
            if (serviceContext != null) {
                serviceContext.close();
            }
        } else {
            throw new RuleServiceUndeployException("Failed to undeploy a service.", (Throwable)((Object)e1));
        }
        undeployService.setServiceContext(null);
        this.services2.remove(deployPath);
        this.fireUndeployListeners(deployPath);
    }

    private void fireUndeployListeners(String deployPath) {
        for (RuleServicePublisherListener listener : this.listeners) {
            listener.onUndeploy(deployPath);
        }
    }

    public void afterPropertiesSet() {
        if (CollectionUtils.isEmpty(this.supportedPublishers)) {
            throw new BeanInitializationException("At least one supported publisher must be registered.");
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.undeployUnnecessary(Collections.emptyMap());
    }
}

