/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.simple;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.rules.ruleservice.simple.RulesFrontend;
import org.openl.rules.ruleservice.simple.RulesFrontendImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClassRuleServicePublisher
implements RuleServicePublisher {
    private final Logger log = LoggerFactory.getLogger(JavaClassRuleServicePublisher.class);
    private RulesFrontend frontend = new RulesFrontendImpl();
    private final Map<String, OpenLService> runningServices = new HashMap<String, OpenLService>();

    public RulesFrontend getFrontend() {
        return this.frontend;
    }

    @Override
    public OpenLService getServiceByDeploy(String deployPath) {
        Objects.requireNonNull(deployPath, "deployPath cannot be null");
        return this.runningServices.get(deployPath);
    }

    @Override
    public void deploy(OpenLService service) throws RuleServiceDeployException {
        Objects.requireNonNull(service, "service cannot be null");
        try {
            OpenLService registeredService = this.frontend.findServiceByName(service.getName());
            if (registeredService != null) {
                throw new RuleServiceDeployException(String.format("Service '%s' is already deployed.", service.getName()));
            }
            this.frontend.registerService(service);
            this.runningServices.put(service.getDeployPath(), service);
            this.log.info("Service '{}' has been deployed successfully.", (Object)service.getName());
        }
        catch (Exception e) {
            throw new RuleServiceDeployException("Failed to deploy a service.", e);
        }
    }

    @Override
    public void undeploy(OpenLService service) throws RuleServiceUndeployException {
        Objects.requireNonNull(service, "service cannot be null");
        String deployPath = service.getDeployPath();
        Objects.requireNonNull(deployPath, "deployPath cannot be null");
        this.frontend.unregisterService(service.getName());
        if (this.runningServices.remove(deployPath) == null) {
            throw new RuleServiceUndeployException(String.format("Service '%s' has not been deployed.", deployPath));
        }
        this.log.info("Service '{}' has been undeployed successfully.", (Object)deployPath);
    }

    public void setFrontend(RulesFrontend frontend) {
        this.frontend = Objects.requireNonNull(frontend, "frontend cannot be null");
    }

    @Override
    public String getUrl(OpenLService service) {
        return null;
    }

    @Override
    public String name() {
        return "JAVA";
    }
}

