/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.variation;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@Deprecated
public class VariationsResult<T> {
    private byte[] data;
    private Map<String, T> variationResults = new LinkedHashMap<String, T>();
    private Map<String, String> variationFailures = new LinkedHashMap<String, String>();

    public void registerResult(String variationID, T result) {
        this.variationResults.put(variationID, result);
    }

    public void registerFailure(String variationID, String errorMessage) {
        this.variationFailures.put(variationID, errorMessage);
    }

    public T getResultForVariation(String variationID) {
        return this.variationResults.get(variationID);
    }

    public String getFailureErrorForVariation(String variationID) {
        return this.variationFailures.get(variationID);
    }

    public Map<String, T> getVariationResults() {
        return Collections.unmodifiableMap(this.variationResults);
    }

    public void setVariationResults(Map<String, T> variationResults) {
        this.variationResults = variationResults;
    }

    public Map<String, String> getVariationFailures() {
        return Collections.unmodifiableMap(this.variationFailures);
    }

    public void setVariationFailures(Map<String, String> variationFailures) {
        this.variationFailures = variationFailures;
    }

    @XmlTransient
    public String[] getCalculatedVariationIDs() {
        String[] ids = new String[this.variationResults.size()];
        int i = 0;
        for (String variationID : this.variationResults.keySet()) {
            ids[i++] = variationID;
        }
        return ids;
    }

    @XmlTransient
    public String[] getFailedVariationIDs() {
        String[] ids = new String[this.variationFailures.size()];
        int i = 0;
        for (String variationID : this.variationFailures.keySet()) {
            ids[i++] = variationID;
        }
        return ids;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack() throws IOException {
        if (this.data != null) {
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(this.data);
            Hessian2Input input = new Hessian2Input((InputStream)byteInputStream);
            try {
                input.startMessage();
                this.variationFailures = (Map)input.readObject();
                this.variationResults = (Map)input.readObject();
                input.completeMessage();
                input.close();
            }
            finally {
                try {
                    byteInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void pack() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Hessian2Output out = new Hessian2Output((OutputStream)byteArrayOutputStream);
        try {
            out.startMessage();
            out.writeObject(this.variationFailures);
            out.writeObject(this.variationResults);
            out.completeMessage();
            out.close();
            this.data = byteArrayOutputStream.toByteArray();
            this.variationFailures.clear();
            this.variationResults.clear();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @XmlTransient
    public String[] getAllProcessedVariationIDs() {
        String[] failedIDs = this.getFailedVariationIDs();
        String[] calculatedIDs = this.getCalculatedVariationIDs();
        String[] ids = new String[failedIDs.length + calculatedIDs.length];
        System.arraycopy(calculatedIDs, 0, ids, 0, calculatedIDs.length);
        System.arraycopy(failedIDs, 0, ids, calculatedIDs.length, failedIDs.length);
        return ids;
    }
}

