/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.IOException;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCells;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class CustomizedSXSSFWorkbook
extends SXSSFWorkbook {
    CustomizedSXSSFSheet createAndRegisterSXSSFSheet(XSSFSheet xSheet) {
        CustomizedSXSSFSheet sxSheet;
        try {
            sxSheet = new CustomizedSXSSFSheet(this, xSheet);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.registerSheetMapping(sxSheet, xSheet);
        return sxSheet;
    }

    private static class CustomizedSXSSFSheet
    extends SXSSFSheet {
        public CustomizedSXSSFSheet(SXSSFWorkbook workbook, XSSFSheet xSheet) throws IOException {
            super(workbook, xSheet);
        }

        public int addMergedRegionUnsafe(CellRangeAddress region) {
            CTWorksheet worksheet = this._sh.getCTWorksheet();
            CTMergeCells ctMergeCells = worksheet.isSetMergeCells() ? worksheet.getMergeCells() : worksheet.addNewMergeCells();
            CTMergeCell ctMergeCell = ctMergeCells.addNewMergeCell();
            ctMergeCell.setRef(region.formatAsString());
            return 0;
        }
    }
}

