/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.Objects;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.NodeUsage;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.util.text.TextInfo;

public class SimpleNodeUsage
implements NodeUsage {
    private final int start;
    private final int end;
    private final String description;
    private final String uri;
    private final NodeType nodeType;

    public SimpleNodeUsage(int start, int end, String description, String uri, NodeType nodeType) {
        this.start = start;
        this.end = end;
        this.description = description;
        this.uri = uri;
        this.nodeType = nodeType;
    }

    public SimpleNodeUsage(IdentifierNode identifierNode, String description, String uri, NodeType nodeType) {
        this.nodeType = nodeType;
        this.start = identifierNode.getLocation().getStart().getAbsolutePosition(new TextInfo(identifierNode.getIdentifier()));
        this.end = identifierNode.getLocation().getEnd().getAbsolutePosition(new TextInfo(identifierNode.getIdentifier())) - 1;
        this.description = description;
        this.uri = uri;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleNodeUsage that = (SimpleNodeUsage)o;
        return this.start == that.start && this.end == that.end && Objects.equals(this.description, that.description) && Objects.equals(this.uri, that.uri) && this.nodeType == that.nodeType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.start, this.end, this.description, this.uri, this.nodeType});
    }
}

