/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.FieldUsageSearcher;
import org.openl.binding.impl.MethodUsagesSearcher;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.NodeUsageComparator;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.engine.OpenLCodeManager;
import org.openl.engine.OpenLCompileManager;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.CompositeSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.CollectionUtils;

public class OpenLCellExpressionsCompiler {
    public static void compileMethod(OpenL openl, IOpenSourceCodeModule source, CompositeMethod compositeMethod, IBindingContext bindingContext) {
        OpenLCompileManager compileManager = new OpenLCompileManager(openl);
        compileManager.compileMethod(source, compositeMethod, bindingContext);
    }

    public static CompositeMethod makeMethod(OpenL openl, IOpenSourceCodeModule source, IOpenMethodHeader methodHeader, IBindingContext bindingContext) {
        OpenLCodeManager codeManager = new OpenLCodeManager(openl);
        return codeManager.makeMethod(source, methodHeader, bindingContext);
    }

    public static CompositeMethod makeMethodWithUnknownType(OpenL openl, IOpenSourceCodeModule source, String methodName, IMethodSignature signature, IOpenClass declaringClass, IBindingContext bindingContext) {
        OpenLCodeManager codeManager = new OpenLCodeManager(openl);
        return codeManager.makeMethodWithUnknownType(source, methodName, signature, declaringClass, bindingContext);
    }

    public static List<CellMetaInfo> getMetaInfo(IOpenSourceCodeModule source, CompositeMethod method) {
        int startIndex = 0;
        if (source instanceof CompositeSourceCodeModule) {
            return OpenLCellExpressionsCompiler.getMetaInfoForCompositeSource(method, (CompositeSourceCodeModule)source, startIndex);
        }
        IOpenSourceCodeModule src = source;
        while (src instanceof SubTextSourceCodeModule) {
            startIndex += src.getStartPosition();
            src = ((SubTextSourceCodeModule)src).getBaseModule();
        }
        if (src instanceof GridCellSourceCodeModule) {
            List<NodeUsage> nodeUsages = OpenLCellExpressionsCompiler.getNodeUsages(method, source.getCode(), startIndex);
            return Collections.singletonList(OpenLCellExpressionsCompiler.getCellMetaInfoOrNull(nodeUsages));
        }
        return Collections.singletonList(null);
    }

    public static List<NodeUsage> getNodeUsages(CompositeMethod method, String sourceString, int startIndex) {
        if (method == null) {
            return Collections.emptyList();
        }
        ArrayList<NodeUsage> nodeUsages = new ArrayList<NodeUsage>(MethodUsagesSearcher.findAllMethods((IBoundNode)method.getMethodBodyBoundNode(), sourceString, startIndex));
        FieldUsageSearcher.findAllFields(nodeUsages, (IBoundNode)method.getMethodBodyBoundNode(), sourceString, startIndex);
        Collections.sort(nodeUsages, new NodeUsageComparator());
        return nodeUsages;
    }

    private static List<CellMetaInfo> getMetaInfoForCompositeSource(CompositeMethod method, CompositeSourceCodeModule source, int startIndex) {
        List<NodeUsage> nodeUsages = OpenLCellExpressionsCompiler.getNodeUsages(method, source.getCode(), startIndex);
        IOpenSourceCodeModule[] modules = source.getModules();
        int moduleStart = 0;
        ArrayList<CellMetaInfo> metaInfoList = new ArrayList<CellMetaInfo>();
        for (IOpenSourceCodeModule module : modules) {
            int moduleEnd = moduleStart + module.getCode().length();
            if (module instanceof GridCellSourceCodeModule) {
                ArrayList<NodeUsage> currentCellMethodUsages = new ArrayList<NodeUsage>();
                for (NodeUsage usage : nodeUsages) {
                    if (usage.getStart() < moduleStart || usage.getEnd() > moduleEnd) continue;
                    if (usage instanceof MethodUsagesSearcher.MethodUsage) {
                        currentCellMethodUsages.add(new MethodUsagesSearcher.MethodUsage(usage.getStart() - moduleStart, usage.getEnd() - moduleStart, ((MethodUsagesSearcher.MethodUsage)usage).getMethod()));
                        continue;
                    }
                    currentCellMethodUsages.add(new SimpleNodeUsage(usage.getStart() - moduleStart, usage.getEnd() - moduleStart, usage.getDescription(), usage.getUri(), usage.getNodeType()));
                }
                metaInfoList.add(OpenLCellExpressionsCompiler.getCellMetaInfoOrNull(currentCellMethodUsages));
            } else {
                metaInfoList.add(null);
            }
            moduleStart = moduleEnd + 1;
        }
        return metaInfoList;
    }

    private static CellMetaInfo getCellMetaInfoOrNull(List<NodeUsage> methodUsages) {
        if (CollectionUtils.isNotEmpty(methodUsages)) {
            return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, methodUsages);
        }
        return null;
    }
}

