/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.grid;

import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;
import org.openl.excel.grid.ParsedGrid;
import org.openl.excel.parser.TableStyles;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsUtil;

public class ParsedCell
implements ICell {
    private static final Object NOT_DEFINED = new Object();
    private final int row;
    private final int column;
    private final ParsedGrid grid;
    private Object value = NOT_DEFINED;
    private IGridRegion region;
    private transient TableStyles tableStyles;

    ParsedCell(int row, int column, ParsedGrid grid) {
        this.row = row;
        this.column = column;
        this.grid = grid;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getAbsoluteRow() {
        return this.getRow();
    }

    @Override
    public int getAbsoluteColumn() {
        return this.getColumn();
    }

    @Override
    public IGridRegion getAbsoluteRegion() {
        IGridRegion absoluteRegion = this.getRegion();
        if (absoluteRegion == null) {
            absoluteRegion = new GridRegion(this.row, this.column, this.row, this.column);
        }
        return absoluteRegion;
    }

    @Override
    public int getWidth() {
        IGridRegion region = this.getRegion();
        return region == null ? 1 : region.getRight() - region.getLeft() + 1;
    }

    @Override
    public int getHeight() {
        IGridRegion region = this.getRegion();
        return region == null ? 1 : region.getBottom() - region.getTop() + 1;
    }

    @Override
    public ICellStyle getStyle() {
        return this.grid.getCellStyle(this.row, this.column);
    }

    @Override
    public Object getObjectValue() {
        if (this.value == NOT_DEFINED) {
            this.value = this.grid.getCellValue(this.row, this.column);
        }
        return this.value;
    }

    @Override
    public String getStringValue() {
        Object value = this.getObjectValue();
        return value == null ? null : String.valueOf(value);
    }

    @Override
    public ICellFont getFont() {
        this.initializeStyles();
        return this.tableStyles == null ? null : this.tableStyles.getFont(this.row, this.column);
    }

    @Override
    public IGridRegion getRegion() {
        if (this.region == null) {
            this.region = this.grid.getRegion(this.row, this.column);
        }
        return this.region;
    }

    @Override
    public String getFormula() {
        this.initializeStyles();
        return this.tableStyles == null ? null : this.tableStyles.getFormula(this.row, this.column);
    }

    @Override
    public int getType() {
        Object value = this.getObjectValue();
        if (value == null) {
            return 3;
        }
        if (value instanceof Boolean) {
            return 4;
        }
        if (value instanceof Number || value instanceof Date) {
            return 0;
        }
        if (value instanceof String) {
            return 1;
        }
        return 5;
    }

    @Override
    public String getUri() {
        return XlsUtil.xlsCellPresentation(this.column, this.row);
    }

    @Override
    public boolean hasNativeType() {
        return true;
    }

    @Override
    public int getNativeType() {
        return this.getType();
    }

    @Override
    public double getNativeNumber() {
        Object value = this.getObjectValue();
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Date) {
            return DateUtil.getExcelDate((Date)((Date)value), (boolean)this.grid.isUse1904Windowing());
        }
        return Double.NaN;
    }

    @Override
    public boolean getNativeBoolean() {
        Object value = this.getObjectValue();
        return value == null ? false : (Boolean)value;
    }

    @Override
    public Date getNativeDate() {
        Object value = this.getObjectValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return DateUtil.getJavaDate((double)((Number)value).doubleValue(), (boolean)this.grid.isUse1904Windowing());
        }
        return null;
    }

    @Override
    public ICellComment getComment() {
        this.initializeStyles();
        return this.tableStyles == null ? null : this.tableStyles.getComment(this.row, this.column);
    }

    @Override
    public ICell getTopLeftCellFromRegion() {
        IGridRegion region = this.getRegion();
        return region == null ? this : this.grid.getCell(region.getLeft(), region.getTop());
    }

    private void initializeStyles() {
        if (this.tableStyles == null) {
            this.tableStyles = this.grid.getTableStyles(this.row, this.column);
        }
    }
}

