/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.grid;

import java.util.List;
import org.openl.excel.grid.ParsedGrid;
import org.openl.excel.grid.SequentialXlsSheetSourceCodeModule;
import org.openl.excel.parser.ExcelReader;
import org.openl.excel.parser.ExcelReaderFactory;
import org.openl.excel.parser.SheetDescriptor;
import org.openl.rules.lang.xls.IncludeSearcher;
import org.openl.rules.lang.xls.TablePartProcessor;
import org.openl.rules.lang.xls.XlsLoader;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.syntax.WorksheetSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.source.IOpenSourceCodeModule;

public class SequentialXlsLoader
extends XlsLoader {
    public SequentialXlsLoader(IncludeSearcher includeSeeker) {
        super(includeSeeker);
    }

    @Override
    protected WorksheetSyntaxNode[] createWorksheetNodes(TablePartProcessor tablePartProcessor, XlsWorkbookSourceCodeModule workbookSourceModule) {
        String path;
        IOpenSourceCodeModule source = workbookSourceModule.getSource();
        if ("<virtual_uri>".equals(source.getUri())) {
            return super.createWorksheetNodes(tablePartProcessor, workbookSourceModule);
        }
        ExcelReaderFactory factory = ExcelReaderFactory.sequentialFactory();
        try {
            path = workbookSourceModule.getSourceFile().getAbsolutePath();
        }
        catch (Exception ex) {
            path = null;
        }
        try (ExcelReader excelReader = path == null ? factory.create(source.getByteStream()) : factory.create(path);){
            List<? extends SheetDescriptor> sheets = excelReader.getSheets();
            boolean use1904Windowing = excelReader.isUse1904Windowing();
            int nsheets = sheets.size();
            WorksheetSyntaxNode[] sheetNodes = new WorksheetSyntaxNode[nsheets];
            for (int i = 0; i < nsheets; ++i) {
                SheetDescriptor sheet = sheets.get(i);
                SequentialXlsSheetSourceCodeModule sheetSource = new SequentialXlsSheetSourceCodeModule(workbookSourceModule, sheet);
                Object[][] cells = excelReader.getCells(sheet);
                IGridTable[] tables = new ParsedGrid(path, sheetSource, sheet, cells, use1904Windowing).getTables();
                sheetNodes[i] = this.createWorksheetSyntaxNode(tablePartProcessor, sheetSource, tables);
            }
            WorksheetSyntaxNode[] worksheetSyntaxNodeArray = sheetNodes;
            return worksheetSyntaxNodeArray;
        }
    }
}

