/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.openl.excel.parser.ExcelParseException;
import org.openl.excel.parser.ExcelReader;
import org.openl.excel.parser.dom.DOMReader;
import org.openl.excel.parser.event.EventReader;
import org.openl.excel.parser.sax.SAXReader;
import org.openl.util.IOUtils;

public abstract class ExcelReaderFactory {
    public static ExcelReaderFactory sequentialFactory() {
        return new SequentialExcelReaderFactory();
    }

    public static ExcelReaderFactory fullReadFactory() {
        return new FullReadExcelReaderFactory();
    }

    private ExcelReaderFactory() {
    }

    public final ExcelReader create(String fileName) {
        return this.create(fileName, null);
    }

    public final ExcelReader create(InputStream inputStream) {
        return this.create(null, inputStream);
    }

    protected abstract ExcelReader create(String var1, InputStream var2);

    private static class FullReadExcelReaderFactory
    extends ExcelReaderFactory {
        private FullReadExcelReaderFactory() {
        }

        @Override
        public ExcelReader create(String fileName, InputStream is) {
            return fileName != null ? new DOMReader(fileName) : new DOMReader(is);
        }
    }

    private static class SequentialExcelReaderFactory
    extends ExcelReaderFactory {
        private SequentialExcelReaderFactory() {
        }

        @Override
        public ExcelReader create(String fileName, InputStream is) {
            EventReader eventReader;
            InputStream tempStream;
            boolean useFile;
            block6: {
                boolean bl = useFile = fileName != null;
                if (useFile && is != null) {
                    throw new IllegalArgumentException("Only one argument can be non-null");
                }
                tempStream = null;
                tempStream = FileMagic.prepareToCheckMagic((InputStream)(useFile ? new FileInputStream(fileName) : is));
                if (!SequentialExcelReaderFactory.isXlsx(tempStream)) break block6;
                SAXReader sAXReader = useFile ? new SAXReader(fileName) : new SAXReader(tempStream);
                IOUtils.closeQuietly((Closeable)tempStream);
                return sAXReader;
            }
            try {
                eventReader = useFile ? new EventReader(fileName) : new EventReader(tempStream);
            }
            catch (IOException e) {
                try {
                    throw new ExcelParseException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(tempStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)tempStream);
            return eventReader;
        }

        private static boolean isXlsx(InputStream is) throws IOException {
            FileMagic fm = FileMagic.valueOf((InputStream)is);
            switch (fm) {
                case OLE2: {
                    return false;
                }
                case OOXML: {
                    return true;
                }
            }
            throw new ExcelParseException("Unknown file format");
        }
    }
}

