/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.dom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openl.excel.parser.AlignedValue;
import org.openl.excel.parser.ExcelParseException;
import org.openl.excel.parser.ExcelReader;
import org.openl.excel.parser.ExcelUtils;
import org.openl.excel.parser.MergedCell;
import org.openl.excel.parser.SheetDescriptor;
import org.openl.excel.parser.TableStyles;
import org.openl.excel.parser.dom.DOMSheetDescriptor;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsCellComment;
import org.openl.rules.table.xls.XlsCellFont;
import org.openl.rules.table.xls.XlsCellStyle;
import org.openl.util.FileTool;
import org.openl.util.FileUtils;
import org.openl.util.NumberUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOMReader
implements ExcelReader {
    private final Logger log = LoggerFactory.getLogger(DOMReader.class);
    private final String fileName;
    private File tempFile;
    private Workbook workbook;

    public DOMReader(String fileName) {
        this.fileName = fileName;
        ExcelUtils.configureZipBombDetection();
    }

    public DOMReader(InputStream is) {
        this.tempFile = FileTool.toTempFile((InputStream)is, (String)"stream.xls");
        this.fileName = this.tempFile.getAbsolutePath();
        ExcelUtils.configureZipBombDetection();
    }

    @Override
    public List<? extends SheetDescriptor> getSheets() {
        try {
            this.initializeWorkbook();
            int numberOfSheets = this.workbook.getNumberOfSheets();
            ArrayList<DOMSheetDescriptor> sheets = new ArrayList<DOMSheetDescriptor>(numberOfSheets);
            for (int i = 0; i < numberOfSheets; ++i) {
                sheets.add(new DOMSheetDescriptor(this.workbook.getSheetName(i), i));
            }
            return sheets;
        }
        catch (IOException e) {
            throw new ExcelParseException(e);
        }
    }

    @Override
    public Object[][] getCells(SheetDescriptor sheet) {
        DOMSheetDescriptor domSheet = (DOMSheetDescriptor)sheet;
        try {
            int n;
            short s;
            this.initializeWorkbook();
            Sheet sh = this.workbook.getSheet(sheet.getName());
            int firstRow = sh.getFirstRowNum();
            int lastRow = sh.getLastRowNum();
            boolean hasRows = false;
            int n2 = Integer.MAX_VALUE;
            int lastColumn = 0;
            for (int i = firstRow; i <= lastRow; ++i) {
                int lastCellNum;
                Row row = sh.getRow(i);
                if (row == null) continue;
                hasRows = true;
                short firstCellNum = row.getFirstCellNum();
                if (firstCellNum >= 0 && firstCellNum < s) {
                    s = firstCellNum;
                }
                if ((lastCellNum = row.getLastCellNum() - 1) <= lastColumn) continue;
                lastColumn = lastCellNum;
            }
            if (!hasRows) {
                return new Object[0][];
            }
            if (s == Integer.MAX_VALUE) {
                n = 0;
            }
            domSheet.setFirstRowNum(firstRow);
            domSheet.setFirstColNum(n);
            int rows = lastRow - firstRow + 1;
            int cols = lastColumn - n + 1;
            this.log.debug("Array size: {}:{}", (Object)rows, (Object)cols);
            Object[][] cells = new Object[rows][cols];
            for (int i = firstRow; i <= lastRow; ++i) {
                Row row = sh.getRow(i);
                if (row == null) continue;
                int firstCellNum = row.getFirstCellNum();
                short lastCellNum = row.getLastCellNum();
                for (int j = firstCellNum; j < lastCellNum; ++j) {
                    short indention;
                    Cell cell = row.getCell(j);
                    Object value = this.extractCellValue(cell);
                    if (cell != null && (indention = cell.getCellStyle().getIndention()) > 0) {
                        value = new AlignedValue(value, indention);
                    }
                    cells[i - firstRow][j - n] = value;
                }
            }
            for (CellRangeAddress rangeAddress : sh.getMergedRegions()) {
                int row;
                int firstMergeRow = rangeAddress.getFirstRow();
                int firstMergeCol = rangeAddress.getFirstColumn();
                int lastMergeRow = rangeAddress.getLastRow();
                int lastMergeCol = rangeAddress.getLastColumn();
                for (row = firstMergeRow; row <= lastMergeRow; ++row) {
                    for (int col = firstMergeCol + 1; col <= lastMergeCol; ++col) {
                        cells[row - firstRow][col - n] = MergedCell.MERGE_WITH_LEFT;
                    }
                }
                for (row = firstMergeRow + 1; row <= lastMergeRow; ++row) {
                    cells[row - firstRow][firstMergeCol - n] = MergedCell.MERGE_WITH_UP;
                }
            }
            return cells;
        }
        catch (IOException e) {
            throw new ExcelParseException(e);
        }
    }

    @Override
    public boolean isUse1904Windowing() {
        try {
            this.initializeWorkbook();
            if (this.workbook instanceof XSSFWorkbook) {
                return ((XSSFWorkbook)this.workbook).isDate1904();
            }
            if (this.workbook instanceof HSSFWorkbook) {
                return ((HSSFWorkbook)this.workbook).getInternalWorkbook().isUsing1904DateWindowing();
            }
            throw new UnsupportedOperationException("Unsupported workbook type");
        }
        catch (IOException e) {
            throw new ExcelParseException(e);
        }
    }

    @Override
    public TableStyles getTableStyles(final SheetDescriptor sheet, final IGridRegion tableRegion) {
        try {
            this.initializeWorkbook();
            return new TableStyles(){

                @Override
                public IGridRegion getRegion() {
                    return tableRegion;
                }

                @Override
                public ICellStyle getStyle(int row, int column) {
                    return new XlsCellStyle(this.getCell(row, column).getCellStyle(), DOMReader.this.workbook);
                }

                @Override
                public ICellFont getFont(int row, int column) {
                    Font font = DOMReader.this.workbook.getFontAt(this.getCell(row, column).getCellStyle().getFontIndexAsInt());
                    return new XlsCellFont(font, DOMReader.this.workbook);
                }

                @Override
                public ICellComment getComment(int row, int column) {
                    return new XlsCellComment(this.getCell(row, column).getCellComment());
                }

                @Override
                public String getFormula(int row, int column) {
                    Cell cell = this.getCell(row, column);
                    return cell.getCellType() == CellType.FORMULA ? cell.getCellFormula() : null;
                }

                private Cell getCell(int row, int column) {
                    return DOMReader.this.workbook.getSheet(sheet.getName()).getRow(row).getCell(column);
                }
            };
        }
        catch (IOException e) {
            throw new ExcelParseException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.workbook != null) {
                this.workbook.close();
                this.workbook = null;
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        FileUtils.deleteQuietly((File)this.tempFile);
        this.tempFile = null;
    }

    private void initializeWorkbook() throws IOException {
        if (this.workbook == null) {
            this.workbook = WorkbookFactory.create((File)new File(this.fileName), null, (boolean)true);
        }
    }

    private Object extractCellValue(Cell cell) {
        if (cell != null) {
            CellType type = cell.getCellType();
            if (type == CellType.FORMULA) {
                type = cell.getCachedFormulaResultType();
            }
            switch (type) {
                case BLANK: {
                    return null;
                }
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        return cell.getDateCellValue();
                    }
                    double value = cell.getNumericCellValue();
                    return NumberUtils.intOrDouble((double)value);
                }
                case STRING: {
                    return StringUtils.trimToNull((String)cell.getStringCellValue());
                }
            }
            return "unknown type: " + cell.getCellType();
        }
        return null;
    }
}

