/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.event;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddress;
import org.openl.excel.parser.AlignedValue;
import org.openl.excel.parser.MergedCell;
import org.openl.excel.parser.ParserDateUtil;
import org.openl.excel.parser.SheetDescriptor;
import org.openl.excel.parser.event.EventSheetDescriptor;
import org.openl.excel.parser.event.StyleTrackingListener;
import org.openl.util.NumberUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbookListener
implements HSSFListener {
    private final Logger log = LoggerFactory.getLogger(WorkbookListener.class);
    private final List<EventSheetDescriptor> sheets = new ArrayList<EventSheetDescriptor>();
    private final ParserDateUtil parserDateUtil = new ParserDateUtil();
    private Map<String, Object[][]> cellsMap = new HashMap<String, Object[][]>();
    private boolean use1904Windowing = false;
    private StyleTrackingListener formatListener;
    private boolean sheetsSorted = false;
    private int sheetIndex = -1;
    private SSTRecord sstRecord;
    private boolean outputNextStringRecord;
    private int nextRow;
    private int nextColumn;
    private short indent;

    void process(String fileName) throws IOException {
        try (POIFSFileSystem poifs = new POIFSFileSystem(new File(fileName));){
            this.formatListener = new StyleTrackingListener(this);
            HSSFEventFactory factory = new HSSFEventFactory();
            HSSFRequest request = new HSSFRequest();
            request.addListenerForAllRecords((HSSFListener)this.formatListener);
            factory.processWorkbookEvents(request, poifs);
        }
    }

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 34: {
                DateWindow1904Record d1904 = (DateWindow1904Record)record;
                this.use1904Windowing = d1904.getWindowing() != 0;
                break;
            }
            case 133: {
                BoundSheetRecord bsr = (BoundSheetRecord)record;
                this.sheets.add(new EventSheetDescriptor(bsr.getSheetname(), this.sheets.size(), bsr.getPositionOfBof()));
                break;
            }
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() != 16) break;
                ++this.sheetIndex;
                if (this.sheetsSorted) break;
                Collections.sort(this.sheets, (o1, o2) -> o1.getOffset() - o2.getOffset());
                this.sheetsSorted = true;
                break;
            }
            case 512: {
                DimensionsRecord dr = (DimensionsRecord)record;
                this.getSheet().setFirstRowNum(dr.getFirstRow());
                this.getSheet().setFirstColNum(dr.getFirstCol());
                int rowsCount = dr.getLastRow() - dr.getFirstRow();
                int colsCount = dr.getLastCol() - dr.getFirstCol();
                this.log.debug("Array size: {}:{}", (Object)rowsCount, (Object)colsCount);
                Object[][] cells = new Object[rowsCount][colsCount];
                this.cellsMap.put(this.getSheet().getName(), cells);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                if (!berec.isBoolean()) break;
                Object value = berec.getBooleanValue();
                this.indent = this.formatListener.getIndent((CellValueRecordInterface)berec);
                if (this.indent > 0) {
                    value = new AlignedValue(value, this.indent);
                }
                this.setValue(berec.getRow(), berec.getColumn(), value);
                break;
            }
            case 6: {
                FormulaRecord frec = (FormulaRecord)record;
                int row = frec.getRow();
                short column = frec.getColumn();
                CellType cellType = CellType.forInt((int)frec.getCachedResultType());
                switch (cellType) {
                    case NUMERIC: {
                        Object value = this.getDateOrIntOrDouble((CellValueRecordInterface)frec, frec.getValue());
                        if (this.indent > 0) {
                            value = new AlignedValue(value, this.indent);
                        }
                        this.setValue(row, column, value);
                        break;
                    }
                    case BOOLEAN: {
                        this.setValue(row, column, frec.getCachedBooleanValue());
                        break;
                    }
                    case STRING: {
                        this.outputNextStringRecord = true;
                        this.nextRow = frec.getRow();
                        this.nextColumn = frec.getColumn();
                    }
                }
                this.indent = this.formatListener.getIndent((CellValueRecordInterface)frec);
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord srec = (StringRecord)record;
                Object value = StringUtils.trimToNull((String)srec.getString());
                int row = this.nextRow;
                int column = this.nextColumn;
                this.outputNextStringRecord = false;
                if (value != null && this.indent > 0) {
                    value = new AlignedValue(value, this.indent);
                    this.indent = 0;
                }
                this.setValue(row, column, value);
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                int row = lrec.getRow();
                short column = lrec.getColumn();
                Object value = StringUtils.trimToNull((String)lrec.getValue());
                this.indent = this.formatListener.getIndent((CellValueRecordInterface)lrec);
                if (value != null && this.indent > 0) {
                    value = new AlignedValue(value, this.indent);
                }
                this.setValue(row, column, value);
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                int row = lsrec.getRow();
                short column = lsrec.getColumn();
                if (this.sstRecord == null) {
                    throw new IllegalStateException("No SST Record, can't identify string");
                }
                Object value = StringUtils.trimToNull((String)this.sstRecord.getString(lsrec.getSSTIndex()).toString());
                this.indent = this.formatListener.getIndent((CellValueRecordInterface)lsrec);
                if (value != null && this.indent > 0) {
                    value = new AlignedValue(value, this.indent);
                }
                this.setValue(row, column, value);
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                int row = numrec.getRow();
                short column = numrec.getColumn();
                Object value = this.getDateOrIntOrDouble((CellValueRecordInterface)numrec, numrec.getValue());
                this.indent = this.formatListener.getIndent((CellValueRecordInterface)numrec);
                if (this.indent > 0) {
                    value = new AlignedValue(value, this.indent);
                }
                this.setValue(row, column, value);
                break;
            }
            case 638: {
                RKRecord rkrec = (RKRecord)record;
                int row = rkrec.getRow();
                short column = rkrec.getColumn();
                Object value = this.getDateOrIntOrDouble((CellValueRecordInterface)rkrec, rkrec.getRKNumber());
                this.indent = this.formatListener.getIndent((CellValueRecordInterface)rkrec);
                if (this.indent > 0) {
                    value = new AlignedValue(value, this.indent);
                }
                this.setValue(row, column, value);
                break;
            }
            case 229: {
                MergeCellsRecord mergeRec = (MergeCellsRecord)record;
                int numAreas = mergeRec.getNumAreas();
                for (int i = 0; i < numAreas; ++i) {
                    int r;
                    CellRangeAddress rangeAddress = mergeRec.getAreaAt(i);
                    int firstMergeRow = rangeAddress.getFirstRow();
                    int firstMergeCol = rangeAddress.getFirstColumn();
                    int lastMergeRow = rangeAddress.getLastRow();
                    int lastMergeCol = rangeAddress.getLastColumn();
                    for (r = firstMergeRow; r <= lastMergeRow; ++r) {
                        for (int c = firstMergeCol + 1; c <= lastMergeCol; ++c) {
                            this.setValue(r, c, MergedCell.MERGE_WITH_LEFT);
                        }
                    }
                    for (r = firstMergeRow + 1; r <= lastMergeRow; ++r) {
                        this.setValue(r, firstMergeCol, MergedCell.MERGE_WITH_UP);
                    }
                }
                break;
            }
        }
    }

    private Object getDateOrIntOrDouble(CellValueRecordInterface record, double d) {
        int formatIndex = this.formatListener.getFormatIndex(record);
        String formatString = this.formatListener.getFormatString(formatIndex);
        Object value = DateUtil.isValidExcelDate((double)d) && this.parserDateUtil.isADateFormat(formatIndex, formatString) ? DateUtil.getJavaDate((double)d, (boolean)this.use1904Windowing) : NumberUtils.intOrDouble((double)d);
        return value;
    }

    private void setValue(int row, int column, Object value) {
        EventSheetDescriptor sheet = this.getSheet();
        int rowInArray = row - sheet.getFirstRowNum();
        int columnInArray = column - sheet.getFirstColNum();
        this.ensureCorrectSize(sheet.getName(), rowInArray, columnInArray);
        this.cellsMap.get((Object)sheet.getName())[rowInArray][columnInArray] = value;
    }

    private void ensureCorrectSize(String sheetName, int row, int col) {
        Object[][] cells = this.cellsMap.get(sheetName);
        int maxRows = Math.max(row + 1, cells.length);
        int columnCount = cells.length == 0 ? 0 : cells[0].length;
        int maxCols = Math.max(col + 1, columnCount);
        if (maxRows > cells.length || maxCols > columnCount) {
            this.log.debug("Extend cells array. Current: {}:{}, new: {}:{}", new Object[]{cells.length, columnCount, maxRows, maxCols});
            Object[][] copy = new Object[maxRows][maxCols];
            this.arrayCopy(cells, copy);
            cells = copy;
            this.cellsMap.put(sheetName, cells);
        }
    }

    private void arrayCopy(Object[][] from, Object[][] to) {
        for (int i = 0; i < from.length; ++i) {
            System.arraycopy(from[i], 0, to[i], 0, from[i].length);
        }
    }

    private EventSheetDescriptor getSheet() {
        return this.sheets.get(this.sheetIndex);
    }

    public Object[][] getCells(SheetDescriptor sheet) {
        return this.cellsMap.get(sheet.getName());
    }

    public List<EventSheetDescriptor> getSheets() {
        return this.sheets;
    }

    public boolean isUse1904Windowing() {
        return this.use1904Windowing;
    }
}

