/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.binding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openl.rules.binding.RecursiveOpenMethodPreBinder;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;

class PreBinderMethods {
    private Map<IOpenMethodHeader, IOpenMethod> binderMethods = new HashMap<IOpenMethodHeader, IOpenMethod>();
    private Map<String, IOpenMethod> binderMethodsByName = new HashMap<String, IOpenMethod>();

    PreBinderMethods() {
    }

    public IOpenMethod get(String name) {
        return this.binderMethodsByName.get(name);
    }

    public IOpenMethod get(IOpenMethodHeader header) {
        return this.binderMethods.get(header);
    }

    public void put(IOpenMethodHeader header, RecursiveOpenMethodPreBinder method) {
        if (this.binderMethods.containsKey(header)) {
            IOpenMethod m = this.binderMethods.get(header);
            RecursiveOpenMethodPreBinder recursiveOpenMethodPreBinder = (RecursiveOpenMethodPreBinder)m;
            recursiveOpenMethodPreBinder.addRecursiveOpenMethodPreBinderMethod(method);
        } else {
            this.binderMethods.put(header, method);
            this.binderMethodsByName.put(header.getName(), method);
        }
    }

    public void remove(IOpenMethodHeader header) {
        this.binderMethods.remove(header);
        this.binderMethodsByName.remove(header.getName());
    }

    public Collection<IOpenMethod> values() {
        return this.binderMethods.values();
    }
}

