/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.binding;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.domain.IDomain;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.ObjectToDataConvertorFactory;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.BaseMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.SingleCellGridTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.DomainUtils;
import org.openl.util.StringPool;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;

public final class RuleRowHelper {
    private static final String COMMENTARY = "//";
    public static final String ARRAY_ELEMENTS_SEPARATOR_ESCAPER = "\\";
    public static final String ARRAY_ELEMENTS_SEPARATOR = ",";
    public static final String CONSTRUCTOR = "constructor";

    private RuleRowHelper() {
    }

    public static int calculateHeight(ILogicalTable table) {
        int height = table.getHeight();
        int last = -1;
        for (int i = 0; i < height; ++i) {
            String source = ((ILogicalTable)table.getRow(i)).getSource().getCell(0, 0).getStringValue();
            if (source == null || source.trim().length() == 0) continue;
            last = i;
        }
        return last + 1;
    }

    public static String[] extractElementsFromCommaSeparatedArray(ILogicalTable cell) {
        String[] tokens = null;
        String src = cell.getSource().getCell(0, 0).getStringValue();
        if (src != null) {
            tokens = StringTool.splitAndEscape((String)src, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
        }
        return tokens;
    }

    public static Object loadCommaSeparatedParam(IOpenClass aggregateType, IOpenClass paramType, String paramName, String ruleName, ILogicalTable cell, OpenlToolAdaptor openlAdaptor) throws SyntaxNodeException {
        Object arrayValues;
        String[] tokens = RuleRowHelper.extractElementsFromCommaSeparatedArray(cell);
        if (tokens != null) {
            ArrayList<Object> values = new ArrayList<Object>(tokens.length);
            for (String token : tokens) {
                String str = StringPool.intern((String)token);
                Object res = RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, cell, openlAdaptor, str);
                if (res == null) {
                    res = paramType.nullObject();
                }
                values.add(res);
            }
            int valuesArraySize = values.size();
            IAggregateInfo aggregateInfo = aggregateType.getAggregateInfo();
            arrayValues = aggregateInfo.makeIndexedAggregate(paramType, valuesArraySize);
            IOpenIndex index = aggregateInfo.getIndex(aggregateType);
            for (int i = 0; i < valuesArraySize; ++i) {
                index.setValue(arrayValues, (Object)i, values.get(i));
            }
        } else {
            arrayValues = aggregateType.getAggregateInfo().makeIndexedAggregate(paramType, 0);
        }
        return arrayValues;
    }

    public static IOpenClass getType(String typeCode, ISyntaxNode node, IBindingContext bindingContext) throws SyntaxNodeException {
        if (typeCode.endsWith("[]")) {
            String baseCode = typeCode.substring(0, typeCode.length() - 2);
            IOpenClass type = RuleRowHelper.getType(baseCode, node, bindingContext);
            return type.getAggregateInfo().getIndexedAggregateType(type);
        }
        IOpenClass type = bindingContext.findType("org.openl.this", typeCode);
        if (type == null) {
            throw SyntaxNodeExceptionUtils.createError((String)("Type '" + typeCode + "'is not found"), (ISyntaxNode)node);
        }
        return type;
    }

    public static Object loadSingleParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable table, OpenlToolAdaptor openlAdapter) throws SyntaxNodeException {
        ICell theCell;
        RuleRowHelper.validateSimpleParam(table, openlAdapter.getBindingContext());
        ICell theValueCell = theCell = table.getSource().getCell(0, 0);
        if (theCell.getRegion() != null) {
            theValueCell = theCell.getTopLeftCellFromRegion();
        }
        if (String.class.equals((Object)paramType.getInstanceClass())) {
            String src = theValueCell.getStringValue();
            if (src != null) {
                src = src.length() <= 4 ? src.intern() : src;
            }
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, table, openlAdapter, src);
        }
        if (theValueCell.hasNativeType()) {
            RuleRowHelper.loadNativeValue(paramType, paramName, ruleName, table, openlAdapter, theValueCell);
        }
        String src = theValueCell.getStringValue();
        return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, table, openlAdapter, src);
    }

    private static Object loadNativeValue(IOpenClass paramType, String paramName, String ruleName, ILogicalTable table, OpenlToolAdaptor openlAdapter, ICell theValueCell) throws SyntaxNodeException {
        if (theValueCell.getNativeType() == 0) {
            try {
                Object res = RuleRowHelper.loadNativeValue(theValueCell, paramType);
                if (res instanceof IMetaHolder) {
                    RuleRowHelper.setMetaInfo((IMetaHolder)res, table, paramName, ruleName, openlAdapter.getBindingContext());
                }
                if (res != null) {
                    RuleRowHelper.validateValue(res, paramType);
                    return res;
                }
            }
            catch (Exception | LinkageError t) {
                String message = t.getMessage();
                if (message == null) {
                    message = "Can't load cell value";
                }
                IGridTable cellTable = RuleRowHelper.getTopLeftCellFromMergedRegion(table.getSource());
                throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)t, (ILocation)LocationUtils.createTextInterval((String)theValueCell.getStringValue()), (IOpenSourceCodeModule)new GridCellSourceCodeModule(cellTable, openlAdapter.getBindingContext()));
            }
        }
        return null;
    }

    private static void validateSimpleParam(ILogicalTable table, IBindingContext bindingContext) throws SyntaxNodeException {
        ICell theCell = table.getSource().getCell(0, 0);
        if (table.getWidth() > 1 || table.getHeight() > 1) {
            for (int i = 0; i < table.getHeight(); ++i) {
                for (int j = 0; j < table.getWidth(); ++j) {
                    if (i == 0 && j == 0) continue;
                    ICell cell = table.getCell(j, i);
                    if (theCell.getAbsoluteRegion().getTop() == cell.getAbsoluteRegion().getTop() && theCell.getAbsoluteRegion().getLeft() == cell.getAbsoluteRegion().getLeft() || cell.getStringValue() == null || cell.getStringValue().startsWith(COMMENTARY)) continue;
                    IGridTable cellTable = RuleRowHelper.getTopLeftCellFromMergedRegion(table.getSource());
                    throw SyntaxNodeExceptionUtils.createError((String)"Table structure is wrong. More than one cell with data found where only one cell is expected.", (IOpenSourceCodeModule)new GridCellSourceCodeModule(cellTable, bindingContext));
                }
            }
        }
    }

    public static Object loadNativeValue(ICell cell, IOpenClass paramType) {
        Object res = null;
        if (cell.getNativeType() == 0) {
            Class expectedType = paramType.getInstanceClass();
            if (BigDecimal.class.isAssignableFrom(expectedType) || BigDecimalValue.class.isAssignableFrom(expectedType)) {
                res = String2DataConvertorFactory.parse(expectedType, cell.getStringValue(), null);
            } else {
                double value = cell.getNativeNumber();
                IObjectToDataConvertor objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Double.TYPE);
                if (objectConvertor != ObjectToDataConvertorFactory.NO_Convertor) {
                    res = objectConvertor.convert(value);
                } else {
                    objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Double.class);
                    if (objectConvertor != ObjectToDataConvertorFactory.NO_Convertor) {
                        res = objectConvertor.convert(value);
                    } else {
                        objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Date.class);
                        if (objectConvertor != ObjectToDataConvertorFactory.NO_Convertor) {
                            Date dateValue = cell.getNativeDate();
                            res = objectConvertor.convert(dateValue);
                        } else if ((double)((int)value) == value && (objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Integer.class)) != ObjectToDataConvertorFactory.NO_Convertor) {
                            res = objectConvertor.convert((int)value);
                        }
                    }
                }
            }
        }
        return res;
    }

    public static SimpleNodeUsage createConstantNodeUsage(ConstantOpenField constantOpenField, int start, int end) {
        String description = MethodUtil.printType((IOpenClass)constantOpenField.getType()) + " " + constantOpenField.getName() + " = " + constantOpenField.getValueAsString();
        return new SimpleNodeUsage(start, end, description, constantOpenField.getUri(), NodeType.OTHER);
    }

    private static XlsModuleOpenClass getComponentOpenClass(IBindingContext bindingContext) {
        ComponentOpenClass openClass;
        if (bindingContext instanceof ComponentBindingContext && (openClass = ((ComponentBindingContext)bindingContext).getComponentOpenClass()) instanceof XlsModuleOpenClass) {
            return (XlsModuleOpenClass)openClass;
        }
        if (bindingContext instanceof BindingContextDelegator) {
            BindingContextDelegator bindingContextDelegator = (BindingContextDelegator)bindingContext;
            return RuleRowHelper.getComponentOpenClass(bindingContextDelegator.getDelegate());
        }
        return null;
    }

    public static ConstantOpenField findConstantField(IBindingContext bindingContext, String source) {
        if (source == null) {
            return null;
        }
        XlsModuleOpenClass xlsModuleOpenClass = RuleRowHelper.getComponentOpenClass(bindingContext);
        if (xlsModuleOpenClass != null) {
            return xlsModuleOpenClass.getConstantField(source.trim());
        }
        return null;
    }

    public static Object castConstantToExpectedType(IBindingContext bindingContext, ConstantOpenField constantOpenField, IOpenClass expectedType) {
        IOpenCast openCast = bindingContext.getCast(constantOpenField.getType(), expectedType);
        if (openCast != null && openCast.isImplicit()) {
            return openCast.convert(constantOpenField.getValue());
        }
        throw new ClassCastException(String.format("Expected value of type '%s'.", expectedType.getName()));
    }

    private static Object loadSingleParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable cell, OpenlToolAdaptor openlAdaptor, String source) throws SyntaxNodeException {
        if (source != null && (source = source.trim()).length() != 0) {
            if (openlAdaptor.getHeader() != null) {
                IOpenMethodHeader oldHeader = openlAdaptor.getHeader();
                OpenMethodHeader newHeader = new OpenMethodHeader(oldHeader.getName(), paramType, oldHeader.getSignature(), oldHeader.getDeclaringClass());
                openlAdaptor.setHeader((IOpenMethodHeader)newHeader);
                if (source.startsWith("{") && source.endsWith("}")) {
                    GridCellSourceCodeModule srcCode = new GridCellSourceCodeModule(cell.getSource(), openlAdaptor.getBindingContext());
                    return openlAdaptor.makeMethod(srcCode);
                }
                if (source.startsWith("=") && (source.length() > 2 || source.length() == 2 && Character.isLetterOrDigit(source.charAt(1)))) {
                    GridCellSourceCodeModule gridSource = new GridCellSourceCodeModule(cell.getSource(), openlAdaptor.getBindingContext());
                    SubTextSourceCodeModule code = new SubTextSourceCodeModule((IOpenSourceCodeModule)gridSource, 1);
                    return openlAdaptor.makeMethod((IOpenSourceCodeModule)code);
                }
            }
            Class expectedType = paramType.getInstanceClass();
            Object result = null;
            try {
                IBindingContext bindingContext = openlAdaptor.getBindingContext();
                ConstantOpenField constantOpenField = RuleRowHelper.findConstantField(bindingContext, source);
                ICell theValueCell = cell.getSource().getCell(0, 0);
                if (constantOpenField != null) {
                    if (!bindingContext.isExecutionMode()) {
                        RuleRowHelper.addContantMetaInfo(openlAdaptor, constantOpenField, theValueCell);
                    }
                    if (constantOpenField.getValue() != null) {
                        result = RuleRowHelper.castConstantToExpectedType(bindingContext, constantOpenField, paramType);
                    }
                } else if (String.class.equals((Object)paramType.getInstanceClass())) {
                    result = String2DataConvertorFactory.parse(expectedType, source, bindingContext);
                } else {
                    if (theValueCell.hasNativeType()) {
                        result = RuleRowHelper.loadNativeValue(paramType, paramName, ruleName, cell, openlAdaptor, theValueCell);
                    }
                    if (result == null) {
                        result = String2DataConvertorFactory.parse(expectedType, source, bindingContext);
                    }
                }
            }
            catch (Exception | LinkageError e) {
                String message = String.format("Cannot parse cell value '%s'. Expected value of type '%s'.", source, expectedType.getSimpleName());
                IGridTable cellTable = RuleRowHelper.getTopLeftCellFromMergedRegion(cell.getSource());
                GridCellSourceCodeModule cellSourceCodeModule = new GridCellSourceCodeModule(cellTable, openlAdaptor.getBindingContext());
                if (e instanceof CompositeSyntaxNodeException) {
                    throw SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)cellSourceCodeModule);
                }
                throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, null, (IOpenSourceCodeModule)cellSourceCodeModule);
            }
            if (result instanceof IMetaHolder) {
                RuleRowHelper.setMetaInfo((IMetaHolder)result, cell, paramName, ruleName, openlAdaptor.getBindingContext());
            }
            try {
                RuleRowHelper.validateValue(result, paramType);
            }
            catch (Exception e) {
                String message = String.format("Invalid cell value '%s'", source);
                IGridTable cellTable = RuleRowHelper.getTopLeftCellFromMergedRegion(cell.getSource());
                GridCellSourceCodeModule cellSourceCodeModule = new GridCellSourceCodeModule(cellTable, openlAdaptor.getBindingContext());
                throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, null, (IOpenSourceCodeModule)cellSourceCodeModule);
            }
            return result;
        }
        return null;
    }

    private static void addContantMetaInfo(OpenlToolAdaptor openlAdapter, ConstantOpenField constantOpenField, ICell theValueCell) {
        MetaInfoReader metaInfoReader = openlAdapter.getTableSyntaxNode().getMetaInfoReader();
        if (metaInfoReader instanceof BaseMetaInfoReader) {
            String[] tokens = StringTool.splitAndEscape((String)theValueCell.getStringValue(), (String)ARRAY_ELEMENTS_SEPARATOR, null);
            String cellValue = theValueCell.getStringValue();
            int startFrom = 0;
            for (String token : tokens) {
                int start = cellValue.indexOf(token, startFrom);
                startFrom = start + token.length() - 1;
                if (!token.equals(constantOpenField.getName())) continue;
                int end = start + constantOpenField.getName().length() - 1;
                SimpleNodeUsage nodeUsage = RuleRowHelper.createConstantNodeUsage(constantOpenField, start, end);
                ((BaseMetaInfoReader)metaInfoReader).addConstant(theValueCell, nodeUsage);
            }
        }
    }

    private static IGridTable getTopLeftCellFromMergedRegion(IGridTable cellTable) {
        if (cellTable instanceof SingleCellGridTable) {
            int left;
            int top;
            ICell cell = cellTable.getCell(0, 0);
            IGridRegion region = cell.getRegion();
            if (region == null) {
                return cellTable;
            }
            if (cellTable.isNormalOrientation()) {
                top = region.getTop();
                left = region.getLeft();
            } else {
                top = region.getLeft();
                left = region.getTop();
            }
            if (cell.getColumn() != left || cell.getRow() != top) {
                IGridTable table = ((SingleCellGridTable)cellTable).getOriginalGridTable();
                return new SingleCellGridTable(table, left, top);
            }
        }
        return cellTable;
    }

    public static boolean isFormula(String value) {
        if (value != null) {
            return value.trim().startsWith("=");
        }
        return false;
    }

    public static boolean isFormula(ILogicalTable valuesTable) {
        String stringValue = valuesTable.getSource().getCell(0, 0).getStringValue();
        return RuleRowHelper.isFormula(stringValue);
    }

    public static CellMetaInfo createCellMetaInfo(IdentifierNode identifier, IMetaInfo metaInfo, NodeType nodeType) {
        SimpleNodeUsage nodeUsage = new SimpleNodeUsage(identifier, metaInfo.getDisplayName(0), metaInfo.getSourceUrl(), nodeType);
        return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage));
    }

    private static void setMetaInfo(IMetaHolder holder, ILogicalTable cell, String paramName, String ruleName, IBindingContext bindingContext) {
        if (!bindingContext.isExecutionMode()) {
            ValueMetaInfo valueMetaInfo = new ValueMetaInfo();
            valueMetaInfo.setShortName(paramName);
            valueMetaInfo.setFullName(ruleName == null ? paramName : ruleName + "." + paramName);
            valueMetaInfo.setSource((IOpenSourceCodeModule)new GridCellSourceCodeModule(cell.getSource(), bindingContext));
            holder.setMetaInfo((IMetaInfo)valueMetaInfo);
        }
    }

    public static void validateValue(Object value, IOpenClass paramType) throws OpenLCompilationException {
        IDomain domain = paramType.getDomain();
        if (domain != null) {
            RuleRowHelper.validateDomain(value, (IDomain<Object>)domain, paramType);
        }
    }

    private static void validateDomain(Object value, IDomain<Object> domain, IOpenClass paramType) throws OpenLCompilationException {
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                RuleRowHelper.validateDomain(element, domain, paramType);
            }
        } else if (value instanceof Iterable && !(value instanceof INumberRange)) {
            Iterable list = (Iterable)value;
            for (Object element : list) {
                RuleRowHelper.validateDomain(element, domain, paramType);
            }
        } else {
            try {
                boolean contains = domain.selectObject(value);
                if (!contains) {
                    throw new OpenLCompilationException(String.format("The value '%s' is outside of valid domain '%s'. Valid values: %s", value, paramType.getName(), DomainUtils.toString(domain)));
                }
            }
            catch (RuntimeException e) {
                throw new OpenLCompilationException(e.getMessage(), e.getCause());
            }
        }
    }

    public static Object loadParam(ILogicalTable dataTable, IOpenClass paramType, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, boolean loadSingleParamOnly) throws SyntaxNodeException {
        boolean oneCellTable;
        if (!loadSingleParamOnly) {
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
        }
        int height = RuleRowHelper.calculateHeight(dataTable = LogicalTableHelper.make1ColumnTable(dataTable));
        boolean bl = oneCellTable = height == 1;
        if (height == 0) {
            return null;
        }
        if (oneCellTable && !paramType.isArray()) {
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
        }
        IOpenClass arrayType = paramType.getAggregateInfo().getComponentType(paramType);
        boolean isFormula = RuleRowHelper.isFormula(dataTable);
        if (oneCellTable) {
            if (!isFormula) {
                IOpenCast openCast;
                ConstantOpenField constantOpenField;
                String[] tokens = RuleRowHelper.extractElementsFromCommaSeparatedArray((ILogicalTable)dataTable.getRow(0));
                if (tokens != null && tokens.length == 1 && (constantOpenField = RuleRowHelper.findConstantField(openlAdaptor.getBindingContext(), tokens[0])) != null && (openCast = openlAdaptor.getBindingContext().getCast(constantOpenField.getType(), paramType)) != null && openCast.isImplicit()) {
                    if (!openlAdaptor.getBindingContext().isExecutionMode()) {
                        RuleRowHelper.addContantMetaInfo(openlAdaptor, constantOpenField, ((ILogicalTable)dataTable.getRow(0)).getSource().getCell(0, 0));
                    }
                    return openCast.convert(constantOpenField.getValue());
                }
                return RuleRowHelper.loadCommaSeparatedArrayParams(dataTable, paramName, ruleName, openlAdaptor, paramType, arrayType);
            }
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
        }
        return RuleRowHelper.loadSimpleArrayParams(dataTable, paramName, ruleName, openlAdaptor, paramType, arrayType);
    }

    private static Object loadCommaSeparatedArrayParams(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass aggregateType, IOpenClass paramType) throws SyntaxNodeException {
        ILogicalTable paramSource = (ILogicalTable)dataTable.getRow(0);
        Object params = RuleRowHelper.loadCommaSeparatedParam(aggregateType, paramType, paramName, ruleName, paramSource, openlAdaptor);
        Class<?> paramClass = params.getClass();
        if (paramClass.isArray() && !paramClass.getComponentType().isPrimitive()) {
            return RuleRowHelper.processAsObjectParams(paramType, (Object[])params);
        }
        return params;
    }

    private static Object processAsObjectParams(IOpenClass paramType, Object[] paramsArray) {
        ArrayList<CompositeMethod> methodsList = null;
        int paramsLength = paramsArray.length;
        Object ary = paramType.getAggregateInfo().makeIndexedAggregate(paramType, paramsLength);
        for (int i = 0; i < paramsLength; ++i) {
            if (paramsArray[i] instanceof CompositeMethod) {
                methodsList = new ArrayList<CompositeMethod>(RuleRowHelper.addMethod((List<CompositeMethod>)methodsList, (CompositeMethod)paramsArray[i]));
                continue;
            }
            Array.set(ary, i, paramsArray[i]);
        }
        return methodsList == null ? ary : new ArrayHolder(paramType, methodsList.toArray(new CompositeMethod[0]));
    }

    private static List<CompositeMethod> addMethod(List<CompositeMethod> methods, CompositeMethod method) {
        if (methods == null) {
            methods = new ArrayList<CompositeMethod>();
        }
        methods.add(method);
        return methods;
    }

    private static Object loadSimpleArrayParams(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass aggregateType, IOpenClass paramType) throws SyntaxNodeException {
        int height = RuleRowHelper.calculateHeight(dataTable);
        ArrayList<CompositeMethod> methodsList = null;
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < height; ++i) {
            ILogicalTable cell = (ILogicalTable)dataTable.getRow(i);
            Object parameter = RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, cell, openlAdaptor);
            if (parameter instanceof CompositeMethod) {
                methodsList = new ArrayList<CompositeMethod>(RuleRowHelper.addMethod(methodsList, (CompositeMethod)parameter));
                continue;
            }
            if (parameter == null) continue;
            values.add(parameter);
        }
        IAggregateInfo aggregateInfo = aggregateType.getAggregateInfo();
        Object ary = aggregateInfo.makeIndexedAggregate(paramType, values.size());
        IOpenIndex index = aggregateInfo.getIndex(aggregateType);
        for (int i = 0; i < values.size(); ++i) {
            index.setValue(ary, (Object)i, values.get(i));
        }
        return methodsList == null ? ary : new ArrayHolder(paramType, methodsList.toArray(new CompositeMethod[0]));
    }
}

