/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.binding.CustomDynamicOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.table.Point;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.DynamicArrayAggregateInfo;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class CustomSpreadsheetResultOpenClass
extends ADynamicClass
implements CustomDynamicOpenClass {
    private String[] rowNames;
    private String[] columnNames;
    private String[] rowTitles;
    private String[] columnTitles;
    private Map<String, Point> fieldsCoordinates;
    private Iterable<IOpenClass> superClasses = null;

    public CustomSpreadsheetResultOpenClass(String name, String[] rowNames, String[] columnNames, String[] rowTitles, String[] columnTitles) {
        super(name, SpreadsheetResult.class);
        if (rowNames == null) {
            throw new IllegalArgumentException();
        }
        if (columnNames == null) {
            throw new IllegalArgumentException();
        }
        if (rowTitles == null) {
            throw new IllegalArgumentException();
        }
        if (columnTitles == null) {
            throw new IllegalArgumentException();
        }
        this.rowNames = (String[])rowNames.clone();
        this.columnNames = (String[])columnNames.clone();
        this.columnTitles = (String[])columnTitles.clone();
        this.rowTitles = (String[])rowTitles.clone();
        this.fieldsCoordinates = SpreadsheetResult.buildFieldsCoordinates(this.columnNames, this.rowNames);
    }

    public CustomSpreadsheetResultOpenClass(String name) {
        super(name, SpreadsheetResult.class);
    }

    public IAggregateInfo getAggregateInfo() {
        return DynamicArrayAggregateInfo.aggregateInfo;
    }

    public synchronized Iterable<IOpenClass> superClasses() {
        if (this.superClasses == null) {
            Class<?>[] interfaces = SpreadsheetResult.class.getInterfaces();
            ArrayList<IOpenClass> superClasses = new ArrayList<IOpenClass>(interfaces.length + 1);
            for (Class<?> interf : interfaces) {
                superClasses.add((IOpenClass)JavaOpenClass.getOpenClass(interf));
            }
            this.superClasses = superClasses;
        }
        return this.superClasses;
    }

    public void extendSpreadsheetResult(String[] rowNames, String[] columnNames, String[] rowTitles, String[] columnTitles, Collection<IOpenField> fields) {
        int i;
        ArrayList<String> nRowNames = new ArrayList<String>(Arrays.asList(this.rowNames));
        HashSet<String> existedRowNamesSet = new HashSet<String>(Arrays.asList(this.rowNames));
        ArrayList<String> nColumnNames = new ArrayList<String>(Arrays.asList(this.columnNames));
        HashSet<String> existedColumnNamesSet = new HashSet<String>(Arrays.asList(this.columnNames));
        ArrayList<String> nRowTitles = new ArrayList<String>(Arrays.asList(this.rowTitles));
        ArrayList<String> nColumnTitles = new ArrayList<String>(Arrays.asList(this.columnTitles));
        boolean fieldCoordinatesRequresUpdate = false;
        for (i = 0; i < rowNames.length; ++i) {
            if (existedRowNamesSet.contains(rowNames[i])) continue;
            nRowNames.add(rowNames[i]);
            nRowTitles.add(rowTitles[i]);
            fieldCoordinatesRequresUpdate = true;
        }
        for (i = 0; i < columnNames.length; ++i) {
            if (existedColumnNamesSet.contains(columnNames[i])) continue;
            nColumnNames.add(columnNames[i]);
            nColumnTitles.add(columnTitles[i]);
            fieldCoordinatesRequresUpdate = true;
        }
        if (fieldCoordinatesRequresUpdate) {
            StringBuilder sb;
            int j;
            int i2;
            HashSet<String> newFieldNames = new HashSet<String>();
            for (i2 = 0; i2 < nRowNames.size(); ++i2) {
                for (j = this.columnNames.length; j < nColumnNames.size(); ++j) {
                    sb = new StringBuilder();
                    sb.append("$").append((String)nColumnNames.get(j)).append("$").append((String)nRowNames.get(i2));
                    newFieldNames.add(sb.toString());
                }
            }
            for (i2 = this.rowNames.length; i2 < nRowNames.size(); ++i2) {
                for (j = 0; j < nColumnNames.size(); ++j) {
                    sb = new StringBuilder();
                    sb.append("$").append((String)nColumnNames.get(j)).append("$").append((String)nRowNames.get(i2));
                    newFieldNames.add(sb.toString());
                }
            }
            for (i2 = this.rowNames.length; i2 < nRowNames.size(); ++i2) {
                for (j = this.columnNames.length; j < nColumnNames.size(); ++j) {
                    sb = new StringBuilder();
                    sb.append("$").append((String)nColumnNames.get(j)).append("$").append((String)nRowNames.get(i2));
                    newFieldNames.add(sb.toString());
                }
            }
            this.rowNames = nRowNames.toArray(new String[0]);
            this.columnNames = nColumnNames.toArray(new String[0]);
            this.rowTitles = nRowTitles.toArray(new String[0]);
            this.columnTitles = nColumnTitles.toArray(new String[0]);
            for (IOpenField field : fields) {
                if (!newFieldNames.contains(field.getName())) continue;
                this.addField(field);
            }
            this.fieldsCoordinates = Collections.unmodifiableMap(SpreadsheetResult.buildFieldsCoordinates(this.columnNames, this.rowNames));
        }
    }

    public String[] getRowNames() {
        return (String[])this.rowNames.clone();
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public String[] getRowTitles() {
        return this.rowTitles;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    @Override
    public IOpenClass copy() {
        return this.copyCustomSpreadsheetResult();
    }

    @Override
    public void updateOpenClass(IOpenClass openClass) {
        CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = (CustomSpreadsheetResultOpenClass)openClass;
        customSpreadsheetResultOpenClass.extendSpreadsheetResult(this.getRowNames(), this.getColumnNames(), this.getRowTitles(), this.getColumnTitles(), this.getFields().values());
        this.validate(customSpreadsheetResultOpenClass, this.getFields().values());
    }

    private void validate(CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass, Collection<IOpenField> values) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (IOpenField field : values) {
            IOpenField existedField = customSpreadsheetResultOpenClass.getField(field.getName());
            if (existedField.getType().isAssignableFrom(field.getType())) continue;
            errorMessages.add(this.getName() + "." + field.getName() + "(expected: " + existedField.getType().getName() + ", found: " + field.getType().getName() + ")");
        }
        if (!errorMessages.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String errorMessage : errorMessages) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(errorMessage);
            }
            throw new OpenlNotCheckedException("Incompatible type usage in spreadsheet fields: " + sb.toString());
        }
    }

    public Map<String, Point> getFieldsCoordinates() {
        return this.fieldsCoordinates;
    }

    private CustomSpreadsheetResultOpenClass copyCustomSpreadsheetResult() {
        CustomSpreadsheetResultOpenClass type = new CustomSpreadsheetResultOpenClass(this.getName(), this.getRowNames(), this.getColumnNames(), this.getRowTitles(), this.getColumnTitles());
        for (IOpenField field : this.getFields().values()) {
            type.addField(field);
        }
        type.setMetaInfo(this.getMetaInfo());
        return type;
    }

    public Object newInstance(IRuntimeEnv env) {
        Object[][] result = new Object[this.rowNames.length][this.columnNames.length];
        return new SpreadsheetResult(result, (String[])this.rowNames.clone(), (String[])this.columnNames.clone(), this.fieldsCoordinates);
    }
}

