/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLSystemProperties;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetComponentsBuilder;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetStructureBuilder;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.lang.xls.binding.AMethodBasedNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.SpreadsheetMetaInfoReader;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ILogicalTable;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;

public class SpreadsheetBoundNode
extends AMethodBasedNode
implements IMemberBoundNode {
    private SpreadsheetStructureBuilder structureBuilder;
    private SpreadsheetComponentsBuilder componentsBuilder;
    private SpreadsheetOpenClass spreadsheetOpenClass;
    private SpreadsheetCell[][] cells;
    IBindingContext bindingContext;

    public SpreadsheetBoundNode(TableSyntaxNode tableSyntaxNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(tableSyntaxNode, openl, header, module);
    }

    @Override
    protected ExecutableRulesMethod createMethodShell() {
        Spreadsheet spreadsheet;
        if (this.componentsBuilder.isExistsReturnHeader()) {
            spreadsheet = new Spreadsheet(this.getHeader(), this, false);
        } else {
            boolean isCustomSpreadsheetType = SpreadsheetResult.class.equals((Object)this.getType().getInstanceClass()) && !(this.getType() instanceof CustomSpreadsheetResultOpenClass) && OpenLSystemProperties.isCustomSpreadsheetType(this.bindingContext.getExternalParams());
            spreadsheet = new Spreadsheet(this.getHeader(), this, isCustomSpreadsheetType);
        }
        spreadsheet.setSpreadsheetType(this.spreadsheetOpenClass);
        spreadsheet.setRowNames(this.componentsBuilder.getRowNames());
        spreadsheet.setColumnNames(this.componentsBuilder.getColumnNames());
        spreadsheet.setRowTitles(this.componentsBuilder.getCellsHeadersExtractor().getRowNames());
        spreadsheet.setColumnTitles(this.componentsBuilder.getCellsHeadersExtractor().getColumnNames());
        if (spreadsheet.isCustomSpreadsheetType()) {
            IOpenClass type = null;
            try {
                type = spreadsheet.getType();
                this.bindingContext.addType("org.openl.this", type);
            }
            catch (Exception | LinkageError e) {
                String message = String.format("Can't define type %s", type != null ? type.getName() : spreadsheet.getName());
                SyntaxNodeException exception = SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ISyntaxNode)this.getTableSyntaxNode());
                this.getTableSyntaxNode().addError(exception);
                this.bindingContext.addError(exception);
            }
        }
        return spreadsheet;
    }

    public void preBind(IBindingContext bindingContext) throws SyntaxNodeException {
        if (!bindingContext.isExecutionMode()) {
            this.getTableSyntaxNode().setMetaInfoReader(new SpreadsheetMetaInfoReader(this));
        }
        TableSyntaxNode tableSyntaxNode = this.getTableSyntaxNode();
        this.validateTableBody(tableSyntaxNode, bindingContext);
        IOpenMethodHeader header = this.getHeader();
        if (header.getType() == JavaOpenClass.VOID) {
            throw SyntaxNodeExceptionUtils.createError((String)"Spreadsheet can not return 'void' type", (ISyntaxNode)tableSyntaxNode);
        }
        this.bindingContext = bindingContext;
        this.componentsBuilder = new SpreadsheetComponentsBuilder(tableSyntaxNode, bindingContext);
        this.componentsBuilder.buildHeaders(header.getType());
        this.structureBuilder = new SpreadsheetStructureBuilder(this.componentsBuilder, header);
        String headerType = header.getName() + "Type";
        OpenL openL = bindingContext.getOpenL();
        this.spreadsheetOpenClass = new SpreadsheetOpenClass(headerType, openL);
        Boolean autoType = tableSyntaxNode.getTableProperties().getAutoType();
        this.structureBuilder.addCellFields(this.spreadsheetOpenClass, autoType);
    }

    @Override
    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        super.finalizeBind(bindingContext);
        ILogicalTable tableBody = this.getTableSyntaxNode().getTableBody();
        this.getTableSyntaxNode().getSubTables().put("business", tableBody);
        this.cells = this.structureBuilder.getCells();
        Spreadsheet spreadsheet = (Spreadsheet)this.getMethod();
        spreadsheet.setCells(this.cells);
        spreadsheet.setResultBuilder(this.componentsBuilder.buildResultBuilder(spreadsheet));
    }

    public SpreadsheetCell[][] getCells() {
        return this.cells;
    }

    private void validateTableBody(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) throws SyntaxNodeException {
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (tableBody == null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Table has no body! Try to merge header cell horizontally to identify table.", (ISyntaxNode)this.getTableSyntaxNode());
        }
        int height = tableBody.getHeight();
        int width = tableBody.getWidth();
        if (height < 2 || width < 2) {
            String message = "Spreadsheet has empty body. Spreadsheet table should has at least 2x3 cells.";
            BindHelper.processWarn((String)message, (ISyntaxNode)tableSyntaxNode, (IBindingContext)bindingContext);
        }
    }

    public Spreadsheet getSpreadsheet() {
        return (Spreadsheet)this.getMethod();
    }

    public void updateDependency(BindingDependencies dependencies) {
        if (this.cells != null) {
            for (SpreadsheetCell[] cellArray : this.cells) {
                if (cellArray == null) continue;
                for (SpreadsheetCell cell : cellArray) {
                    CompositeMethod method;
                    if (cell == null || (method = (CompositeMethod)cell.getMethod()) == null) continue;
                    method.updateDependency(dependencies);
                }
            }
        }
    }

    public SpreadsheetComponentsBuilder getComponentsBuilder() {
        return this.componentsBuilder;
    }

    @Override
    public void removeDebugInformation(IBindingContext cxt) throws Exception {
        if (cxt.isExecutionMode()) {
            super.removeDebugInformation(cxt);
            this.structureBuilder.getSpreadsheetStructureBuilderHolder().clear();
            this.bindingContext = null;
        }
    }
}

