/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.openl.binding.IBindingContext;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.cast.IOneElementArrayCast;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaInfo;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.calc.CellsHeaderExtractor;
import org.openl.rules.calc.ReturnSpreadsheetHeaderDefinition;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetSymbols;
import org.openl.rules.calc.SymbolicTypeDefinition;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.result.ArrayResultBuilder;
import org.openl.rules.calc.result.DefaultResultBuilder;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.rules.calc.result.ScalarResultBuilder;
import org.openl.rules.lang.xls.syntax.SpreadsheetHeaderNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.lang.xls.types.meta.SpreadsheetMetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.text.ILocation;

public class SpreadsheetComponentsBuilder {
    private TableSyntaxNode tableSyntaxNode;
    private IBindingContext bindingContext;
    private CellsHeaderExtractor cellsHeaderExtractor;
    private ReturnSpreadsheetHeaderDefinition returnHeaderDefinition;
    private Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = new HashMap<Integer, SpreadsheetHeaderDefinition>();
    private Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = new HashMap<Integer, SpreadsheetHeaderDefinition>();
    private BidiMap<String, SpreadsheetHeaderDefinition> headerDefinitions = new DualHashBidiMap();

    public SpreadsheetComponentsBuilder(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) {
        this.tableSyntaxNode = tableSyntaxNode;
        CellsHeaderExtractor extractor = ((SpreadsheetHeaderNode)tableSyntaxNode.getHeader()).getCellHeadersExtractor();
        if (extractor == null) {
            extractor = new CellsHeaderExtractor(this.getSignature(tableSyntaxNode), (ILogicalTable)((ILogicalTable)tableSyntaxNode.getTableBody().getRow(0)).getColumns(1), (ILogicalTable)((ILogicalTable)tableSyntaxNode.getTableBody().getColumn(0)).getRows(1));
        }
        this.cellsHeaderExtractor = extractor;
        this.bindingContext = bindingContext;
    }

    public Map<Integer, SpreadsheetHeaderDefinition> getRowHeaders() {
        return this.rowHeaders;
    }

    public Map<Integer, SpreadsheetHeaderDefinition> getColumnHeaders() {
        return this.columnHeaders;
    }

    public String[] getRowNames() {
        return this.buildArrayForHeaders(this.rowHeaders, this.cellsHeaderExtractor.getHeight());
    }

    public String[] getColumnNames() {
        return this.buildArrayForHeaders(this.columnHeaders, this.cellsHeaderExtractor.getWidth());
    }

    private String[] buildArrayForHeaders(Map<Integer, SpreadsheetHeaderDefinition> headers, int size) {
        String[] ret = new String[size];
        for (Map.Entry<Integer, SpreadsheetHeaderDefinition> x : headers.entrySet()) {
            int k = x.getKey();
            ret[k] = x.getValue().getFirstname();
        }
        return ret;
    }

    public CellsHeaderExtractor getCellsHeadersExtractor() {
        return this.cellsHeaderExtractor;
    }

    public void buildHeaders(IOpenClass spreadsheetHeaderType) {
        this.addRowHeaders();
        this.addColumnHeaders();
        this.buildHeaderDefinitionsTypes();
        try {
            this.buildReturnCells(spreadsheetHeaderType);
        }
        catch (SyntaxNodeException e) {
            this.addError(e);
        }
    }

    void addError(SyntaxNodeException e) {
        this.getTableSyntaxNode().addError(e);
        this.getBindingContext().addError(e);
    }

    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }

    public IResultBuilder buildResultBuilder(Spreadsheet spreadsheet) {
        IResultBuilder resultBuilder = null;
        try {
            resultBuilder = this.getResultBuilderInternal(spreadsheet);
        }
        catch (SyntaxNodeException e) {
            this.addError(e);
        }
        return resultBuilder;
    }

    private void addRowHeaders() {
        String[] rowNames = this.cellsHeaderExtractor.getRowNames();
        for (int i = 0; i < rowNames.length; ++i) {
            if (rowNames[i] == null) continue;
            IGridTable rowNameForHeader = ((ILogicalTable)((ILogicalTable)this.cellsHeaderExtractor.getRowNamesTable().getRow(i)).getColumn(0)).getSource();
            GridCellSourceCodeModule source = new GridCellSourceCodeModule(rowNameForHeader, this.bindingContext);
            int j = i;
            SpreadsheetHeaderDefinition header = this.rowHeaders.computeIfAbsent(i, e -> new SpreadsheetHeaderDefinition(j, -1));
            this.parseHeader(header, source);
        }
    }

    private void addColumnHeaders() {
        String[] columnNames = this.cellsHeaderExtractor.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i] == null) continue;
            IGridTable columnNameForHeader = ((ILogicalTable)((ILogicalTable)this.cellsHeaderExtractor.getColumnNamesTable().getColumn(i)).getRow(0)).getSource();
            GridCellSourceCodeModule source = new GridCellSourceCodeModule(columnNameForHeader, this.bindingContext);
            int j = i;
            SpreadsheetHeaderDefinition header = this.columnHeaders.computeIfAbsent(i, e -> new SpreadsheetHeaderDefinition(-1, j));
            this.parseHeader(header, source);
        }
    }

    private void parseHeader(SpreadsheetHeaderDefinition header, IOpenSourceCodeModule source) {
        SymbolicTypeDefinition parsed = null;
        try {
            parsed = this.parseHeaderElement(source);
            IdentifierNode name = parsed.getName();
            String headerName = name.getIdentifier();
            SpreadsheetHeaderDefinition h1 = (SpreadsheetHeaderDefinition)this.headerDefinitions.get((Object)headerName);
            if (h1 != null) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"The header definition is duplicated", (ISyntaxNode)name);
                this.addError(error);
                throw new DuplicatedVarException(null, headerName);
            }
            this.headerDefinitions.put((Object)headerName, (Object)header);
            header.addVarHeader(parsed);
        }
        catch (SyntaxNodeException error) {
            this.addError(error);
        }
    }

    private SymbolicTypeDefinition parseHeaderElement(IOpenSourceCodeModule source) throws SyntaxNodeException {
        IdentifierNode[] nodes;
        try {
            nodes = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)SpreadsheetSymbols.TYPE_DELIMETER.toString());
        }
        catch (OpenLCompilationException e) {
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot parse header", (IOpenSourceCodeModule)source);
        }
        switch (nodes.length) {
            case 1: {
                return new SymbolicTypeDefinition(nodes[0], null);
            }
            case 2: {
                return new SymbolicTypeDefinition(nodes[0], nodes[1]);
            }
        }
        String message = String.format("Valid header format: name [%s type]", SpreadsheetSymbols.TYPE_DELIMETER.toString());
        if (nodes.length > 2) {
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)nodes[2]);
        }
        throw SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source);
    }

    private void buildHeaderDefinitionsTypes() {
        for (SpreadsheetHeaderDefinition headerDefinition : this.headerDefinitions.values()) {
            IMetaInfo typeMeta;
            IOpenClass headerType = null;
            IdentifierNode typeIdentifierNode = null;
            for (SymbolicTypeDefinition symbolicTypeDefinition : headerDefinition.getVars()) {
                typeIdentifierNode = symbolicTypeDefinition.getType();
                if (typeIdentifierNode == null) continue;
                String typeIdentifier = typeIdentifierNode.getText();
                try {
                    IOpenClass type = RuleRowHelper.getType(typeIdentifier, (ISyntaxNode)typeIdentifierNode, this.bindingContext);
                    if (headerType == null) {
                        headerType = type;
                        continue;
                    }
                    if (headerType == type) continue;
                    this.addError(SyntaxNodeExceptionUtils.createError((String)"Type redefinition", (ISyntaxNode)typeIdentifierNode));
                }
                catch (SyntaxNodeException e) {
                    this.addError(e);
                }
            }
            if (headerType == null) continue;
            headerDefinition.setType(headerType);
            if (this.bindingContext.isExecutionMode() || typeIdentifierNode == null) continue;
            IOpenClass type = headerType;
            while (type.getMetaInfo() == null && type.isArray()) {
                type = type.getComponentClass();
            }
            IdentifierNode identifier = this.cutTypeIdentifier(typeIdentifierNode);
            if (identifier == null) continue;
            ILogicalTable cell = headerDefinition.getRow() >= 0 ? (ILogicalTable)this.cellsHeaderExtractor.getRowNamesTable().getRow(headerDefinition.getRow()) : (ILogicalTable)this.cellsHeaderExtractor.getColumnNamesTable().getColumn(headerDefinition.getColumn());
            MetaInfoReader metaInfoReader = this.getTableSyntaxNode().getMetaInfoReader();
            if (!(metaInfoReader instanceof SpreadsheetMetaInfoReader) || (typeMeta = type.getMetaInfo()) == null) continue;
            ICell c = cell.getCell(0, 0);
            ((SpreadsheetMetaInfoReader)metaInfoReader).addHeaderMetaInfo(c.getAbsoluteRow(), c.getAbsoluteColumn(), RuleRowHelper.createCellMetaInfo(identifier, typeMeta, NodeType.DATATYPE));
        }
    }

    private IdentifierNode cutTypeIdentifier(IdentifierNode typeIdentifierNode) {
        try {
            IdentifierNode[] nodes;
            IdentifierNode[] variableAndType = Tokenizer.tokenize((IOpenSourceCodeModule)typeIdentifierNode.getModule(), (String)SpreadsheetSymbols.TYPE_DELIMETER.toString());
            if (variableAndType.length > 1 && (nodes = Tokenizer.tokenize((IOpenSourceCodeModule)typeIdentifierNode.getModule(), (String)" []\n\r", (ILocation)variableAndType[1].getLocation())).length > 0) {
                return nodes[0];
            }
        }
        catch (OpenLCompilationException e) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Cannot parse header", (ISyntaxNode)typeIdentifierNode);
            this.addError(error);
        }
        return null;
    }

    private void buildReturnCells(IOpenClass spreadsheetHeaderType) throws SyntaxNodeException {
        int nonEmptyCellsCount;
        SpreadsheetHeaderDefinition headerDefinition = (SpreadsheetHeaderDefinition)this.headerDefinitions.get((Object)SpreadsheetSymbols.RETURN_NAME.toString());
        if (spreadsheetHeaderType.equals(JavaOpenClass.getOpenClass(SpreadsheetResult.class)) && headerDefinition == null) {
            return;
        }
        if (headerDefinition == null) {
            for (SpreadsheetHeaderDefinition spreadsheetHeaderDefinition : this.headerDefinitions.values()) {
                if (headerDefinition == null) {
                    headerDefinition = spreadsheetHeaderDefinition;
                    continue;
                }
                if (headerDefinition.getRow() >= spreadsheetHeaderDefinition.getRow()) continue;
                headerDefinition = spreadsheetHeaderDefinition;
            }
        }
        if (Boolean.FALSE.equals(this.tableSyntaxNode.getTableProperties().getAutoType()) && headerDefinition.getType() == null) {
            headerDefinition.setType(spreadsheetHeaderType);
        } else if ((spreadsheetHeaderType.getAggregateInfo() == null || spreadsheetHeaderType.getAggregateInfo() != null && spreadsheetHeaderType.getAggregateInfo().getComponentType(spreadsheetHeaderType) == null) && (nonEmptyCellsCount = this.getNonEmptyCellsCount(headerDefinition)) == 1) {
            headerDefinition.setType(spreadsheetHeaderType);
        }
        String key = (String)this.headerDefinitions.getKey((Object)headerDefinition);
        this.returnHeaderDefinition = new ReturnSpreadsheetHeaderDefinition(headerDefinition);
        this.headerDefinitions.replace((Object)key, (Object)this.returnHeaderDefinition);
    }

    private int getNonEmptyCellsCount(SpreadsheetHeaderDefinition headerDefinition) {
        int fromRow = 0;
        int toRow = this.cellsHeaderExtractor.getHeight();
        int fromColumn = 0;
        int toColumn = this.cellsHeaderExtractor.getWidth();
        if (headerDefinition.isRow()) {
            fromRow = headerDefinition.getRow();
            toRow = fromRow + 1;
        } else {
            fromColumn = headerDefinition.getColumn();
            toColumn = fromColumn + 1;
        }
        int nonEmptyCellsCount = 0;
        for (int columnIndex = fromColumn; columnIndex < toColumn; ++columnIndex) {
            for (int rowIndex = fromRow; rowIndex < toRow; ++rowIndex) {
                ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.cellsHeaderExtractor.getRowNamesTable().getRow(rowIndex), (ILogicalTable)this.cellsHeaderExtractor.getColumnNamesTable().getColumn(columnIndex));
                String value = cell.getSource().getCell(0, 0).getStringValue();
                if (StringUtils.isBlank((CharSequence)value)) continue;
                ++nonEmptyCellsCount;
            }
        }
        return nonEmptyCellsCount;
    }

    public boolean isExistsReturnHeader() {
        return this.returnHeaderDefinition != null;
    }

    public ReturnSpreadsheetHeaderDefinition getReturnHeaderDefinition() {
        return this.returnHeaderDefinition;
    }

    private IResultBuilder getResultBuilderInternal(Spreadsheet spreadsheet) throws SyntaxNodeException {
        IResultBuilder resultBuilder;
        SymbolicTypeDefinition symbolicTypeDefinition = null;
        if (this.isExistsReturnHeader()) {
            String key = (String)this.headerDefinitions.getKey((Object)this.returnHeaderDefinition);
            symbolicTypeDefinition = this.returnHeaderDefinition.findVarDef(key);
        }
        if (!this.isExistsReturnHeader() && spreadsheet.getHeader().getType().equals(JavaOpenClass.getOpenClass(SpreadsheetResult.class))) {
            resultBuilder = new DefaultResultBuilder();
        } else {
            int i;
            ArrayList<SpreadsheetCell> returnSpreadsheetCells = new ArrayList<SpreadsheetCell>();
            ArrayList<IOpenCast> casts = new ArrayList<IOpenCast>();
            ArrayList<SpreadsheetCell> returnSpreadsheetCellsAsArray = new ArrayList<SpreadsheetCell>();
            ArrayList<IOpenCast> castsAsArray = new ArrayList<IOpenCast>();
            IOpenClass type = spreadsheet.getType();
            IAggregateInfo aggregateInfo = type.getAggregateInfo();
            IOpenClass componentType = aggregateInfo.getComponentType(type);
            boolean asArray = false;
            ArrayList<SpreadsheetCell> sprCells = new ArrayList<SpreadsheetCell>();
            int n = this.returnHeaderDefinition.getRow();
            boolean byColumn = true;
            if (n < 0) {
                n = this.returnHeaderDefinition.getColumn();
                byColumn = false;
                for (i = 0; i < spreadsheet.getCells().length; ++i) {
                    sprCells.add(spreadsheet.getCells()[i][n]);
                }
            } else {
                for (i = 0; i < spreadsheet.getCells()[n].length; ++i) {
                    sprCells.add(spreadsheet.getCells()[n][i]);
                }
            }
            ArrayList<SpreadsheetCell> nonEmptySpreadsheetCells = new ArrayList<SpreadsheetCell>();
            for (SpreadsheetCell cell : sprCells) {
                if (cell.isEmpty()) continue;
                nonEmptySpreadsheetCells.add(cell);
                if (cell.getType() == null) continue;
                IOpenCast cast = this.bindingContext.getCast(cell.getType(), type);
                if (cast != null && cast.isImplicit() && !(cast instanceof IOneElementArrayCast)) {
                    returnSpreadsheetCells.add(cell);
                    casts.add(cast);
                }
                if (!returnSpreadsheetCells.isEmpty() || componentType == null || (cast = this.bindingContext.getCast(cell.getType(), componentType)) == null || !cast.isImplicit() || cast instanceof IOneElementArrayCast) continue;
                returnSpreadsheetCellsAsArray.add(cell);
                castsAsArray.add(cast);
            }
            if (componentType != null && returnSpreadsheetCells.isEmpty()) {
                returnSpreadsheetCells = returnSpreadsheetCellsAsArray;
                this.returnHeaderDefinition.setType(componentType);
                casts = castsAsArray;
                asArray = true;
            } else {
                this.returnHeaderDefinition.setType(type);
            }
            SpreadsheetCell[] retCells = returnSpreadsheetCells.toArray(new SpreadsheetCell[0]);
            if (!returnSpreadsheetCells.isEmpty()) {
                if (asArray) {
                    this.returnHeaderDefinition.setReturnCells(byColumn, retCells);
                } else {
                    this.returnHeaderDefinition.setReturnCells(byColumn, (SpreadsheetCell)returnSpreadsheetCells.get(returnSpreadsheetCells.size() - 1));
                }
            } else if (!nonEmptySpreadsheetCells.isEmpty()) {
                if (asArray) {
                    this.returnHeaderDefinition.setReturnCells(byColumn, nonEmptySpreadsheetCells.toArray(new SpreadsheetCell[0]));
                } else {
                    this.returnHeaderDefinition.setReturnCells(byColumn, (SpreadsheetCell)nonEmptySpreadsheetCells.get(nonEmptySpreadsheetCells.size() - 1));
                }
            }
            switch (returnSpreadsheetCells.size()) {
                case 0: {
                    if (!nonEmptySpreadsheetCells.isEmpty()) {
                        SpreadsheetCell nonEmptySpreadsheetCell = (SpreadsheetCell)nonEmptySpreadsheetCells.get(nonEmptySpreadsheetCells.size() - 1);
                        if (nonEmptySpreadsheetCell.getType() != null) {
                            throw SyntaxNodeExceptionUtils.createError((String)("Can not convert from " + nonEmptySpreadsheetCell.getType().getName() + " to " + spreadsheet.getHeader().getType().getName()), (ISyntaxNode)(symbolicTypeDefinition == null ? null : symbolicTypeDefinition.getName()));
                        }
                        return null;
                    }
                    throw SyntaxNodeExceptionUtils.createError((String)"There is no return expression cell", (ISyntaxNode)(symbolicTypeDefinition == null ? null : symbolicTypeDefinition.getName()));
                }
                case 1: {
                    resultBuilder = new ScalarResultBuilder((SpreadsheetCell)returnSpreadsheetCells.get(returnSpreadsheetCells.size() - 1), (IOpenCast)casts.get(casts.size() - 1), this.isCalculateAllCellsInSpreadsheet(spreadsheet));
                    break;
                }
                default: {
                    resultBuilder = asArray ? new ArrayResultBuilder(retCells, castsAsArray.toArray(new IOpenCast[0]), type, this.isCalculateAllCellsInSpreadsheet(spreadsheet)) : new ScalarResultBuilder((SpreadsheetCell)returnSpreadsheetCells.get(returnSpreadsheetCells.size() - 1), (IOpenCast)casts.get(casts.size() - 1), this.isCalculateAllCellsInSpreadsheet(spreadsheet));
                }
            }
        }
        return resultBuilder;
    }

    private boolean isCalculateAllCellsInSpreadsheet(Spreadsheet spreadsheet) {
        return !Boolean.FALSE.equals(spreadsheet.getMethodProperties().getCalculateAllCells());
    }

    private String getSignature(TableSyntaxNode table) {
        return table.getHeader().getHeaderToken().getModule().getCode();
    }
}

