/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultRootDictionaryContext;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.Point;
import org.openl.types.java.CustomJavaOpenClass;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;

@XmlRootElement
@CustomJavaOpenClass(type=SpreadsheetResultOpenClass.class, variableInContextFinder=SpreadsheetResultRootDictionaryContext.class)
public class SpreadsheetResult
implements Serializable {
    private static final long serialVersionUID = 8704762477153429384L;
    private static final int MAX_WIDTH = 4;
    private static final int MAX_HEIGHT = 10;
    private static final int MAX_DEPTH = 2;
    private static final int MAX_VALUE_LENGTH = 10240;
    private Object[][] results;
    private String[] columnNames;
    private String[] rowNames;
    private transient Map<String, Point> fieldsCoordinates = null;
    private transient ILogicalTable logicalTable;
    private static final ThreadLocal<Integer> DEPTH_LOCAL_THREAD = new ThreadLocal();

    public SpreadsheetResult() {
    }

    public SpreadsheetResult(Object[][] results, String[] rowNames, String[] columnNames) {
        this(results, rowNames, columnNames, null);
        this.initFieldsCoordinates();
    }

    public SpreadsheetResult(Object[][] results, String[] rowNames, String[] columnNames, Map<String, Point> fieldsCoordinates) {
        this.columnNames = (String[])columnNames.clone();
        this.rowNames = (String[])rowNames.clone();
        this.results = results;
        this.fieldsCoordinates = fieldsCoordinates;
    }

    static Map<String, Point> buildFieldsCoordinates(String[] columnNames, String[] rowNames) {
        HashMap<String, Point> fieldsCoordinates = new HashMap<String, Point>();
        if (columnNames != null && rowNames != null) {
            for (int i = 0; i < rowNames.length; ++i) {
                for (int j = 0; j < columnNames.length; ++j) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("$").append(columnNames[j]).append("$").append(rowNames[i]);
                    fieldsCoordinates.put(sb.toString(), new Point(j, i));
                }
            }
        }
        return fieldsCoordinates;
    }

    private void initFieldsCoordinates() {
        this.fieldsCoordinates = SpreadsheetResult.buildFieldsCoordinates(this.columnNames, this.rowNames);
    }

    @XmlTransient
    public int getHeight() {
        return this.rowNames.length;
    }

    public Object[][] getResults() {
        return (Object[][])this.results.clone();
    }

    public void setResults(Object[][] results) {
        this.results = (Object[][])results.clone();
    }

    @XmlTransient
    public int getWidth() {
        return this.columnNames.length;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = (String[])columnNames.clone();
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = (String[])rowNames.clone();
    }

    public Object getValue(int row, int column) {
        return this.results[row][column];
    }

    public void setFieldValue(String name, Object value) {
        Point fieldCoordinates;
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        if ((fieldCoordinates = this.fieldsCoordinates.get(name)) != null) {
            this.setValue(fieldCoordinates.getRow(), fieldCoordinates.getColumn(), value);
        }
    }

    protected void setValue(int row, int column, Object value) {
        this.results[row][column] = value;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public String getRowName(int row) {
        return this.rowNames[row];
    }

    @XmlTransient
    public ILogicalTable getLogicalTable() {
        return this.logicalTable;
    }

    public void setLogicalTable(ILogicalTable logicalTable) {
        this.logicalTable = logicalTable;
    }

    public Object getFieldValue(String name) {
        Point fieldCoordinates;
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        if ((fieldCoordinates = this.fieldsCoordinates.get(name)) != null) {
            return this.getValue(fieldCoordinates.getRow(), fieldCoordinates.getColumn());
        }
        return null;
    }

    public boolean hasField(String name) {
        if (this.fieldsCoordinates == null) {
            this.initFieldsCoordinates();
        }
        return this.fieldsCoordinates.get(name) != null;
    }

    public String toString() {
        try {
            if (CollectionUtils.isEmpty((Object[])this.rowNames) || CollectionUtils.isEmpty((Object[])this.columnNames)) {
                return "[EMPTY]";
            }
            return this.printTable();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private String truncateStringValue(String value) {
        if (value.length() > 10240) {
            return value.substring(0, 10240) + " ... TRUNCATED ...";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String printTable() {
        StringBuilder sb = new StringBuilder();
        Integer d = DEPTH_LOCAL_THREAD.get();
        d = d != null ? d : 0;
        try {
            DEPTH_LOCAL_THREAD.set(d + 1);
            int maxWidth = Math.min(4, this.getWidth());
            int maxHeight = Math.min(10, this.getHeight());
            int[] width = new int[maxWidth + 1];
            for (int i1 = 0; i1 <= maxHeight; ++i1) {
                for (int j1 = 0; j1 <= maxWidth; ++j1) {
                    width[j1] = Math.max(width[j1], i1 > 0 && j1 > 0 && this.getValue(i1 - 1, j1 - 1) instanceof SpreadsheetResult && d > 2 ? "... TRUNCATED TABLE ...".length() : this.truncateStringValue(this.getStringValue(j1, i1)).length());
                }
            }
            for (int i = 0; i <= maxHeight; ++i) {
                for (int j = 0; j <= maxWidth; ++j) {
                    if (j != 0) {
                        sb.append(" | ");
                    }
                    String cell = i > 0 && j > 0 && this.getValue(i - 1, j - 1) instanceof SpreadsheetResult && d > 2 ? "... TRUNCATED TABLE ..." : this.truncateStringValue(this.getStringValue(j, i));
                    sb.append(cell);
                    for (int k = 0; k < width[j] - cell.length(); ++k) {
                        sb.append(' ');
                    }
                }
                sb.append('\n');
            }
            if (this.getWidth() > 4 || this.getHeight() > 10) {
                sb.append("... TRUNCATED TABLE ...");
            }
        }
        finally {
            if (d == 0) {
                DEPTH_LOCAL_THREAD.remove();
            } else {
                DEPTH_LOCAL_THREAD.set(d);
            }
        }
        return sb.toString();
    }

    private String getStringValue(int col, int row) {
        if (col == 0 && row == 0) {
            return "-X-";
        }
        if (col == 0) {
            return this.getRowName(row - 1);
        }
        if (row == 0) {
            return this.getColumnName(col - 1);
        }
        Object value = this.getValue(row - 1, col - 1);
        StringBuilder builder = new StringBuilder(10);
        StringUtils.print((Object)value, (Appendable)builder);
        return builder.toString();
    }
}

