/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.element;

import java.lang.reflect.Array;
import org.openl.binding.impl.NodeDescriptionHolder;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.rules.calc.ASpreadsheetField;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetRangeField
extends ASpreadsheetField
implements NodeDescriptionHolder {
    private final SpreadsheetCellField fstart;
    private final SpreadsheetCellField fend;
    private final IOpenCast[][] casts;
    private final Class<?> rangeType;

    public SpreadsheetRangeField(String name, SpreadsheetCellField fstart, SpreadsheetCellField fend, IOpenClass rangeType, IOpenCast[][] casts) {
        super(fstart.getDeclaringClass(), name, rangeType.getArrayType(1));
        this.fstart = fstart;
        this.fend = fend;
        this.casts = casts;
        this.rangeType = rangeType.getInstanceClass();
    }

    public Object get(Object target, IRuntimeEnv env) {
        int sx = this.fstart.getCell().getColumnIndex();
        int sy = this.fstart.getCell().getRowIndex();
        int ex = this.fend.getCell().getColumnIndex();
        int ey = this.fend.getCell().getRowIndex();
        int w = ex - sx + 1;
        int h = ey - sy + 1;
        int size = w * h;
        SpreadsheetResultCalculator calc = (SpreadsheetResultCalculator)target;
        Object array = Array.newInstance(this.rangeType, size);
        int i = 0;
        for (int x = sx; x <= ex; ++x) {
            for (int y = sy; y <= ey; ++y) {
                Object v = calc.getValue(y, x);
                IOpenCast openCast = this.casts[x - sx][y - sy];
                if (openCast != null && openCast.isImplicit()) {
                    v = openCast.convert(v);
                }
                Array.set(array, i, v);
                ++i;
            }
        }
        return array;
    }

    @Override
    public String getDescription() {
        return this.getType().getDisplayName(0) + " " + this.fstart.getName() + ":" + this.fend.getName();
    }
}

