/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.algorithm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.rules.cmatch.algorithm.Argument;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

public class ArgumentsHelper {
    private final IMethodSignature methodSignature;
    private final Map<String, Argument> argTypes;

    public ArgumentsHelper(IMethodSignature methodSignature) {
        this.methodSignature = methodSignature;
        this.argTypes = new HashMap<String, Argument>();
        this.initSimpleArgs();
    }

    private Argument findIndirectByName(String argName) {
        argName = argName.replace(" ", "");
        IOpenClass[] paramTypes = this.methodSignature.getParameterTypes();
        for (int i = 0; i < this.methodSignature.getNumberOfParameters(); ++i) {
            IOpenField field;
            IOpenClass type = paramTypes[i];
            if (type.isSimple() || (field = type.getField(argName, false)) == null) continue;
            return new Argument(i, field);
        }
        return null;
    }

    public DomainOpenClass generateDomainClassByArgNames() {
        HashSet<String> argNames = new HashSet<String>();
        argNames.addAll(this.argTypes.keySet());
        IOpenClass[] paramTypes = this.methodSignature.getParameterTypes();
        for (int i = 0; i < this.methodSignature.getNumberOfParameters(); ++i) {
            IOpenClass type = paramTypes[i];
            if (type.isSimple()) continue;
            for (IOpenField field : type.getFields().values()) {
                argNames.add(field.getName());
            }
        }
        Object[] possibleNames = argNames.toArray(new String[argNames.size()]);
        return new DomainOpenClass("names", (IOpenClass)JavaOpenClass.STRING, (IDomain)new EnumDomain(possibleNames), null);
    }

    public Argument getTypeByName(String argName) {
        Argument result = this.argTypes.get(argName);
        if (result != null) {
            return result;
        }
        result = this.findIndirectByName(argName);
        if (result != null) {
            this.argTypes.put(argName, result);
        }
        return result;
    }

    private void initSimpleArgs() {
        IOpenClass[] paramTypes = this.methodSignature.getParameterTypes();
        for (int i = 0; i < this.methodSignature.getNumberOfParameters(); ++i) {
            String name = this.methodSignature.getParameterName(i);
            IOpenClass type = paramTypes[i];
            if (type.isSimple()) {
                this.argTypes.put(name, new Argument(i, type));
                continue;
            }
            if (!type.getInstanceClass().isEnum()) continue;
            this.argTypes.put(name, new Argument(i, type));
        }
    }
}

