/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Constructor;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.util.RuntimeExceptionWrapper;

class String2ConstructorConvertor<T>
implements IString2DataConvertor<T> {
    private Constructor<T> ctr;

    public String2ConstructorConvertor(Class<T> clazz) {
        try {
            this.ctr = clazz.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException t) {
            throw new IllegalArgumentException("Public Constructor " + clazz.getName() + "(String s) does not exist");
        }
    }

    @Override
    public T parse(String data, String format) {
        if (data == null) {
            return null;
        }
        try {
            return this.ctr.newInstance(data);
        }
        catch (Exception e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }
}

