/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.data.DatatypeArrayMultiRowElementContext;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.AOpenField;
import org.openl.types.impl.CollectionType;
import org.openl.vm.IRuntimeEnv;

public class CollectionElementWithMultiRowField
extends AOpenField {
    private IOpenField field;
    private String fieldPathFromRoot;
    private boolean pkField = false;
    private CollectionType collectionType;
    private IOpenClass arrayType;

    public CollectionElementWithMultiRowField(IOpenField field, String fieldPathFromRoot, IOpenClass type, CollectionType collectionType) {
        this(field, fieldPathFromRoot, type, collectionType, false);
    }

    public CollectionElementWithMultiRowField(IOpenField field, String fieldPathFromRoot, IOpenClass type, CollectionType collectionType, boolean pkField) {
        super(CollectionElementWithMultiRowField.getName(field.getName()), type);
        this.field = field;
        this.pkField = pkField;
        this.fieldPathFromRoot = fieldPathFromRoot;
        this.collectionType = collectionType;
        this.arrayType = field.getType().getComponentClass();
    }

    public Object get(Object target, IRuntimeEnv env) {
        if (target == null) {
            return null;
        }
        DatatypeArrayMultiRowElementContext context = (DatatypeArrayMultiRowElementContext)env.getLocalFrame()[0];
        int elementIndex = context.getIndex(this.fieldPathFromRoot, target);
        Object res = null;
        Object v = this.field.get(target, env);
        if (this.collectionType.isArray()) {
            res = this.getForArray(elementIndex, v);
        }
        if (this.collectionType.isList()) {
            res = this.getForList(elementIndex, v);
        }
        return res != null ? res : this.getType().nullObject();
    }

    private Object getForArray(int elementIndex, Object arr) {
        if (arr == null || Array.getLength(arr) < elementIndex + 1) {
            return this.getType().nullObject();
        }
        return Array.get(arr, elementIndex);
    }

    private Object getForList(int elementIndex, Object v) {
        List list = (List)v;
        if (v == null || list.size() < elementIndex + 1) {
            return this.getType().nullObject();
        }
        return list.get(elementIndex);
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        if (target == null) {
            throw new OpenLRuntimeException(String.format("Can not set [%s] field to \"null\" object", this.getName()));
        }
        Object v = this.field.get(target, env);
        DatatypeArrayMultiRowElementContext context = (DatatypeArrayMultiRowElementContext)env.getLocalFrame()[0];
        int elementIndex = context.getIndex(this.fieldPathFromRoot, target);
        if (this.collectionType.isArray()) {
            this.setForArray(target, value, env, v, elementIndex);
        }
        if (this.collectionType.isList()) {
            this.setForList(target, value, env, v, elementIndex);
        }
    }

    private void setForArray(Object target, Object value, IRuntimeEnv env, Object v, int elementIndex) {
        if (v == null) {
            if (!this.isPkField()) {
                Object array = Array.newInstance(this.getType().getInstanceClass(), 1);
                Array.set(array, 0, value);
                this.setIntoTarget(target, array, env);
            }
        } else if (Array.getLength(v) < elementIndex + 1) {
            Object newArray = Array.newInstance(this.arrayType.getInstanceClass(), elementIndex + 1);
            int oldArryLeng = Array.getLength(v);
            for (int i = 0; i < oldArryLeng; ++i) {
                Array.set(newArray, i, Array.get(v, i));
            }
            if (!this.isPkField()) {
                Array.set(newArray, elementIndex, value);
                this.setIntoTarget(target, newArray, env);
            }
        } else if (!this.isPkField()) {
            Array.set(v, elementIndex, value);
        }
    }

    private void setForList(Object target, Object value, IRuntimeEnv env, Object v, int elementIndex) {
        if (v == null) {
            if (!this.isPkField()) {
                ArrayList<Object> list = new ArrayList<Object>();
                while (list.size() <= elementIndex) {
                    list.add(this.getType().nullObject());
                }
                list.set(elementIndex, value);
                this.setIntoTarget(target, list, env);
            }
        } else {
            List list = (List)v;
            while (list.size() <= elementIndex) {
                list.add(this.getType().nullObject());
            }
            if (!this.isPkField()) {
                list.set(elementIndex, value);
            }
        }
    }

    public boolean isWritable() {
        return true;
    }

    public String getFieldPathFromRoot() {
        return this.fieldPathFromRoot;
    }

    private static String getName(String name) {
        return name + "[]";
    }

    public IOpenField getField() {
        return this.field;
    }

    private void setIntoTarget(Object target, Object array, IRuntimeEnv env) {
        this.field.set(target, array, env);
    }

    public boolean isPkField() {
        return this.pkField;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }
}

