/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.data.ITableModel;
import org.openl.rules.data.Table;
import org.openl.rules.lang.xls.binding.DuplicatedTableException;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;

public class DataBase
implements IDataBase {
    private Map<String, ITable> tables = new HashMap<String, ITable>();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITable getTable(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.tables.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITable registerTable(String tableName, TableSyntaxNode tsn) throws DuplicatedTableException {
        Object object = this.lock;
        synchronized (object) {
            ITable table = this.getTable(tableName);
            if (table != null) {
                String newUri;
                String uri = table.getTableSyntaxNode().getTable().getSource().getUri();
                if (!uri.equals(newUri = tsn.getTable().getSource().getUri())) {
                    throw new DuplicatedTableException(tableName, table.getTableSyntaxNode(), tsn);
                }
                return table;
            }
            table = this.makeNewTable(tableName, tsn);
            this.tables.put(tableName, table);
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITable registerNewTable(String tableName, TableSyntaxNode tsn) {
        Object object = this.lock;
        synchronized (object) {
            ITable table = this.makeNewTable(tableName, tsn);
            this.tables.put(tableName, table);
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ITable> getTables() {
        Object object = this.lock;
        synchronized (object) {
            HashSet<ITable> ret = new HashSet<ITable>();
            for (ITable table : this.tables.values()) {
                ret.add(table);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTable(ITable newTable) throws DuplicatedTableException {
        Object object = this.lock;
        synchronized (object) {
            String newUri;
            String uri;
            ITable table = this.getTable(newTable.getName());
            if (table != null && !(uri = table.getTableSyntaxNode().getTable().getSource().getUri()).equals(newUri = newTable.getTableSyntaxNode().getTable().getSource().getUri())) {
                throw new DuplicatedTableException(newTable.getName(), table.getTableSyntaxNode(), newTable.getTableSyntaxNode());
            }
            this.tables.put(newTable.getName(), newTable);
        }
    }

    protected ITable makeNewTable(String tableName, TableSyntaxNode tsn) {
        return new Table(tableName, tsn);
    }

    @Override
    public void preLoadTable(ITable table, ITableModel dataModel, ILogicalTable dataWithTitles, OpenlToolAdaptor openlAdapter) throws Exception {
        table.setModel(dataModel);
        table.setData(dataWithTitles);
        table.preLoad(openlAdapter);
    }
}

