/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.openl.exception.OpenLRuntimeException;
import org.openl.types.IOpenClass;
import org.openl.types.impl.AOpenField;
import org.openl.types.impl.CollectionType;
import org.openl.vm.IRuntimeEnv;

public class ThisCollectionElementField
extends AOpenField {
    private int elementIndex;
    private CollectionType collectionType;
    private Object mapKey;

    public ThisCollectionElementField(int elementIndex, IOpenClass type, CollectionType collectionType) {
        super(ThisCollectionElementField.getName("", String.valueOf(elementIndex)), type);
        this.elementIndex = elementIndex;
        this.collectionType = collectionType;
    }

    public ThisCollectionElementField(Object mapKey, IOpenClass type) {
        super(ThisCollectionElementField.getName("", String.valueOf(mapKey)), type);
        this.mapKey = mapKey;
        this.collectionType = CollectionType.MAP;
    }

    public Object get(Object target, IRuntimeEnv env) {
        if (target == null) {
            return null;
        }
        Object res = null;
        if (this.collectionType.isArray()) {
            res = this.getForArray(target);
        }
        if (this.collectionType.isList()) {
            res = this.getForList(target);
        }
        if (this.collectionType.isMap()) {
            res = this.getForMap(target);
        }
        return res != null ? res : this.getType().nullObject();
    }

    private Object getForList(Object target) {
        List targetList = (List)target;
        if (targetList == null || targetList.size() < this.elementIndex + 1) {
            return this.getType().nullObject();
        }
        return targetList.get(this.elementIndex);
    }

    private Object getForArray(Object target) {
        if (target == null || Array.getLength(target) < this.elementIndex + 1) {
            return this.getType().nullObject();
        }
        return Array.get(target, this.elementIndex);
    }

    private Object getForMap(Object v) {
        Map map = (Map)v;
        return map.get(this.mapKey);
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        if (target == null) {
            throw new OpenLRuntimeException(String.format("Can not set [%s] field to \"null\" object", this.getName()));
        }
        if (this.collectionType.isArray()) {
            this.setForArray(target, value, env);
        }
        if (this.collectionType.isList()) {
            this.setForList(target, value);
        }
        if (this.collectionType.isMap()) {
            this.setForMap(target, value);
        }
    }

    private void setForList(Object target, Object value) {
        List targetList = (List)target;
        while (targetList.size() <= this.elementIndex) {
            targetList.add(this.getType().nullObject());
        }
        targetList.set(this.elementIndex, value);
    }

    private void setForArray(Object arr, Object value, IRuntimeEnv env) {
        if (Array.getLength(arr) < this.elementIndex + 1) {
            Object newArray = Array.newInstance(this.getType().getInstanceClass(), this.elementIndex + 1);
            int oldArryLeng = Array.getLength(arr);
            for (int i = 0; i < oldArryLeng; ++i) {
                Array.set(newArray, i, Array.get(arr, i));
            }
            Array.set(newArray, this.elementIndex, value);
            env.popThis();
            env.pushThis(newArray);
        } else {
            Array.set(arr, this.elementIndex, value);
        }
    }

    private void setForMap(Object target, Object value) {
        Map map = (Map)target;
        map.put(this.mapKey, value);
    }

    public boolean isWritable() {
        return true;
    }

    private static String getName(String name, String index) {
        return name + "[" + index + "]";
    }
}

