/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.gen.ByteCodeGenerationException;
import org.openl.gen.FieldDescription;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.gen.FieldDescriptionBuilder;
import org.openl.rules.datatype.gen.JavaBeanClassBuilder;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.lang.xls.types.meta.BaseMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.DatatypeTableMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.utils.ParserUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionCollector;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.DatatypeOpenField;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.impl.InternalDatatypeClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;
import org.openl.util.text.TextInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeTableBoundNode
implements IMemberBoundNode {
    private final Logger log = LoggerFactory.getLogger(DatatypeTableBoundNode.class);
    private TableSyntaxNode tableSyntaxNode;
    private DatatypeOpenClass dataType;
    private IdentifierNode parentClassIdentifier;
    private String parentClassName;
    private ModuleOpenClass moduleOpenClass;
    private ILogicalTable table;
    private OpenL openl;

    public DatatypeTableBoundNode(TableSyntaxNode tableSyntaxNode, DatatypeOpenClass datatype, ModuleOpenClass moduleOpenClass, ILogicalTable table, OpenL openl) {
        this(tableSyntaxNode, datatype, moduleOpenClass, table, openl, null);
    }

    public DatatypeTableBoundNode(TableSyntaxNode tableSyntaxNode, DatatypeOpenClass datatype, ModuleOpenClass moduleOpenClass, ILogicalTable table, OpenL openl, IdentifierNode parentClassIdentifier) {
        this.tableSyntaxNode = tableSyntaxNode;
        this.dataType = datatype;
        this.table = table;
        this.openl = openl;
        this.parentClassIdentifier = parentClassIdentifier;
        this.parentClassName = parentClassIdentifier != null ? parentClassIdentifier.getIdentifier() : this.parentClassName;
        this.moduleOpenClass = moduleOpenClass;
    }

    public static IOpenClass getRootComponentClass(IOpenClass fieldType) {
        if (!fieldType.isArray()) {
            return fieldType;
        }
        return DatatypeTableBoundNode.getRootComponentClass(fieldType.getComponentClass());
    }

    public static GridCellSourceCodeModule getCellSource(ILogicalTable row, IBindingContext cxt, int columnIndex) {
        return new GridCellSourceCodeModule(((ILogicalTable)row.getColumn(columnIndex)).getSource(), cxt);
    }

    public static IdentifierNode[] getIdentifierNode(GridCellSourceCodeModule cellSrc) throws OpenLCompilationException {
        return Tokenizer.tokenize((IOpenSourceCodeModule)cellSrc, (String)" \r\n");
    }

    public static boolean canProcessRow(ILogicalTable row, IBindingContext cxt) {
        GridCellSourceCodeModule rowSrc = new GridCellSourceCodeModule(row.getSource(), cxt);
        return DatatypeTableBoundNode.canProcessRow(rowSrc);
    }

    public static boolean canProcessRow(GridCellSourceCodeModule rowSrc) {
        return !ParserUtils.isBlankOrCommented(rowSrc.getCode());
    }

    private void addFields(IBindingContext cxt) throws Exception {
        ILogicalTable dataTable;
        this.table = dataTable = DatatypeHelper.getNormalizedDataPartTable(this.table, this.openl, cxt);
        int tableHeight = 0;
        if (dataTable != null) {
            tableHeight = dataTable.getHeight();
        }
        LinkedHashMap<String, FieldDescription> fields = new LinkedHashMap<String, FieldDescription>();
        SyntaxNodeExceptionCollector syntaxNodeExceptionCollector = new SyntaxNodeExceptionCollector();
        int i = 0;
        while (i < tableHeight) {
            int index = i++;
            syntaxNodeExceptionCollector.run(() -> this.processRow((ILogicalTable)dataTable.getRow(index), cxt, fields, index == 0));
        }
        syntaxNodeExceptionCollector.run(() -> this.checkInheritedFieldsDuplication(cxt));
        syntaxNodeExceptionCollector.throwIfAny();
        if (this.beanClassCanBeGenerated(cxt)) {
            Class beanClass;
            String beanName = this.dataType.getJavaName();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                beanClass = classLoader.loadClass(beanName);
                this.log.debug("Bean {} is using previously loaded", (Object)beanName);
            }
            catch (ClassNotFoundException e) {
                try {
                    byte[] byteCode = this.createBeanForDatatype(fields);
                    beanClass = ClassUtils.defineClass((String)beanName, (byte[])byteCode, (ClassLoader)classLoader);
                    this.dataType.setBytecode(byteCode);
                    this.log.debug("bean {} is using generated at runtime", (Object)beanName);
                }
                catch (ByteCodeGenerationException genE) {
                    throw SyntaxNodeExceptionUtils.createError((String)String.format("Can't generate a class for datatype %s. %s", beanName, genE.getMessage()), (Throwable)genE, (ISyntaxNode)this.tableSyntaxNode);
                }
                catch (Exception e2) {
                    throw SyntaxNodeExceptionUtils.createError((String)("Can't generate a class for datatype " + beanName), (ISyntaxNode)this.tableSyntaxNode);
                }
            }
            this.dataType.setInstanceClass(beanClass);
            this.validateBeanForDatatype(beanClass, fields);
        }
    }

    private boolean beanClassCanBeGenerated(IBindingContext cxt) {
        if (this.tableSyntaxNode.hasErrors()) {
            return false;
        }
        if (this.parentClassName != null) {
            IOpenClass parentClass = cxt.findType("org.openl.this", this.parentClassName);
            return parentClass.getInstanceClass() != null;
        }
        return true;
    }

    private byte[] createBeanForDatatype(Map<String, FieldDescription> fields) {
        String beanName = this.dataType.getJavaName();
        IOpenClass superOpenClass = this.dataType.getSuperClass();
        JavaBeanClassBuilder beanBuilder = new JavaBeanClassBuilder(beanName);
        if (superOpenClass != null) {
            Class superClass = superOpenClass.getInstanceClass();
            beanBuilder.setParentClass(superClass);
            for (Map.Entry field : superOpenClass.getFields().entrySet()) {
                beanBuilder.addParentField((String)field.getKey(), ((IOpenField)field.getValue()).getType().getJavaName());
            }
        }
        beanBuilder.addFields(fields);
        return beanBuilder.byteCode();
    }

    private void validateBeanForDatatype(Class<?> beanClass, Map<String, FieldDescription> fields) throws SyntaxNodeException {
        String beanName = this.dataType.getJavaName();
        IOpenClass superClass = this.dataType.getSuperClass();
        if (superClass != null && !beanClass.getSuperclass().equals(superClass.getInstanceClass())) {
            String errorMessage = String.format("Datatype '%s' validation is failed on missed parent class. Please, regenerate datatype classes.", beanName);
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
        }
        for (Map.Entry<String, FieldDescription> fieldEntry : fields.entrySet()) {
            Method getterMethod;
            String fieldName = fieldEntry.getKey();
            FieldDescription fieldDescription = fieldEntry.getValue();
            try {
                beanClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                String errorMessage = String.format("Datatype '%s' validation is failed on missed field '%s'. Please, regenerate your datatype classes.", beanName, fieldName);
                throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
            }
            String name = ClassUtils.capitalize((String)fieldName);
            try {
                getterMethod = beanClass.getMethod("get" + name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String errorMessage = String.format("Datatype '%s' validation is failed on missed method 'get%s'. Please, regenerate your datatype classes.", beanName, name);
                name = StringUtils.capitalize((String)fieldName);
                try {
                    getterMethod = beanClass.getMethod("get" + name, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
                }
            }
            if (!getterMethod.getReturnType().getName().equals(fieldDescription.getTypeName())) {
                String errorMessage = String.format("Datatype '%s' validation is failed on method 'get%s' with unexpected return type. Please, regenerate your datatype classes.", beanName, name);
                throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
            }
            String setterMethodName = "set" + name;
            Method[] methods = beanClass.getMethods();
            boolean found = false;
            for (Method method : methods) {
                if (!method.getName().equals(setterMethodName) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getName().equals(fieldDescription.getTypeName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            String errorMessage = String.format("Datatype '%s' validation is failed on missed method '%s(%s)'. Please, regenerate your datatype classes.", beanName, setterMethodName, fieldDescription.getTypeName());
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
        }
        try {
            beanClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String errorMessage = String.format("Datatype '%s' validation is failed on missed default constructor. Please, regenerate datatype classes.", beanName);
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
        }
    }

    private void processRow(ILogicalTable row, IBindingContext cxt, Map<String, FieldDescription> fields, boolean firstField) throws OpenLCompilationException {
        GridCellSourceCodeModule rowSrc = new GridCellSourceCodeModule(row.getSource(), cxt);
        if (DatatypeTableBoundNode.canProcessRow(rowSrc)) {
            FieldDescriptionBuilder fieldDescriptionBuilder;
            IOpenClass fieldType;
            String fieldName = this.getName(row, cxt);
            DatatypeOpenField field = new DatatypeOpenField((IOpenClass)this.dataType, fieldName, fieldType = this.getFieldType(cxt, row, rowSrc));
            if (!this.isRecursiveField((IOpenField)field) && DatatypeTableBoundNode.getRootComponentClass(field.getType()).getInstanceClass() == null) {
                GridCellSourceCodeModule cellSource = DatatypeTableBoundNode.getCellSource(row, cxt, 0);
                TextInterval location = LocationUtils.createTextInterval((String)cellSource.getCode());
                String message = "Type " + DatatypeTableBoundNode.getRootComponentClass(field.getType()).getName() + " isn't generated yet";
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ILocation)location, (IOpenSourceCodeModule)cellSource);
            }
            try {
                if (fields.containsKey(fieldName)) {
                    throw SyntaxNodeExceptionUtils.createError((String)String.format("Field '%s' has already been defined!", fieldName), null, null, (IOpenSourceCodeModule)DatatypeTableBoundNode.getCellSource(row, cxt, 1));
                }
                if (fields.containsKey(ClassUtils.decapitalize((String)fieldName)) || fields.containsKey(ClassUtils.capitalize((String)fieldName))) {
                    String f = null;
                    if (fields.containsKey(ClassUtils.decapitalize((String)fieldName))) {
                        f = ClassUtils.decapitalize((String)fieldName);
                    }
                    if (fields.containsKey(ClassUtils.capitalize((String)fieldName))) {
                        f = ClassUtils.capitalize((String)fieldName);
                    }
                    throw SyntaxNodeExceptionUtils.createError((String)String.format("Field '%s' conflicts with '%s' field!", fieldName, f), null, null, (IOpenSourceCodeModule)DatatypeTableBoundNode.getCellSource(row, cxt, 1));
                }
                this.dataType.addField((IOpenField)field);
                if (firstField) {
                    this.dataType.setIndexField((IOpenField)field);
                }
                fieldDescriptionBuilder = FieldDescriptionBuilder.create(field.getType().getJavaName());
            }
            catch (SyntaxNodeException e) {
                throw e;
            }
            catch (Exception t) {
                throw SyntaxNodeExceptionUtils.createError((String)t.getMessage(), (Throwable)t, null, (IOpenSourceCodeModule)DatatypeTableBoundNode.getCellSource(row, cxt, 1));
            }
            FieldDescription fieldDescription = null;
            if (row.getWidth() > 2) {
                String defaultValue = DatatypeTableBoundNode.getDefaultValue(row, cxt);
                ConstantOpenField constantOpenField = RuleRowHelper.findConstantField(cxt, defaultValue);
                if (constantOpenField != null) {
                    fieldDescriptionBuilder.setDefaultValue(constantOpenField.getValue());
                    fieldDescriptionBuilder.setDefaultValueAsString(constantOpenField.getValueAsString());
                    if (!cxt.isExecutionMode()) {
                        ICell cell = DatatypeTableBoundNode.getCellSource(row, cxt, 2).getCell();
                        MetaInfoReader metaInfoReader = this.tableSyntaxNode.getMetaInfoReader();
                        if (metaInfoReader instanceof BaseMetaInfoReader) {
                            SimpleNodeUsage nodeUsage = RuleRowHelper.createConstantNodeUsage(constantOpenField, 0, defaultValue.length() - 1);
                            ((BaseMetaInfoReader)metaInfoReader).addConstant(cell, nodeUsage);
                        }
                    }
                } else {
                    Object value;
                    ICell theCellValue;
                    fieldDescriptionBuilder.setDefaultValueAsString(defaultValue);
                    if (!String.class.equals((Object)fieldType.getInstanceClass()) && (theCellValue = ((ILogicalTable)row.getColumn(2)).getCell(0, 0)).hasNativeType() && (value = RuleRowHelper.loadNativeValue(theCellValue, fieldType)) != null) {
                        fieldDescriptionBuilder.setDefaultValue(value);
                    }
                    try {
                        fieldDescription = fieldDescriptionBuilder.build();
                    }
                    catch (RuntimeException e) {
                        String message = String.format("Can't parse cell value '%s'", defaultValue);
                        GridCellSourceCodeModule cellSourceCodeModule = DatatypeTableBoundNode.getCellSource(row, cxt, 2);
                        if (e instanceof CompositeSyntaxNodeException) {
                            CompositeSyntaxNodeException exception = (CompositeSyntaxNodeException)((Object)e);
                            if (exception.getErrors() != null && exception.getErrors().length == 1) {
                                SyntaxNodeException syntaxNodeException = exception.getErrors()[0];
                                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ILocation)syntaxNodeException.getLocation(), (IOpenSourceCodeModule)cellSourceCodeModule);
                            }
                            throw SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)cellSourceCodeModule);
                        }
                        TextInterval location = defaultValue == null ? null : LocationUtils.createTextInterval((String)defaultValue);
                        throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ILocation)location, (IOpenSourceCodeModule)cellSourceCodeModule);
                    }
                    Object value2 = fieldDescription.getDefaultValue();
                    if (!(value2 == null || fieldDescription.hasDefaultKeyWord() && fieldDescription.isArray())) {
                        try {
                            RuleRowHelper.validateValue(value2, fieldType);
                        }
                        catch (Exception e) {
                            throw SyntaxNodeExceptionUtils.createError((String)e.getMessage(), (Throwable)e, null, (IOpenSourceCodeModule)DatatypeTableBoundNode.getCellSource(row, cxt, 2));
                        }
                    }
                }
            }
            if (fieldDescription == null) {
                fieldDescription = fieldDescriptionBuilder.build();
            }
            fields.put(fieldName, fieldDescription);
        }
    }

    private boolean isRecursiveField(IOpenField field) {
        IOpenClass fieldType = DatatypeTableBoundNode.getRootComponentClass(field.getType());
        return fieldType.getName().equals(this.dataType.getName());
    }

    private String getName(ILogicalTable row, IBindingContext cxt) throws OpenLCompilationException {
        GridCellSourceCodeModule nameCellSource = DatatypeTableBoundNode.getCellSource(row, cxt, 1);
        IdentifierNode[] idn = DatatypeTableBoundNode.getIdentifierNode(nameCellSource);
        if (idn.length != 1) {
            String errorMessage = String.format("Bad field name: %s", nameCellSource.getCode());
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)nameCellSource);
        }
        return idn[0].getIdentifier();
    }

    public static String getDefaultValue(ILogicalTable row, IBindingContext cxt) throws OpenLCompilationException {
        IdentifierNode[] idn;
        String defaultValue = null;
        GridCellSourceCodeModule defaultValueSrc = DatatypeTableBoundNode.getCellSource(row, cxt, 2);
        if (!ParserUtils.isCommented(defaultValueSrc.getCode()) && (idn = DatatypeTableBoundNode.getIdentifierNode(defaultValueSrc)).length > 0) {
            defaultValue = defaultValueSrc.getCode();
        }
        return defaultValue;
    }

    private IOpenClass getFieldType(IBindingContext bindingContext, ILogicalTable row, GridCellSourceCodeModule tableSrc) throws SyntaxNodeException {
        IOpenClass fieldType = OpenLManager.makeType((OpenL)this.openl, (IOpenSourceCodeModule)tableSrc, (IBindingContext)bindingContext);
        if (fieldType == null || fieldType instanceof NullOpenClass) {
            String errorMessage = String.format("Type %s is not found", tableSrc.getCode());
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)tableSrc);
        }
        if (row.getWidth() < 2) {
            String errorMessage = "Bad table structure: must be {header} / {type | name}";
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)tableSrc);
        }
        return fieldType;
    }

    public void addTo(ModuleOpenClass openClass) {
        InternalDatatypeClass internalClassMember = new InternalDatatypeClass((IOpenClass)this.dataType, (IOpenClass)openClass);
        this.tableSyntaxNode.setMember((IOpenMember)internalClassMember);
    }

    public void finalizeBind(IBindingContext cxt) throws Exception {
        if (!cxt.isExecutionMode()) {
            this.tableSyntaxNode.setMetaInfoReader(new DatatypeTableMetaInfoReader(this));
        }
        if (this.parentClassName != null) {
            IOpenClass parentClass = cxt.findType("org.openl.this", this.parentClassName);
            if (parentClass == null) {
                throw new OpenLCompilationException(String.format("Parent class '%s' is not defined", this.parentClassName));
            }
            if (parentClass.getInstanceClass() != null) {
                if (Modifier.isFinal(parentClass.getInstanceClass().getModifiers())) {
                    throw new OpenLCompilationException(String.format("Cannot inherit from final class \"%s\"", this.parentClassName));
                }
                if (Modifier.isAbstract(parentClass.getInstanceClass().getModifiers())) {
                    throw new OpenLCompilationException(String.format("Cannot inherit from abstract class \"%s\"", this.parentClassName));
                }
            }
            if (parentClass instanceof DomainOpenClass) {
                throw new OpenLCompilationException(String.format("Parent class '%s' cannot be domain type", this.parentClassName));
            }
            this.dataType.setSuperClass(parentClass);
        }
        this.addFields(cxt);
        this.moduleOpenClass.addType((IOpenClass)this.dataType);
    }

    private void checkInheritedFieldsDuplication(IBindingContext cxt) throws Exception {
        IOpenClass superClass = this.dataType.getSuperClass();
        if (superClass != null) {
            SyntaxNodeExceptionCollector syntaxNodeExceptionCollector = new SyntaxNodeExceptionCollector();
            for (Map.Entry<String, IOpenField> field : this.dataType.getDeclaredFields().entrySet()) {
                syntaxNodeExceptionCollector.run(() -> {
                    IOpenField fieldInParent = superClass.getField((String)field.getKey());
                    if (fieldInParent != null) {
                        if (fieldInParent.getType().getInstanceClass().equals(((IOpenField)field.getValue()).getType().getInstanceClass())) {
                            BindHelper.processWarn((String)String.format("Field [%s] has been already defined in class \"%s\"", field.getKey(), fieldInParent.getDeclaringClass().getDisplayName(0)), (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                        } else {
                            throw SyntaxNodeExceptionUtils.createError((String)String.format("Field [%s] has been already defined in class \"%s\" with another type", field.getKey(), fieldInParent.getDeclaringClass().getDisplayName(0)), (ISyntaxNode)this.tableSyntaxNode);
                        }
                    }
                });
            }
            syntaxNodeExceptionCollector.throwIfAny();
        }
    }

    public void removeDebugInformation(IBindingContext cxt) {
    }

    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }

    public DatatypeOpenClass getDataType() {
        return this.dataType;
    }

    public ILogicalTable getTable() {
        return this.table;
    }

    public IdentifierNode getParentClassIdentifier() {
        return this.parentClassIdentifier;
    }
}

