/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openl.binding.IBindingContext;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.binding.DependentTypesExtractor;
import org.openl.rules.datatype.binding.TopologicalSort;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

public final class DatatypesSorter {
    private DatatypesSorter() {
    }

    public static TableSyntaxNode[] sort(TableSyntaxNode[] datatypeNodes, IBindingContext bindingContext) {
        if (datatypeNodes == null) {
            return null;
        }
        Map<String, TableSyntaxNode> datatypes = DatatypesSorter.createTypesMap(bindingContext, datatypeNodes);
        List nodes = DatatypesSorter.wrapAll(datatypes, bindingContext);
        Set<TopologicalSort.TopoGraphNode<TableSyntaxNode>> sorted = new TopologicalSort().sort(nodes);
        return DatatypesSorter.unwrapAll(sorted);
    }

    private static List<TopologicalSort.TopoGraphNode<TableSyntaxNode>> wrapAll(Map<String, TableSyntaxNode> datatypes, IBindingContext bindingContext) {
        ArrayList<TopologicalSort.TopoGraphNode<TableSyntaxNode>> toSort = new ArrayList<TopologicalSort.TopoGraphNode<TableSyntaxNode>>();
        for (TableSyntaxNode datatype : datatypes.values()) {
            toSort.add(DatatypesSorter.wrap(datatype, datatypes, bindingContext, new HashMap<String, TopologicalSort.TopoGraphNode<TableSyntaxNode>>()));
        }
        return toSort;
    }

    private static TableSyntaxNode[] unwrapAll(Set<TopologicalSort.TopoGraphNode<TableSyntaxNode>> sorted) {
        TableSyntaxNode[] result = new TableSyntaxNode[sorted.size()];
        Iterator<TopologicalSort.TopoGraphNode<TableSyntaxNode>> iterator = sorted.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            TopologicalSort.TopoGraphNode<TableSyntaxNode> element = iterator.next();
            if (element != null) {
                result[i] = element.getObj();
            }
            ++i;
        }
        return result;
    }

    private static TopologicalSort.TopoGraphNode<TableSyntaxNode> wrap(TableSyntaxNode datatype, Map<String, TableSyntaxNode> datatypes, IBindingContext bindingContext, Map<String, TopologicalSort.TopoGraphNode<TableSyntaxNode>> dependentQueue) {
        DependentTypesExtractor dependeciesExtractor = new DependentTypesExtractor();
        Set<String> dependencies = dependeciesExtractor.extract(datatype, bindingContext);
        TopologicalSort.TopoGraphNode<TableSyntaxNode> forSort = new TopologicalSort.TopoGraphNode<TableSyntaxNode>(datatype);
        if (dependencies.isEmpty()) {
            return forSort;
        }
        String currentName = null;
        try {
            currentName = DatatypeHelper.getDatatypeName(datatype);
        }
        catch (OpenLCompilationException openLCompilationException) {
            // empty catch block
        }
        for (String dependency : dependencies) {
            if (!datatypes.containsKey(dependency) || dependency.equals(currentName)) continue;
            if (dependentQueue.containsKey(dependency)) {
                forSort.addDependency(dependentQueue.get(dependency));
                continue;
            }
            dependentQueue.put(currentName, forSort);
            forSort.addDependency(DatatypesSorter.wrap(datatypes.get(dependency), datatypes, bindingContext, dependentQueue));
            dependentQueue.remove(currentName);
        }
        return forSort;
    }

    private static Map<String, TableSyntaxNode> createTypesMap(IBindingContext bindingContext, TableSyntaxNode[] nodes) {
        LinkedHashMap<String, TableSyntaxNode> map = new LinkedHashMap<String, TableSyntaxNode>();
        for (TableSyntaxNode tsn : nodes) {
            SyntaxNodeException error;
            String message;
            if (!XlsNodeTypes.XLS_DATATYPE.equals((Object)tsn.getNodeType())) continue;
            try {
                String datatypeName = DatatypeHelper.getDatatypeName(tsn);
                if (datatypeName != null) {
                    if (map.containsKey(datatypeName)) {
                        message = String.format("Type with name '%s' already exists", datatypeName);
                        error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tsn);
                        tsn.addError(error);
                        bindingContext.addError(error);
                        continue;
                    }
                    map.put(datatypeName, tsn);
                    continue;
                }
                message = "Cannot recognize type name";
                error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tsn);
                tsn.addError(error);
                bindingContext.addError(error);
            }
            catch (OpenLCompilationException e) {
                message = "An error has occurred during compilation";
                error = SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ISyntaxNode)tsn);
                tsn.addError(error);
                bindingContext.addError(error);
            }
        }
        return map;
    }
}

