/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openl.gen.FieldDescription;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;

public class FieldDescriptionBuilder {
    private static final Map<String, Class<?>> CLASSMAP = Collections.unmodifiableMap(new HashMap<String, Class<?>>(8, 1.0f){
        {
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("char", Character.TYPE);
            this.put("short", Short.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("double", Double.TYPE);
            this.put("float", Float.TYPE);
            this.put("boolean", Boolean.TYPE);
        }
    });
    private final String typeName;
    private String defaultValueAsString;
    private Object defaultValue;

    private FieldDescriptionBuilder(String typeName) {
        this.typeName = typeName;
    }

    public static FieldDescriptionBuilder create(String typeName) {
        return new FieldDescriptionBuilder(typeName);
    }

    public FieldDescriptionBuilder setDefaultValueAsString(String defaultValueAsString) {
        this.defaultValueAsString = defaultValueAsString;
        return this;
    }

    public FieldDescriptionBuilder setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public FieldDescription build() {
        return new FieldDescription(this.typeName, this.getDefaultValue(), this.defaultValueAsString);
    }

    private Class<?> getType() {
        Class<?> cl = CLASSMAP.get(this.typeName);
        if (cl != null) {
            return cl;
        }
        try {
            return Class.forName(this.typeName);
        }
        catch (ClassNotFoundException e) {
            return Object.class;
        }
    }

    private Object getDefaultValue() {
        if (this.defaultValue == null && this.defaultValueAsString != null) {
            if ("_DEFAULT_".equals(this.defaultValueAsString)) {
                this.defaultValue = "_DEFAULT_";
            } else {
                if (this.typeName.startsWith("[[")) {
                    throw new IllegalStateException("Multi-dimensional arrays aren't supported!");
                }
                IString2DataConvertor<?> convertor = String2DataConvertorFactory.getConvertor(this.getType());
                this.defaultValue = convertor.parse(this.defaultValueAsString, null);
            }
        }
        return this.defaultValue;
    }
}

