/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.dt.data.DecisionTableDataType;
import org.openl.rules.fuzzy.OpenLFuzzyUtils;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.DTColumnsDefinition;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DtColumnsDefinitionMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.Runnable;
import org.openl.syntax.exception.SyntaxNodeExceptionCollector;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public abstract class ADtColumnsDefinitionTableBoundNode
extends ATableBoundNode
implements IMemberBoundNode {
    private String tableName;
    private OpenL openl;
    private XlsModuleOpenClass xlsModuleOpenClass;
    private static final int[] DEFAULT_HEADER_INDEXES = new int[]{0, 1, 2, 3};
    private static final int INPUTS_INDEX = 0;
    private static final int EXPRESSION_INDEX = 1;
    private static final int PARAMETER_INDEX = 2;
    private static final int TITLE_INDEX = 3;

    public ADtColumnsDefinitionTableBoundNode(TableSyntaxNode tableSyntaxNode, OpenL openl) {
        super(tableSyntaxNode);
        this.openl = openl;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addTo(ModuleOpenClass openClass) {
        this.xlsModuleOpenClass = (XlsModuleOpenClass)openClass;
    }

    public OpenL getOpenl() {
        return this.openl;
    }

    protected Object evaluateRuntime(IRuntimeEnv env) {
        return null;
    }

    protected XlsModuleOpenClass getXlsModuleOpenClass() {
        return this.xlsModuleOpenClass;
    }

    protected IParameterDeclaration getParameterDeclaration(IOpenSourceCodeModule paramSource, IBindingContext bindingContext) throws OpenLCompilationException {
        IdentifierNode[] nodes = Tokenizer.tokenize((IOpenSourceCodeModule)paramSource, (String)" \n\r");
        if (nodes.length > 2) {
            String errMsg = "Parameter format: <type> <name>";
            throw SyntaxNodeExceptionUtils.createError((String)errMsg, null, null, (IOpenSourceCodeModule)paramSource);
        }
        if (nodes.length == 0) {
            return null;
        }
        String typeCode = nodes[0].getText();
        IOpenClass type = RuleRowHelper.getType(typeCode, (ISyntaxNode)nodes[0], bindingContext);
        if (nodes.length == 1) {
            return new ParameterDeclaration(type, null);
        }
        String name = nodes[1].getIdentifier();
        return new ParameterDeclaration(type, name);
    }

    public IOpenClass getType() {
        return JavaOpenClass.VOID;
    }

    public void removeDebugInformation(IBindingContext cxt) {
    }

    protected abstract DTColumnsDefinition createDefinition(Map<String, List<IParameterDeclaration>> var1, IOpenMethodHeader var2, CompositeMethod var3);

    protected final void createAndAddDefinition(Map<String, List<IParameterDeclaration>> parameterDeclarations, IOpenMethodHeader header, CompositeMethod compositeMethod) {
        DTColumnsDefinition definition = this.createDefinition(parameterDeclarations, header, compositeMethod);
        this.getXlsModuleOpenClass().getXlsDefinitions().addDtColumnsDefinition(definition);
    }

    private int[] getHeaderIndexes(ILogicalTable tableBody, int[] tableStructure) {
        HashSet<String> headerTokens = new HashSet<String>();
        int[] headerIndexes = new int[4];
        int k = 0;
        for (int j = 0; j < tableStructure.length; ++j) {
            String d = tableBody.getSource().getCell(tableStructure[j], 0).getStringValue();
            headerTokens.add(d);
            if ("Title".equalsIgnoreCase(d)) {
                headerIndexes[3] = j;
                ++k;
                continue;
            }
            if ("Parameter".equalsIgnoreCase(d)) {
                headerIndexes[2] = j;
                ++k;
                continue;
            }
            if ("Expression".equalsIgnoreCase(d)) {
                headerIndexes[1] = j;
                ++k;
                continue;
            }
            if (!"Inputs".equalsIgnoreCase(d)) continue;
            headerIndexes[0] = j;
            ++k;
        }
        if (k == 4) {
            return headerIndexes;
        }
        return DEFAULT_HEADER_INDEXES;
    }

    private static int[] getTableStructure(ILogicalTable originalTable) {
        int w = originalTable.getSource().getWidth();
        int h = originalTable.getSource().getHeight();
        ArrayList<Integer> t = new ArrayList<Integer>();
        for (int i = 0; i < w; i += originalTable.getSource().getCell(i, h - 1).getWidth()) {
            t.add(i);
        }
        return ArrayUtils.toPrimitive((Integer[])t.toArray(new Integer[0]));
    }

    public void finalizeBind(IBindingContext cxt) throws Exception {
        TableSyntaxNode tsn = this.getTableSyntaxNode();
        ILogicalTable tableBody = tsn.getTableBody();
        if (tableBody == null) {
            return;
        }
        int[] tableStructure = ADtColumnsDefinitionTableBoundNode.getTableStructure(tableBody);
        int w = tableStructure.length;
        if (w != 4 && (w = (tableStructure = ADtColumnsDefinitionTableBoundNode.getTableStructure(tableBody = (ILogicalTable)tableBody.transpose())).length) != 4) {
            throw SyntaxNodeExceptionUtils.createError((String)"Wrong table structure: Expected 4 columns table: <Inputs> <Expression> <Parameter> <Title>.", (ISyntaxNode)this.getTableSyntaxNode());
        }
        int i = 0;
        int[] headerIndexes = this.getHeaderIndexes(tableBody, tableStructure);
        if (headerIndexes != DEFAULT_HEADER_INDEXES) {
            i = tableBody.getSource().getCell(0, 0).getHeight();
        } else {
            ILogicalTable tableBodyT = (ILogicalTable)tableBody.transpose();
            int[] tableStructureT = ADtColumnsDefinitionTableBoundNode.getTableStructure(tableBodyT);
            if (tableStructureT.length == 4) {
                int[] headerIndexesT = this.getHeaderIndexes(tableBodyT, tableStructureT);
                i = tableBodyT.getSource().getCell(0, 0).getHeight();
                tableBody = tableBodyT;
                tableStructure = tableStructureT;
                headerIndexes = headerIndexesT;
            }
        }
        int h = tableBody.getSource().getHeight();
        ILogicalTable tableBody1 = tableBody;
        int[] tableStructure1 = tableStructure;
        int[] headerIndexes1 = headerIndexes;
        DecisionTableDataType ruleExecutionType = new DecisionTableDataType(null, "DecisionTableDataType", this.openl, false);
        ComponentBindingContext dtHeaderBindingContext = new ComponentBindingContext(cxt, (ComponentOpenClass)ruleExecutionType);
        SyntaxNodeExceptionCollector syntaxNodeExceptionCollector = new SyntaxNodeExceptionCollector();
        while (i < h) {
            String signatureCode1 = tableBody.getSource().getCell(tableStructure[headerIndexes[0]], i).getStringValue();
            ICell inputsCell = tableBody.getSource().getCell(tableStructure[headerIndexes[0]], i);
            if (StringUtils.isEmpty((CharSequence)signatureCode1)) {
                signatureCode1 = "";
            }
            final String signatureCode = signatureCode1;
            IGridTable expressionTable = (IGridTable)tableBody.getSource().getSubtable(tableStructure[headerIndexes[1]], i, 1, 1);
            ICell expressionCell = tableBody.getSource().getCell(tableStructure[headerIndexes[1]], i);
            int d = expressionTable.getCell(0, 0).getHeight();
            int z = i;
            syntaxNodeExceptionCollector.run(new Runnable((IBindingContext)dtHeaderBindingContext, cxt, inputsCell, expressionTable, d, tableBody1, tableStructure1, headerIndexes1, z, expressionCell){
                final /* synthetic */ IBindingContext val$dtHeaderBindingContext;
                final /* synthetic */ IBindingContext val$cxt;
                final /* synthetic */ ICell val$inputsCell;
                final /* synthetic */ IGridTable val$expressionTable;
                final /* synthetic */ int val$d;
                final /* synthetic */ ILogicalTable val$tableBody1;
                final /* synthetic */ int[] val$tableStructure1;
                final /* synthetic */ int[] val$headerIndexes1;
                final /* synthetic */ int val$z;
                final /* synthetic */ ICell val$expressionCell;
                {
                    this.val$dtHeaderBindingContext = iBindingContext;
                    this.val$cxt = iBindingContext2;
                    this.val$inputsCell = iCell;
                    this.val$expressionTable = iGridTable;
                    this.val$d = n;
                    this.val$tableBody1 = iLogicalTable;
                    this.val$tableStructure1 = nArray;
                    this.val$headerIndexes1 = nArray2;
                    this.val$z = n2;
                    this.val$expressionCell = iCell2;
                }

                public void run() throws Exception {
                    IOpenMethodHeader header;
                    try {
                        String prefix = JavaOpenClass.VOID.getName() + " " + RandomStringUtils.random((int)16, (boolean)true, (boolean)false) + "(";
                        String headerCode = prefix + signatureCode + ")";
                        header = OpenLManager.makeMethodHeader((OpenL)ADtColumnsDefinitionTableBoundNode.this.getOpenl(), (IOpenSourceCodeModule)new StringSourceCodeModule(headerCode, null), (IBindingContext)this.val$dtHeaderBindingContext);
                        if (!this.val$cxt.isExecutionMode()) {
                            ADtColumnsDefinitionTableBoundNode.this.addMetaInfoForInputs(header, this.val$inputsCell, headerCode, prefix.length());
                        }
                    }
                    catch (CompositeSyntaxNodeException e2) {
                        GridCellSourceCodeModule eGridCellSourceCodeModule = new GridCellSourceCodeModule(this.val$expressionTable, this.val$cxt);
                        throw SyntaxNodeExceptionUtils.createError((String)String.format("Failed to parse the cell '%s'", eGridCellSourceCodeModule.getCode()), (Throwable)e2, null, (IOpenSourceCodeModule)eGridCellSourceCodeModule);
                    }
                    int j = 0;
                    int j1 = 0;
                    HashMap<String, List<IParameterDeclaration>> localParameters = new HashMap<String, List<IParameterDeclaration>>();
                    ArrayList<IParameterDeclaration> parametersForMergedTitle = new ArrayList<IParameterDeclaration>();
                    HashSet<String> uniqueSetOfParameters = new HashSet<String>();
                    HashSet<String> uniqueSetOfTitles = new HashSet<String>();
                    String title = null;
                    IGridTable nullPCodeTable = null;
                    while (j < this.val$d) {
                        IGridTable pCodeTable = (IGridTable)this.val$tableBody1.getSource().getSubtable(this.val$tableStructure1[this.val$headerIndexes1[2]], this.val$z + j, 1, 1);
                        GridCellSourceCodeModule pGridCellSourceCodeModule = new GridCellSourceCodeModule(pCodeTable, this.val$cxt);
                        IParameterDeclaration parameterDeclaration = ADtColumnsDefinitionTableBoundNode.this.getParameterDeclaration(pGridCellSourceCodeModule, this.val$cxt);
                        parametersForMergedTitle.add(parameterDeclaration);
                        if (parameterDeclaration != null) {
                            if (parameterDeclaration.getName() != null) {
                                if (uniqueSetOfParameters.contains(parameterDeclaration.getName())) {
                                    throw SyntaxNodeExceptionUtils.createError((String)("Parameter '" + parameterDeclaration.getName() + "' has already been defined."), (IOpenSourceCodeModule)pGridCellSourceCodeModule);
                                }
                                uniqueSetOfParameters.add(parameterDeclaration.getName());
                            }
                            if (!this.val$cxt.isExecutionMode()) {
                                ICell parameterCell = this.val$tableBody1.getSource().getCell(this.val$tableStructure1[this.val$headerIndexes1[2]], this.val$z + j);
                                ADtColumnsDefinitionTableBoundNode.this.addMetaInfoForParameter(parameterDeclaration, parameterCell);
                            }
                        } else {
                            IGridTable iGridTable = nullPCodeTable = nullPCodeTable == null ? pCodeTable : nullPCodeTable;
                        }
                        if (j1 <= j) {
                            IGridTable tCodeTable = (IGridTable)this.val$tableBody1.getSource().getSubtable(this.val$tableStructure1[this.val$headerIndexes1[3]], this.val$z + j, 1, 1);
                            String title1 = tCodeTable.getCell(0, 0).getStringValue();
                            if (StringUtils.isEmpty((CharSequence)title1)) {
                                GridCellSourceCodeModule tGridCellSourceCodeModule = new GridCellSourceCodeModule(tCodeTable, this.val$cxt);
                                throw SyntaxNodeExceptionUtils.createError((String)"Title can't be empty.", (IOpenSourceCodeModule)tGridCellSourceCodeModule);
                            }
                            title = OpenLFuzzyUtils.toTokenString(title1);
                            if (uniqueSetOfTitles.contains(title)) {
                                GridCellSourceCodeModule tGridCellSourceCodeModule = new GridCellSourceCodeModule(tCodeTable, this.val$cxt);
                                throw SyntaxNodeExceptionUtils.createError((String)("Title '" + title1 + "' has already been defined."), (IOpenSourceCodeModule)tGridCellSourceCodeModule);
                            }
                            uniqueSetOfTitles.add(title);
                            j1 += tCodeTable.getCell(0, 0).getHeight();
                        }
                        if (j1 > (j += pCodeTable.getCell(0, 0).getHeight()) && j < this.val$d) continue;
                        if (parametersForMergedTitle.size() > 1 && parametersForMergedTitle.stream().anyMatch(Objects::isNull)) {
                            GridCellSourceCodeModule eGridCellSourceCodeModule = new GridCellSourceCodeModule(nullPCodeTable, this.val$cxt);
                            String errMsg = "Parameter cell format: <type> <name>";
                            throw SyntaxNodeExceptionUtils.createError((String)errMsg, null, null, (IOpenSourceCodeModule)eGridCellSourceCodeModule);
                        }
                        localParameters.put(title, parametersForMergedTitle);
                        parametersForMergedTitle = new ArrayList();
                    }
                    IParameterDeclaration[] allParameterDeclarations = localParameters.values().stream().flatMap(Collection::stream).filter(e -> e != null && e.getName() != null).collect(Collectors.toList()).toArray(new IParameterDeclaration[0]);
                    MethodSignature newSignature = ((MethodSignature)header.getSignature()).merge(allParameterDeclarations);
                    GridCellSourceCodeModule expressionCellSourceCodeModule = new GridCellSourceCodeModule(this.val$expressionTable, this.val$cxt);
                    CompositeMethod compositeMethod = OpenLManager.makeMethodWithUnknownType((OpenL)ADtColumnsDefinitionTableBoundNode.this.getOpenl(), (IOpenSourceCodeModule)expressionCellSourceCodeModule, (String)header.getName(), (IMethodSignature)newSignature, (IOpenClass)ADtColumnsDefinitionTableBoundNode.this.getXlsModuleOpenClass(), (IBindingContext)this.val$dtHeaderBindingContext);
                    if (!this.val$cxt.isExecutionMode()) {
                        ADtColumnsDefinitionTableBoundNode.this.addMetaInfoForExpression(compositeMethod, this.val$expressionCell);
                    }
                    ADtColumnsDefinitionTableBoundNode.this.createAndAddDefinition(localParameters, header, compositeMethod);
                }
            });
            i += d;
        }
        syntaxNodeExceptionCollector.throwIfAny();
    }

    private void addMetaInfoForExpression(CompositeMethod compositeMethod, ICell cell) {
        MetaInfoReader metaInfoReader = this.getTableSyntaxNode().getMetaInfoReader();
        if (metaInfoReader instanceof DtColumnsDefinitionMetaInfoReader) {
            DtColumnsDefinitionMetaInfoReader dtColumnsDefinitionMetaInfoReader = (DtColumnsDefinitionMetaInfoReader)metaInfoReader;
            dtColumnsDefinitionMetaInfoReader.addExpression(cell.getAbsoluteColumn(), cell.getAbsoluteRow(), compositeMethod, cell.getStringValue());
        }
    }

    private void addMetaInfoForInputs(IOpenMethodHeader header, ICell cell, String text, int from) {
        MetaInfoReader metaInfoReader = this.getTableSyntaxNode().getMetaInfoReader();
        if (metaInfoReader instanceof DtColumnsDefinitionMetaInfoReader) {
            DtColumnsDefinitionMetaInfoReader dtColumnsDefinitionMetaInfoReader = (DtColumnsDefinitionMetaInfoReader)metaInfoReader;
            dtColumnsDefinitionMetaInfoReader.addInput(cell.getAbsoluteColumn(), cell.getAbsoluteRow(), header, text, from);
        }
    }

    private void addMetaInfoForParameter(IParameterDeclaration parameterDeclaration, ICell cell) {
        MetaInfoReader metaInfoReader = this.getTableSyntaxNode().getMetaInfoReader();
        if (metaInfoReader instanceof DtColumnsDefinitionMetaInfoReader) {
            DtColumnsDefinitionMetaInfoReader dtColumnsDefinitionMetaInfoReader = (DtColumnsDefinitionMetaInfoReader)metaInfoReader;
            dtColumnsDefinitionMetaInfoReader.addParameter(cell.getAbsoluteColumn(), cell.getAbsoluteRow(), parameterDeclaration, cell.getStringValue());
        }
    }
}

