/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.Arrays;

abstract class DTHeader {
    int[] methodParameterIndexes;
    int column;
    String statement;
    int width;

    DTHeader(int[] methodParameterIndexes, String statement, int column, int width) {
        this.methodParameterIndexes = methodParameterIndexes;
        this.statement = statement;
        this.column = column;
        this.width = width;
    }

    abstract boolean isCondition();

    abstract boolean isHCondition();

    abstract boolean isAction();

    abstract boolean isReturn();

    int getWidth() {
        return this.width;
    }

    String getStatement() {
        return this.statement;
    }

    int[] getMethodParameterIndexes() {
        return this.methodParameterIndexes;
    }

    int getMethodParameterIndex() {
        if (this.methodParameterIndexes != null && this.methodParameterIndexes.length == 1) {
            return this.methodParameterIndexes[0];
        }
        throw new IllegalStateException();
    }

    int getColumn() {
        return this.column;
    }

    private String getTypeString() {
        if (this.isCondition()) {
            return "CONDITION";
        }
        if (this.isAction()) {
            return "ACTION";
        }
        return "RETURN";
    }

    public String toString() {
        return "DTHeader [type=" + this.getTypeString() + " methodParameterIndexes=" + Arrays.toString(this.methodParameterIndexes) + ", column=" + this.column + ", width=" + this.getWidth() + " statement=" + this.statement + "]";
    }
}

