/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

public class DTScale {
    private int vScale;
    private int hScale;
    private static final RowScale STANDARD_SCALE = new RowScale(){

        @Override
        public int getActualSize(int size) {
            return size;
        }

        @Override
        public int getActualIndex(int logicalIndex) {
            return logicalIndex;
        }

        @Override
        public int getLogicalIndex(int actualIndex) {
            return actualIndex;
        }

        @Override
        public int getMultiplier() {
            return 1;
        }
    };
    static final DTScale STANDARD = new DTScale(0, 0);

    public DTScale(int vScale, int hScale) {
        this.vScale = vScale;
        this.hScale = hScale;
    }

    public RowScale getVScale() {
        return this.vScale == 0 ? STANDARD_SCALE : new VScale();
    }

    public RowScale getHScale() {
        return this.hScale == 0 ? STANDARD_SCALE : new HScale();
    }

    static RowScale getStandardScale() {
        return STANDARD_SCALE;
    }

    class HScale
    implements RowScale {
        HScale() {
        }

        @Override
        public int getActualSize(int size) {
            assert (size == DTScale.this.vScale * DTScale.this.hScale);
            return DTScale.this.hScale;
        }

        @Override
        public int getActualIndex(int logicalIndex) {
            return logicalIndex / DTScale.this.vScale;
        }

        @Override
        public int getLogicalIndex(int actualIndex) {
            return actualIndex * DTScale.this.vScale;
        }

        @Override
        public int getMultiplier() {
            return DTScale.this.vScale;
        }
    }

    class VScale
    implements RowScale {
        VScale() {
        }

        @Override
        public int getActualSize(int size) {
            assert (size == DTScale.this.vScale * DTScale.this.hScale);
            return DTScale.this.vScale;
        }

        @Override
        public int getActualIndex(int logicalIndex) {
            return logicalIndex % DTScale.this.vScale;
        }

        @Override
        public int getLogicalIndex(int actualIndex) {
            return actualIndex;
        }

        @Override
        public int getMultiplier() {
            return DTScale.this.hScale;
        }
    }

    public static interface RowScale {
        public int getMultiplier();

        public int getActualSize(int var1);

        public int getActualIndex(int var1);

        public int getLogicalIndex(int var1);
    }
}

