/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.NumericComparableString;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.StringValue;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.dt.DTHeader;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.dt.DeclaredDTHeader;
import org.openl.rules.dt.FuzzyDTHeader;
import org.openl.rules.dt.MatchType;
import org.openl.rules.dt.MatchedDefinition;
import org.openl.rules.dt.SimpleDTHeader;
import org.openl.rules.dt.SimpleReturnDTHeader;
import org.openl.rules.fuzzy.OpenLFuzzyUtils;
import org.openl.rules.fuzzy.Token;
import org.openl.rules.helpers.CharRange;
import org.openl.rules.helpers.DateRange;
import org.openl.rules.helpers.DateRangeParser;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.helpers.StringRange;
import org.openl.rules.helpers.StringRangeParser;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.binding.DTColumnsDefinition;
import org.openl.rules.lang.xls.binding.XlsDefinitions;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.load.SimpleSheetLoader;
import org.openl.rules.lang.xls.load.SimpleWorkbookLoader;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DecisionTableMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.CompositeGrid;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.GridTable;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.AOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.StringTool;
import org.openl.util.text.TextInfo;

public final class DecisionTableHelper {
    private static final String RET1_COLUMN_NAME = DecisionTableColumnHeaders.RETURN.getHeaderKey() + "1";
    private static final String CRET1_COLUMN_NAME = DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey() + "1";
    private static final List<Class<?>> INT_TYPES = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Byte.class, Short.class, Integer.class, Long.class, ByteValue.class, ShortValue.class, IntValue.class, LongValue.class, BigInteger.class, BigIntegerValue.class);
    private static final List<Class<?>> DOUBLE_TYPES = Arrays.asList(Float.TYPE, Double.TYPE, Float.class, Double.class, FloatValue.class, DoubleValue.class, BigDecimal.class, BigDecimalValue.class);
    private static final List<Class<?>> CHAR_TYPES = Arrays.asList(Character.TYPE, Character.class);
    private static final List<Class<?>> STRING_TYPES = Arrays.asList(String.class, StringValue.class);
    private static final List<Class<?>> DATE_TYPES = Collections.singletonList(Date.class);
    private static final List<Class<?>> RANGE_TYPES = Arrays.asList(IntRange.class, DoubleRange.class, CharRange.class, StringRange.class, DateRange.class);
    private static final List<Class<?>> IGNORED_CLASSES_FOR_COMPOUND_TYPE = Arrays.asList(null, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Void.TYPE, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, BigInteger.class, BigDecimal.class, Date.class, IntRange.class, DoubleRange.class, CharRange.class, StringRange.class, DateRange.class, ByteValue.class, ShortValue.class, IntValue.class, LongValue.class, FloatValue.class, DoubleValue.class, BigIntegerValue.class, BigDecimalValue.class, StringValue.class, Object.class, Map.class, SortedMap.class, Set.class, SortedSet.class, List.class, Collections.class, ArrayList.class, LinkedList.class, HashSet.class, LinkedHashSet.class, HashMap.class, TreeSet.class, TreeMap.class, LinkedHashMap.class);
    private static final String FUZZY_RET_VARIABLE_NAME = "$R$E$T$U$R$N";
    private static final String[] MIN_MAX_ORDER = new String[]{"min", "max"};
    private static final String[] MAX_MIN_ORDER = new String[]{"max", "min"};
    private static final int FITS_MAX_LIMIT = 10000;
    private static final int MAX_NUMBER_OF_RETURNS = 3;

    private DecisionTableHelper() {
    }

    static boolean looksLikeVertical(ILogicalTable table) {
        int cnt2;
        if (table.getWidth() < 4) {
            return true;
        }
        if (table.getHeight() < 4) {
            return false;
        }
        int cnt1 = DecisionTableHelper.countConditionsAndActions(table);
        if (cnt1 != (cnt2 = DecisionTableHelper.countConditionsAndActions((ILogicalTable)table.transpose()))) {
            return cnt1 > cnt2;
        }
        return table.getWidth() <= 4;
    }

    static boolean isValidConditionHeader(String s) {
        return s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.CONDITION.getHeaderKey().charAt(0) && Character.isDigit(s.charAt(1));
    }

    static boolean isValidHConditionHeader(String headerStr) {
        return headerStr.startsWith(DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey()) && headerStr.length() > 2 && Character.isDigit(headerStr.charAt(2));
    }

    static boolean isValidMergedConditionHeader(String headerStr) {
        return headerStr.startsWith(DecisionTableColumnHeaders.MERGED_CONDITION.getHeaderKey()) && headerStr.length() > 2 && Character.isDigit(headerStr.charAt(2));
    }

    static boolean isValidActionHeader(String s) {
        return s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.ACTION.getHeaderKey().charAt(0) && Character.isDigit(s.charAt(1));
    }

    static boolean isValidRetHeader(String s) {
        return s.length() >= 3 && s.startsWith(DecisionTableColumnHeaders.RETURN.getHeaderKey()) && (s.length() == 3 || Character.isDigit(s.charAt(3)));
    }

    static boolean isValidKeyHeader(String s) {
        return s.length() >= 3 && s.startsWith(DecisionTableColumnHeaders.KEY.getHeaderKey()) && (s.length() == 3 || Character.isDigit(s.charAt(3)));
    }

    static boolean isValidCRetHeader(String s) {
        return s.length() >= 4 && s.startsWith(DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey()) && (s.length() == 4 || Character.isDigit(s.charAt(4)));
    }

    static boolean isValidRuleHeader(String s) {
        return s.equals(DecisionTableColumnHeaders.RULE.getHeaderKey());
    }

    static boolean isConditionHeader(String s) {
        return DecisionTableHelper.isValidConditionHeader(s) || DecisionTableHelper.isValidHConditionHeader(s) || DecisionTableHelper.isValidMergedConditionHeader(s);
    }

    private static int countConditionsAndActions(ILogicalTable table) {
        int width = table.getWidth();
        int count = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null) continue;
            count += DecisionTableHelper.isValidConditionHeader(value = value.toUpperCase()) || DecisionTableHelper.isValidActionHeader(value) || DecisionTableHelper.isValidRetHeader(value) || DecisionTableHelper.isValidCRetHeader(value) || DecisionTableHelper.isValidKeyHeader(value) ? 1 : 0;
        }
        return count;
    }

    static ILogicalTable preprocessDecisionTableWithoutHeaders(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IBindingContext bindingContext) throws OpenLCompilationException {
        XlsSheetGridModel virtualGrid = DecisionTableHelper.createVirtualGrid();
        DecisionTableHelper.writeVirtualHeaders(tableSyntaxNode, decisionTable, originalTable, virtualGrid, bindingContext);
        int sizeOfVirtualGridTable = virtualGrid.getMaxColumnIndex(0) < originalTable.getSource().getWidth() ? originalTable.getSource().getWidth() - 1 : virtualGrid.getMaxColumnIndex(0) - 1;
        GridTable virtualGridTable = new GridTable(0, 0, 2, sizeOfVirtualGridTable, virtualGrid);
        CompositeGrid grid = new CompositeGrid(new IGridTable[]{virtualGridTable, originalTable.getSource()}, true);
        int sizeofGrid = virtualGridTable.getWidth() < originalTable.getSource().getWidth() ? originalTable.getSource().getWidth() - 1 : virtualGridTable.getWidth() - 1;
        return LogicalTableHelper.logicalTable(new GridTable(0, 0, originalTable.getSource().getHeight() + 3 - 1, sizeofGrid, grid));
    }

    private static FuzzyContext buildFuzzyContext(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, int numberOfHcondition, IBindingContext bindingContext) {
        IOpenClass returnType;
        ParameterTokens parameterTokens = DecisionTableHelper.buildParameterTokens(decisionTable);
        Map<Token, IOpenMethod[][]> returnTypeFuzzyTokens = null;
        Token[] returnTokens = null;
        if (numberOfHcondition == 0 && DecisionTableHelper.isCompoundReturnType(returnType = DecisionTableHelper.getCompoundReturnType(tableSyntaxNode, decisionTable, bindingContext))) {
            returnTypeFuzzyTokens = OpenLFuzzyUtils.tokensMapToOpenClassSetterMethodsRecursively(returnType, returnType.getName(), 0);
            returnTokens = returnTypeFuzzyTokens.keySet().toArray(new Token[0]);
            return new FuzzyContext(parameterTokens, returnTokens, returnTypeFuzzyTokens, returnType);
        }
        return new FuzzyContext(parameterTokens);
    }

    private static void writeVirtualHeaders(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, IBindingContext bindingContext) throws OpenLCompilationException {
        int numberOfHcondition = DecisionTableHelper.isLookup(tableSyntaxNode) ? DecisionTableHelper.getNumberOfHConditions(originalTable) : 0;
        int firstColumnHeight = originalTable.getSource().getCell(0, 0).getHeight();
        FuzzyContext fuzzyContext = DecisionTableHelper.buildFuzzyContext(tableSyntaxNode, decisionTable, numberOfHcondition, bindingContext);
        NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter = new NumberOfColumnsUnderTitleCounter(originalTable, firstColumnHeight);
        List<DTHeader> dtHeaders = DecisionTableHelper.getDTHeaders(tableSyntaxNode, decisionTable, originalTable, fuzzyContext, numberOfColumnsUnderTitleCounter, numberOfHcondition, firstColumnHeight, bindingContext);
        DecisionTableHelper.writeConditions(decisionTable, originalTable, grid, numberOfColumnsUnderTitleCounter, dtHeaders, numberOfHcondition, firstColumnHeight, bindingContext);
        DecisionTableHelper.writeActions(decisionTable, originalTable, grid, dtHeaders, bindingContext);
        DecisionTableHelper.writeReturns(tableSyntaxNode, decisionTable, originalTable, grid, fuzzyContext, dtHeaders, bindingContext);
    }

    private static boolean isCompoundReturnType(IOpenClass compoundType) {
        if (IGNORED_CLASSES_FOR_COMPOUND_TYPE.contains(compoundType.getInstanceClass())) {
            return false;
        }
        if (compoundType.getConstructor(IOpenClass.EMPTY) == null) {
            return false;
        }
        int count = 0;
        for (IOpenMethod method : compoundType.getMethods()) {
            if (!OpenLFuzzyUtils.isSetterMethod(method)) continue;
            ++count;
        }
        return count > 0;
    }

    private static boolean isCompoundInputType(IOpenClass type) {
        if (IGNORED_CLASSES_FOR_COMPOUND_TYPE.contains(type.getInstanceClass())) {
            return false;
        }
        int count = 0;
        for (IOpenMethod method : type.getMethods()) {
            if (!OpenLFuzzyUtils.isGetterMethod(method)) continue;
            ++count;
        }
        return count > 0;
    }

    private static void validateCompoundReturnType(IOpenClass compoundType) throws OpenLCompilationException {
        try {
            compoundType.getInstanceClass().getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new OpenLCompilationException(String.format("Invalid compound return type: There is no default constructor found in return type '%s'", compoundType.getDisplayName(0)));
        }
    }

    private static void writeReturnMetaInfo(TableSyntaxNode tableSyntaxNode, ICell cell, String description, String uri) {
        MetaInfoReader metaReader = tableSyntaxNode.getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            metaInfoReader.addSimpleRulesReturn(cell.getAbsoluteRow(), cell.getAbsoluteColumn(), description, uri);
        }
    }

    private static IOpenClass getCompoundReturnType(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, IBindingContext bindingContext) {
        IOpenClass compoundType = DecisionTableHelper.isCollect(tableSyntaxNode) ? (tableSyntaxNode.getHeader().getCollectParameters().length > 0 ? bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[tableSyntaxNode.getHeader().getCollectParameters().length - 1]) : (decisionTable.getType().isArray() ? decisionTable.getType().getComponentClass() : decisionTable.getType())) : decisionTable.getType();
        return compoundType;
    }

    private static Pair<String, IOpenClass> buildStatementByMethodsChain(IOpenClass type, IOpenMethod[] methodsChain) {
        StringBuilder fieldChainSb = new StringBuilder();
        for (int i = 0; i < methodsChain.length; ++i) {
            IOpenField openField = type.getField(methodsChain[i].getName().substring(3), false);
            fieldChainSb.append(openField.getDisplayName(0));
            if (i < methodsChain.length - 1) {
                fieldChainSb.append(".");
            }
            type = methodsChain[i].getSignature().getNumberOfParameters() == 0 ? methodsChain[i].getType() : methodsChain[i].getSignature().getParameterType(0);
        }
        return Pair.of((Object)fieldChainSb.toString(), (Object)type);
    }

    private static void validateCollectSyntaxNode(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, IBindingContext bindingContext) throws OpenLCompilationException {
        int parametersCount = tableSyntaxNode.getHeader().getCollectParameters().length;
        IOpenClass type = decisionTable.getType();
        if ((type.isArray() || Collection.class.isAssignableFrom(type.getInstanceClass())) && parametersCount > 1) {
            throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Found more than one parameter for '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), type.getComponentClass().getDisplayName(0)));
        }
        if (Map.class.isAssignableFrom(type.getInstanceClass())) {
            if (parametersCount > 2) {
                throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Found more than two parameter for '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), type.getDisplayName(0)));
            }
            if (parametersCount == 1) {
                throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Found only one parameter for '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), type.getDisplayName(0)));
            }
        }
        for (String parameterType : tableSyntaxNode.getHeader().getCollectParameters()) {
            IOpenClass t = bindingContext.findType("org.openl.this", parameterType);
            if (t == null) {
                throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Cannot find type: '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), parameterType));
            }
            if (!type.isArray() || bindingContext.getCast(t, type.getComponentClass()) != null) continue;
            throw new OpenLCompilationException(String.format("Error: Cannot bind node: '%s'. Incompatible types: '%s' and '%s'.", Tokenizer.firstToken((IOpenSourceCodeModule)tableSyntaxNode.getHeader().getModule(), (String)"").getIdentifier(), type.getComponentClass().getDisplayName(0), t.getDisplayName(0)));
        }
    }

    private static void writeReturnWithReturnDtHeader(TableSyntaxNode tableSyntaxNode, ILogicalTable originalTable, IWritableGrid grid, DeclaredDTHeader declaredReturn, String header, IBindingContext bindingContext) {
        ICell cell;
        grid.setCellValue(declaredReturn.getColumn(), 0, header);
        grid.setCellValue(declaredReturn.getColumn(), 1, declaredReturn.getStatement());
        DTColumnsDefinition dtColumnsDefinition = declaredReturn.getMatchedDefinition().getDtColumnsDefinition();
        block0: for (int c = declaredReturn.getColumn(); c < originalTable.getSource().getWidth(); c += cell.getWidth()) {
            cell = originalTable.getSource().getCell(c, 0);
            String d = cell.getStringValue();
            d = OpenLFuzzyUtils.toTokenString(d);
            for (String title : dtColumnsDefinition.getTitles()) {
                if (!Objects.equals(d, title)) continue;
                List<IParameterDeclaration> localParameters = dtColumnsDefinition.getLocalParameters(title);
                ArrayList<String> localParameterNames = new ArrayList<String>();
                ArrayList<IOpenClass> typeOfColumns = new ArrayList<IOpenClass>();
                int column = c;
                for (IParameterDeclaration param : localParameters) {
                    if (param != null) {
                        String paramName = declaredReturn.getMatchedDefinition().getLocalParameterName(param.getName());
                        localParameterNames.add(paramName);
                        String value = param.getType().getName() + (paramName != null ? " " + paramName : "");
                        grid.setCellValue(column, 2, value);
                        typeOfColumns.add(param.getType());
                    } else {
                        typeOfColumns.add(declaredReturn.getCompositeMethod().getType());
                    }
                    int h = originalTable.getSource().getCell(column, 0).getHeight();
                    int w1 = originalTable.getSource().getCell(column, h).getWidth();
                    if (w1 > 1) {
                        grid.addMergedRegion(new GridRegion(2, column, 2, column + w1 - 1));
                    }
                    column += w1;
                }
                if (bindingContext.isExecutionMode()) continue block0;
                StringBuilder sb = new StringBuilder();
                sb.append("Return: ").append(header);
                if (!StringUtils.isEmpty((CharSequence)declaredReturn.getStatement())) {
                    sb.append("\n").append("Expression: ").append(declaredReturn.getStatement().replaceAll("\n", " "));
                }
                DecisionTableMetaInfoReader.appendParameters(sb, localParameterNames.toArray(new String[0]), typeOfColumns.toArray(new IOpenClass[0]));
                DecisionTableHelper.writeReturnMetaInfo(tableSyntaxNode, cell, sb.toString(), declaredReturn.getMatchedDefinition().getDtColumnsDefinition().getUri());
                continue block0;
            }
        }
        if (declaredReturn.getWidth() > 1) {
            for (int row = 0; row < 2; ++row) {
                grid.addMergedRegion(new GridRegion(row, declaredReturn.getColumn(), row, originalTable.getSource().getWidth() - 1));
            }
        }
    }

    private static IOpenClass writeReturnStatement(IOpenClass type, IOpenMethod[] methodChain, Set<String> generatedNames, Map<String, Map<IOpenMethod, String>> variables, String insertStatement, StringBuilder sb) {
        if (methodChain == null) {
            return type;
        }
        String currentVariable = FUZZY_RET_VARIABLE_NAME;
        for (int j = 0; j < methodChain.length; ++j) {
            String var = null;
            type = methodChain[j].getSignature().getParameterType(0);
            if (j < methodChain.length - 1) {
                Map vm = variables.get(currentVariable);
                if (vm == null || vm.get(methodChain[j]) == null) {
                    var = RandomStringUtils.random((int)8, (boolean)true, (boolean)false);
                    while (generatedNames.contains(var)) {
                        var = RandomStringUtils.random((int)8, (boolean)true, (boolean)false);
                    }
                    generatedNames.add(var);
                    sb.append(type.getName()).append(" ").append(var).append(" = new ").append(type.getName()).append("();");
                    vm = variables.computeIfAbsent(currentVariable, e -> new HashMap());
                    vm.put(methodChain[j], var);
                    sb.append(currentVariable).append(".");
                    sb.append(methodChain[j].getName());
                    sb.append("(");
                    sb.append(var);
                    sb.append(");");
                } else {
                    var = vm.get(methodChain[j]);
                }
                currentVariable = var;
                continue;
            }
            sb.append(currentVariable).append(".");
            sb.append(methodChain[j].getName());
            sb.append("(");
            sb.append(insertStatement);
            sb.append(");");
        }
        return type;
    }

    private static void writeInputParametersToReturnMetaInfo(DecisionTable decisionTable, String statementInInputParameters, String statementInReturn) {
        MetaInfoReader metaReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            metaInfoReader.addInputParametersToReturn(statementInInputParameters, statementInReturn);
        }
    }

    private static void writeInputParametersToReturn(DecisionTable decisionTable, FuzzyContext fuzzyContext, List<DTHeader> dtHeaders, Set<String> generatedNames, Map<String, Map<IOpenMethod, String>> variables, StringBuilder sb, IBindingContext bindingContext) {
        List fuzzyReturns = dtHeaders.stream().filter(e -> e instanceof FuzzyDTHeader).map(e -> (FuzzyDTHeader)e).filter(FuzzyDTHeader::isReturn).collect(Collectors.toList());
        HashMap m = new HashMap();
        for (Token token : fuzzyContext.getFuzzyReturnTokens()) {
            IOpenMethod[][] returnTypeMethodChains = fuzzyContext.getMethodChainsForReturnToken(token);
            for (int i = 0; i < returnTypeMethodChains.length; ++i) {
                boolean f = false;
                for (Map.Entry entry : m.entrySet()) {
                    if (!OpenLFuzzyUtils.isEqualsMethodChains((IOpenMethod[])entry.getKey(), returnTypeMethodChains[i])) continue;
                    ((List)entry.getValue()).add(token);
                    f = true;
                    break;
                }
                if (f) continue;
                ArrayList<Token> tokens = new ArrayList<Token>();
                tokens.add(token);
                m.put(returnTypeMethodChains[i], tokens);
            }
        }
        for (Map.Entry entry : m.entrySet()) {
            Pair<String, IOpenClass> p;
            IOpenCast cast;
            String statement;
            IOpenMethod[] methodChain = (IOpenMethod[])entry.getKey();
            boolean foundInReturns = fuzzyReturns.stream().anyMatch(e -> OpenLFuzzyUtils.isEqualsMethodChains(e.getMethodsChain(), methodChain));
            if (foundInReturns) continue;
            OpenLFuzzyUtils.FuzzyResult fuzzyResult = null;
            for (Token token : (List)entry.getValue()) {
                List<OpenLFuzzyUtils.FuzzyResult> fuzzyResults = OpenLFuzzyUtils.openlFuzzyExtract(token.getValue(), fuzzyContext.getParameterTokens().getTokens(), false);
                if ((fuzzyResult != null || fuzzyResults.size() != 1) && (fuzzyResult == null || fuzzyResults.size() != 1 || fuzzyResults.get(0).compareTo(fuzzyResult) >= 0)) continue;
                fuzzyResult = fuzzyResults.get(0);
            }
            if (fuzzyResult == null) continue;
            Token paramToken = fuzzyResult.getToken();
            int paramIndex = fuzzyContext.getParameterTokens().getParameterIndex(paramToken);
            IOpenClass type = decisionTable.getSignature().getParameterType(paramIndex);
            IOpenMethod[] paramMethodChain = fuzzyContext.getParameterTokens().getMethodsChain(paramToken);
            if (paramMethodChain != null) {
                Pair<String, IOpenClass> v = DecisionTableHelper.buildStatementByMethodsChain(type, paramMethodChain);
                statement = decisionTable.getSignature().getParameterName(paramIndex) + "." + (String)v.getKey();
                type = (IOpenClass)v.getValue();
            } else {
                statement = decisionTable.getSignature().getParameterName(paramIndex);
            }
            if (DecisionTableHelper.isCompoundInputType(type) || (cast = bindingContext.getCast(type, (IOpenClass)(p = DecisionTableHelper.buildStatementByMethodsChain(fuzzyContext.getFuzzyReturnType(), methodChain)).getValue())) == null || !cast.isImplicit()) continue;
            DecisionTableHelper.writeReturnStatement(fuzzyContext.getFuzzyReturnType(), methodChain, generatedNames, variables, statement, sb);
            if (bindingContext.isExecutionMode()) continue;
            String statementInReturn = fuzzyContext.getFuzzyReturnType().getDisplayName(0) + "." + (String)DecisionTableHelper.buildStatementByMethodsChain(fuzzyContext.getFuzzyReturnType(), methodChain).getKey();
            DecisionTableHelper.writeInputParametersToReturnMetaInfo(decisionTable, statement, statementInReturn);
        }
    }

    private static void writeFuzzyReturns(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, FuzzyContext fuzzyContext, List<DTHeader> dtHeaders, IOpenClass compoundReturnType, String header, IBindingContext bindingContext) throws OpenLCompilationException {
        DecisionTableHelper.validateCompoundReturnType(compoundReturnType);
        List fuzzyReturns = dtHeaders.stream().filter(e -> e instanceof FuzzyDTHeader && e.isReturn()).map(e -> (FuzzyDTHeader)e).collect(Collectors.toList());
        assert (!fuzzyReturns.isEmpty());
        StringBuilder sb = new StringBuilder();
        sb.append(compoundReturnType.getName()).append(" ").append(FUZZY_RET_VARIABLE_NAME).append(" = new ").append(compoundReturnType.getName()).append("();");
        HashSet<String> generatedNames = new HashSet<String>();
        while (generatedNames.size() < fuzzyReturns.size()) {
            generatedNames.add(RandomStringUtils.random((int)8, (boolean)true, (boolean)false));
        }
        String[] compoundColumnParamNames = generatedNames.toArray(new String[0]);
        HashMap<String, Map<IOpenMethod, String>> variables = new HashMap<String, Map<IOpenMethod, String>>();
        DecisionTableHelper.writeInputParametersToReturn(decisionTable, fuzzyContext, dtHeaders, generatedNames, variables, sb, bindingContext);
        int i = 0;
        for (FuzzyDTHeader fuzzyDTHeader : fuzzyReturns) {
            IOpenClass type = DecisionTableHelper.writeReturnStatement(compoundReturnType, fuzzyDTHeader.getMethodsChain(), generatedNames, variables, compoundColumnParamNames[i], sb);
            grid.setCellValue(fuzzyDTHeader.getColumn(), 2, type.getName() + " " + compoundColumnParamNames[i]);
            if (fuzzyDTHeader.getWidth() > 1) {
                grid.addMergedRegion(new GridRegion(2, fuzzyDTHeader.getColumn(), 2, fuzzyDTHeader.getColumn() + fuzzyDTHeader.getWidth() - 1));
            }
            if (!bindingContext.isExecutionMode()) {
                int lastRowInHeader = DecisionTableHelper.getLastRowHeader(originalTable, fuzzyDTHeader.getColumn(), originalTable.getCell(0, 0).getHeight());
                ICell cell = originalTable.getSource().getCell(fuzzyDTHeader.getColumn(), lastRowInHeader);
                String statement = (String)DecisionTableHelper.buildStatementByMethodsChain(compoundReturnType, fuzzyDTHeader.getMethodsChain()).getKey();
                StringBuilder sb1 = new StringBuilder();
                sb1.append("Return: ").append(header);
                if (!StringUtils.isEmpty((CharSequence)statement)) {
                    sb1.append("\n").append("Expression: value for return ").append(compoundReturnType.getDisplayName(0)).append(".").append(statement);
                }
                DecisionTableMetaInfoReader.appendParameters(sb1, null, new IOpenClass[]{type});
                DecisionTableHelper.writeReturnMetaInfo(tableSyntaxNode, cell, sb1.toString(), null);
            }
            ++i;
        }
        sb.append(FUZZY_RET_VARIABLE_NAME).append(";");
        grid.setCellValue(((FuzzyDTHeader)fuzzyReturns.get(0)).getColumn(), 0, header);
        grid.setCellValue(((FuzzyDTHeader)fuzzyReturns.get(0)).getColumn(), 1, sb.toString());
        int j = fuzzyReturns.size() - 1;
        if (((FuzzyDTHeader)fuzzyReturns.get(j)).getColumn() + ((FuzzyDTHeader)fuzzyReturns.get(j)).getWidth() - ((FuzzyDTHeader)fuzzyReturns.get(0)).getColumn() > 1) {
            for (int row = 0; row < 2; ++row) {
                grid.addMergedRegion(new GridRegion(row, ((FuzzyDTHeader)fuzzyReturns.get(0)).getColumn(), row, ((FuzzyDTHeader)fuzzyReturns.get(j)).getColumn() + ((FuzzyDTHeader)fuzzyReturns.get(j)).getWidth() - 1));
            }
        }
    }

    private static void writeSimpleDTReturnHeader(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, SimpleReturnDTHeader simpleReturnDTHeader, String header, int collectParameterIndex, IBindingContext bindingContext) {
        grid.setCellValue(simpleReturnDTHeader.getColumn(), 0, header);
        if (tableSyntaxNode.getHeader().getCollectParameters().length > 0) {
            grid.setCellValue(simpleReturnDTHeader.getColumn(), 2, tableSyntaxNode.getHeader().getCollectParameters()[collectParameterIndex]);
        }
        if (!bindingContext.isExecutionMode()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Return: ").append(header);
            ICell cell = originalTable.getSource().getCell(simpleReturnDTHeader.getColumn(), 0);
            if (!StringUtils.isEmpty((CharSequence)simpleReturnDTHeader.getStatement())) {
                sb.append("\n").append("Expression: ").append(simpleReturnDTHeader.getStatement());
            }
            DecisionTableMetaInfoReader.appendParameters(sb, null, new IOpenClass[]{decisionTable.getHeader().getType()});
            DecisionTableHelper.writeReturnMetaInfo(tableSyntaxNode, cell, sb.toString(), null);
        }
        if (simpleReturnDTHeader.getWidth() > 1) {
            for (int row = 0; row < 3; ++row) {
                grid.addMergedRegion(new GridRegion(row, simpleReturnDTHeader.getColumn(), row, simpleReturnDTHeader.getColumn() + simpleReturnDTHeader.getWidth() - 1));
            }
        }
    }

    private static void writeReturns(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, FuzzyContext fuzzyContext, List<DTHeader> dtHeaders, IBindingContext bindingContext) throws OpenLCompilationException {
        boolean isCollect = DecisionTableHelper.isCollect(tableSyntaxNode);
        if (isCollect) {
            DecisionTableHelper.validateCollectSyntaxNode(tableSyntaxNode, decisionTable, bindingContext);
        }
        if (DecisionTableHelper.isLookup(tableSyntaxNode)) {
            int firstReturnColumn = dtHeaders.stream().filter(e -> e.isCondition() || e.isAction()).mapToInt(e -> e.getColumn() + e.getWidth()).max().orElse(0);
            grid.setCellValue(firstReturnColumn, 0, isCollect ? CRET1_COLUMN_NAME : RET1_COLUMN_NAME);
            return;
        }
        if (dtHeaders.stream().filter(DTHeader::isReturn).anyMatch(e -> e.getColumn() + e.getWidth() - 1 >= originalTable.getSource().getWidth())) {
            throw new OpenLCompilationException("Wrong table structure: There is no column for return values");
        }
        int retNum = 1;
        int cretNum = 1;
        int i = 0;
        int collectParameterIndex = 0;
        int keyNum = 1;
        boolean skipFuzzyReturns = false;
        for (DTHeader dtHeader : dtHeaders) {
            if (!dtHeader.isReturn()) continue;
            if (dtHeader instanceof DeclaredDTHeader) {
                DecisionTableHelper.writeReturnWithReturnDtHeader(tableSyntaxNode, originalTable, grid, (DeclaredDTHeader)dtHeader, isCollect ? DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey() + cretNum++ : DecisionTableColumnHeaders.RETURN.getHeaderKey() + retNum++, bindingContext);
                continue;
            }
            if (dtHeader instanceof SimpleReturnDTHeader) {
                String header;
                boolean isKey = false;
                if (isCollect && tableSyntaxNode.getHeader().getCollectParameters().length > 1 && i == 0 && Map.class.isAssignableFrom(decisionTable.getType().getInstanceClass())) {
                    header = DecisionTableColumnHeaders.KEY.getHeaderKey() + keyNum++;
                    isKey = true;
                } else {
                    header = isCollect ? DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey() + cretNum++ : DecisionTableColumnHeaders.RETURN.getHeaderKey() + retNum++;
                }
                DecisionTableHelper.writeSimpleDTReturnHeader(tableSyntaxNode, decisionTable, originalTable, grid, (SimpleReturnDTHeader)dtHeader, header, collectParameterIndex, bindingContext);
                ++i;
                if (!isKey) continue;
                ++collectParameterIndex;
                continue;
            }
            if (!(dtHeader instanceof FuzzyDTHeader) || skipFuzzyReturns) continue;
            IOpenClass compoundReturnType = DecisionTableHelper.getCompoundReturnType(tableSyntaxNode, decisionTable, bindingContext);
            DecisionTableHelper.writeFuzzyReturns(tableSyntaxNode, decisionTable, originalTable, grid, fuzzyContext, dtHeaders, compoundReturnType, isCollect ? DecisionTableColumnHeaders.COLLECT_RETURN.getHeaderKey() + retNum++ : DecisionTableColumnHeaders.RETURN.getHeaderKey() + retNum++, bindingContext);
            skipFuzzyReturns = true;
        }
    }

    private static void writeDeclaredDtHeader(DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, DeclaredDTHeader dtHeader, String header, IBindingContext bindingContext) {
        int column = dtHeader.getColumn();
        grid.setCellValue(column, 0, header);
        grid.setCellValue(column, 1, dtHeader.getStatement());
        int firstColumn = column;
        for (int j = 0; j < dtHeader.getColumnParameters().length; ++j) {
            int firstTitleColumn = column;
            ArrayList<String> parameterNames = new ArrayList<String>();
            ArrayList<IOpenClass> typeOfColumns = new ArrayList<IOpenClass>();
            for (int k = 0; k < dtHeader.getColumnParameters()[j].length; ++k) {
                IParameterDeclaration param = dtHeader.getColumnParameters()[j][k];
                if (param != null) {
                    String paramName = dtHeader.getMatchedDefinition().getLocalParameterName(param.getName());
                    parameterNames.add(paramName);
                    grid.setCellValue(column, 2, param.getType().getName() + (paramName != null ? " " + paramName : ""));
                    typeOfColumns.add(param.getType());
                } else {
                    parameterNames.add(null);
                    typeOfColumns.add(dtHeader.getCompositeMethod().getType());
                }
                int h = originalTable.getSource().getCell(column, 0).getHeight();
                int w1 = originalTable.getSource().getCell(column, h).getWidth();
                if (w1 > 1) {
                    grid.addMergedRegion(new GridRegion(2, column, 2, column + w1 - 1));
                }
                column += w1;
            }
            if (bindingContext.isExecutionMode()) continue;
            if (dtHeader.isAction()) {
                DecisionTableHelper.writeMetaInfoForAction(originalTable, decisionTable, firstTitleColumn, header, parameterNames.toArray(new String[0]), dtHeader.getStatement(), typeOfColumns.toArray(new IOpenClass[0]), dtHeader.getMatchedDefinition().getDtColumnsDefinition().getUri());
                continue;
            }
            if (!dtHeader.isCondition()) continue;
            DecisionTableHelper.writeMetaInfoForVCondition(originalTable, decisionTable, firstTitleColumn, header, parameterNames.toArray(new String[0]), dtHeader.getStatement(), typeOfColumns.toArray(new IOpenClass[0]), dtHeader.getMatchedDefinition().getDtColumnsDefinition().getUri(), null);
        }
        if (column - firstColumn > 1) {
            for (int row = 0; row < 2; ++row) {
                grid.addMergedRegion(new GridRegion(row, firstColumn, row, column - 1));
            }
        }
    }

    private static void writeActions(DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, List<DTHeader> dtHeaders, IBindingContext bindingContext) throws OpenLCompilationException {
        List actions = dtHeaders.stream().filter(e -> e.isAction()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        int i = 0;
        for (DTHeader action : actions) {
            if (action.getColumn() >= originalTable.getSource().getWidth()) {
                String message = "Wrong table structure: Wrong number of action columns!";
                throw new OpenLCompilationException(message);
            }
            DeclaredDTHeader declaredAction = (DeclaredDTHeader)action;
            String header = (DecisionTableColumnHeaders.ACTION.getHeaderKey() + (i + 1)).intern();
            DecisionTableHelper.writeDeclaredDtHeader(decisionTable, originalTable, grid, declaredAction, header, bindingContext);
            ++i;
        }
    }

    private static boolean isVCondition(DTHeader condition) {
        return condition.isCondition() && !condition.isHCondition();
    }

    private static boolean getMinMaxOrder(ILogicalTable originalTable, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, int firstColumnHeight, int column, IOpenClass type) {
        ICell cell1;
        int height = originalTable.getSource().getHeight();
        int t1 = 0;
        int t2 = 0;
        IString2DataConvertor string2DataConvertor = String2DataConvertorFactory.getConvertor(type.getInstanceClass());
        for (int h = firstColumnHeight; h < height; h += cell1.getHeight()) {
            cell1 = originalTable.getSource().getCell(column, h);
            String s1 = cell1.getStringValue();
            Object o1 = string2DataConvertor.parse(s1, null);
            ICell cell2 = originalTable.getSource().getCell(column + numberOfColumnsUnderTitleCounter.getWidth(column, 0), h);
            String s2 = cell2.getStringValue();
            Object o2 = string2DataConvertor.parse(s2, null);
            if (JavaOpenClass.STRING.equals((Object)type)) {
                o1 = NumericComparableString.valueOf((String)((String)o1));
                o2 = NumericComparableString.valueOf((String)((String)o2));
            }
            if (!(o1 instanceof Comparable) || !(o2 instanceof Comparable)) continue;
            if (((Comparable)o1).compareTo(o2) > 0) {
                ++t1;
                continue;
            }
            if (((Comparable)o1).compareTo(o2) >= 0) continue;
            ++t2;
        }
        return t1 <= t2;
    }

    private static void writeConditions(DecisionTable decisionTable, ILogicalTable originalTable, IWritableGrid grid, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, List<DTHeader> dtHeaders, int numberOfHcondition, int firstColumnHeight, IBindingContext bindingContext) throws OpenLCompilationException {
        List conditions = dtHeaders.stream().filter(DTHeader::isCondition).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        int numOfVCondition = 0;
        int numOfHCondition = 0;
        int firstColumnForHConditions = dtHeaders.stream().filter(e -> e.isCondition() && !e.isHCondition() || e.isAction()).mapToInt(e -> e.getColumn() + e.getWidth()).max().orElse(0);
        HashMap<DTHeader, IOpenClass> hConditionTypes = new HashMap<DTHeader, IOpenClass>();
        for (DTHeader condition : conditions) {
            String message;
            int column = condition.getColumn();
            if (column > originalTable.getSource().getWidth()) {
                message = "Wrong table structure: Columns count is less than parameters count";
                throw new OpenLCompilationException(message);
            }
            if (column == originalTable.getSource().getWidth()) {
                message = "Wrong table structure: There is no column for return values";
                throw new OpenLCompilationException(message);
            }
            String header = DecisionTableHelper.isVCondition(condition) ? (++numOfVCondition == 1 && numberOfHcondition == 0 && conditions.size() < 2 ? (DecisionTableColumnHeaders.MERGED_CONDITION.getHeaderKey() + numOfVCondition).intern() : (DecisionTableColumnHeaders.CONDITION.getHeaderKey() + numOfVCondition).intern()) : (DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey() + ++numOfHCondition).intern();
            if (condition instanceof DeclaredDTHeader) {
                DecisionTableHelper.writeDeclaredDtHeader(decisionTable, originalTable, grid, (DeclaredDTHeader)condition, header, bindingContext);
                continue;
            }
            grid.setCellValue(column, 0, header);
            int numberOfColumnsUnderTitle = numberOfColumnsUnderTitleCounter.get(column);
            IOpenClass type = DecisionTableHelper.getTypeForCondition(decisionTable, condition);
            if (condition instanceof FuzzyDTHeader && numberOfColumnsUnderTitle == 2 && (type.getInstanceClass().isPrimitive() || Comparable.class.isAssignableFrom(type.getInstanceClass()))) {
                boolean minMaxOrder = DecisionTableHelper.getMinMaxOrder(originalTable, numberOfColumnsUnderTitleCounter, firstColumnHeight, column, type);
                String stringOperator = "";
                if (JavaOpenClass.STRING.equals((Object)type)) {
                    stringOperator = "string";
                }
                String statement = minMaxOrder ? "min " + stringOperator + "<= " + condition.getStatement() + " && " + condition.getStatement() + " " + stringOperator + "< max" : "max " + stringOperator + "> " + condition.getStatement() + " && " + condition.getStatement() + " " + stringOperator + ">= min";
                grid.setCellValue(column, 1, statement);
                grid.setCellValue(column, 2, type.getDisplayName(0) + " " + (minMaxOrder ? "min" : "max"));
                int w1 = numberOfColumnsUnderTitleCounter.getWidth(column, 0);
                if (w1 > 1) {
                    grid.addMergedRegion(new GridRegion(2, column, 2, column + w1 - 1));
                }
                grid.setCellValue(column + w1, 2, type.getDisplayName(0) + " " + (minMaxOrder ? "max" : "min"));
                int w2 = numberOfColumnsUnderTitleCounter.getWidth(column, 1);
                if (w2 > 1) {
                    grid.addMergedRegion(new GridRegion(2, column + w1, 2, column + w1 + w2 - 1));
                }
                if (!DecisionTableHelper.isVCondition(condition)) continue;
                if (!bindingContext.isExecutionMode()) {
                    DecisionTableHelper.writeMetaInfoForVCondition(originalTable, decisionTable, column, header, minMaxOrder ? MIN_MAX_ORDER : MAX_MIN_ORDER, statement, new IOpenClass[]{type, type}, null, null);
                }
                if (condition.getWidth() <= 1) continue;
                for (int row = 0; row < 2; ++row) {
                    grid.addMergedRegion(new GridRegion(row, column, row, column + condition.getWidth() - 1));
                }
                continue;
            }
            Triple<String[], IOpenClass, String> typeOfValue = DecisionTableHelper.getTypeForConditionColumn(decisionTable, originalTable, condition, numOfHCondition, firstColumnForHConditions, numberOfColumnsUnderTitle, bindingContext);
            grid.setCellValue(column, 1, typeOfValue.getRight());
            grid.setCellValue(column, 2, ((String[])typeOfValue.getLeft()).length == 1 ? ((String[])typeOfValue.getLeft())[0] : ((String[])typeOfValue.getLeft())[0] + " " + ((String[])typeOfValue.getLeft())[1]);
            if (DecisionTableHelper.isVCondition(condition)) {
                if (!bindingContext.isExecutionMode()) {
                    String[] stringArray;
                    if (((String[])typeOfValue.getLeft()).length == 1) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = ((String[])typeOfValue.getLeft())[1];
                    }
                    DecisionTableHelper.writeMetaInfoForVCondition(originalTable, decisionTable, column, header, stringArray, (String)typeOfValue.getRight(), new IOpenClass[]{(IOpenClass)typeOfValue.getMiddle()}, null, null);
                }
                if (condition.getWidth() <= 1) continue;
                for (int row = 0; row < 3; ++row) {
                    grid.addMergedRegion(new GridRegion(row, column, row, column + condition.getWidth() - 1));
                }
                continue;
            }
            hConditionTypes.put(condition, (IOpenClass)typeOfValue.getMiddle());
        }
        if (!bindingContext.isExecutionMode()) {
            DecisionTableHelper.writeMetaInfoForHConditions(originalTable, decisionTable, conditions, hConditionTypes);
        }
    }

    private static void writeMetaInfoForVCondition(ILogicalTable originalTable, DecisionTable decisionTable, int column, String header, String[] parameterNames, String conditionStatement, IOpenClass[] typeOfColumns, String url, String additionalDetails) {
        assert (header != null);
        MetaInfoReader metaReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            ICell cell = originalTable.getSource().getCell(column, 0);
            metaInfoReader.addSimpleRulesCondition(cell.getAbsoluteRow(), cell.getAbsoluteColumn(), header, parameterNames, conditionStatement, typeOfColumns, url, additionalDetails);
        }
    }

    private static void writeMetaInfoForAction(ILogicalTable originalTable, DecisionTable decisionTable, int column, String header, String[] parameterNames, String conditionStatement, IOpenClass[] typeOfColumns, String url) {
        assert (header != null);
        MetaInfoReader metaReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        if (metaReader instanceof DecisionTableMetaInfoReader) {
            DecisionTableMetaInfoReader metaInfoReader = (DecisionTableMetaInfoReader)metaReader;
            ICell cell = originalTable.getSource().getCell(column, 0);
            metaInfoReader.addSimpleRulesAction(cell.getAbsoluteRow(), cell.getAbsoluteColumn(), header, parameterNames, conditionStatement, typeOfColumns, url, null);
        }
    }

    private static void writeMetaInfoForHConditions(ILogicalTable originalTable, DecisionTable decisionTable, List<DTHeader> conditions, Map<DTHeader, IOpenClass> hConditionTypes) {
        MetaInfoReader metaInfoReader = decisionTable.getSyntaxNode().getMetaInfoReader();
        int j = 0;
        for (DTHeader condition : conditions) {
            ICell cell;
            if (DecisionTableHelper.isVCondition(condition)) continue;
            for (int column = condition.getColumn() - ((SimpleDTHeader)condition).getRow(); column < originalTable.getSource().getWidth(); column += cell.getWidth()) {
                cell = originalTable.getSource().getCell(column, j);
                String cellValue = cell.getStringValue();
                if (cellValue == null || !(metaInfoReader instanceof DecisionTableMetaInfoReader)) continue;
                IOpenClass type = hConditionTypes.get(condition);
                if (type == null) {
                    type = decisionTable.getSignature().getParameterType(condition.getMethodParameterIndex());
                }
                ((DecisionTableMetaInfoReader)metaInfoReader).addSimpleRulesCondition(cell.getAbsoluteRow(), cell.getAbsoluteColumn(), (DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey() + (j + 1)).intern(), null, decisionTable.getSignature().getParameterName(condition.getMethodParameterIndex()), new IOpenClass[]{type}, null, null);
            }
            ++j;
        }
    }

    private static void parseRec(ISyntaxNode node, MutableBoolean chain, boolean inChain, List<IdentifierNode> identifierNodes) {
        for (int i = 0; i < node.getNumberOfChildren(); ++i) {
            if ("identifier".equals(node.getChild(i).getType())) {
                if (chain.booleanValue()) continue;
                identifierNodes.add((IdentifierNode)node.getChild(i));
                if (!inChain) continue;
                chain.setTrue();
                continue;
            }
            if ("chain".equals(node.getChild(i).getType())) {
                boolean f = chain.booleanValue();
                DecisionTableHelper.parseRec(node.getChild(i), chain, true, identifierNodes);
                chain.setValue(f);
                continue;
            }
            if ("function".equals(node.getChild(i).getType())) {
                DecisionTableHelper.parseRec(node.getChild(i), new MutableBoolean(false), false, identifierNodes);
                continue;
            }
            DecisionTableHelper.parseRec(node.getChild(i), chain, inChain, identifierNodes);
        }
    }

    @SafeVarargs
    private static String replaceIdentifierNodeNamesInCode(String code, List<IdentifierNode> identifierNodes, Map<String, String> ... namesMaps) {
        TextInfo textInfo = new TextInfo(code);
        Collections.sort(identifierNodes, Comparator.comparingInt(e -> e.getLocation().getStart().getAbsolutePosition(textInfo)).reversed());
        StringBuilder sb = new StringBuilder(code);
        for (IdentifierNode identifierNode : identifierNodes) {
            int start = identifierNode.getLocation().getStart().getAbsolutePosition(textInfo);
            int end = identifierNode.getLocation().getEnd().getAbsolutePosition(textInfo);
            for (Map<String, String> m : namesMaps) {
                if (!m.containsKey(identifierNode.getIdentifier())) continue;
                sb.replace(start, end + 1, m.get(identifierNode.getIdentifier()));
            }
        }
        return sb.toString();
    }

    private static MatchedDefinition matchByDTColumnDefinition(DecisionTable decisionTable, DTColumnsDefinition definition, IBindingContext bindingContext) {
        MatchType[] matchTypes;
        int i;
        IOpenMethodHeader header = decisionTable.getHeader();
        if (definition.isReturn()) {
            IOpenClass methodReturnType = header.getType();
            IOpenClass definitionType = definition.getCompositeMethod().getType();
            IOpenCast openCast = bindingContext.getCast(definitionType, methodReturnType);
            if (openCast == null || !openCast.isImplicit()) {
                return null;
            }
        }
        ArrayList<IdentifierNode> identifierNodes = new ArrayList<IdentifierNode>();
        DecisionTableHelper.parseRec(definition.getCompositeMethod().getMethodBodyBoundNode().getSyntaxNode(), new MutableBoolean(false), false, identifierNodes);
        HashSet<String> methodParametersUsedInExpression = new HashSet<String>();
        HashMap<String, IParameterDeclaration> localParameters = new HashMap<String, IParameterDeclaration>();
        for (IParameterDeclaration localParameter : definition.getLocalParameters()) {
            localParameters.put(localParameter.getName(), localParameter);
        }
        for (IdentifierNode identifierNode : identifierNodes) {
            if (localParameters.containsKey(identifierNode.getIdentifier())) continue;
            methodParametersUsedInExpression.add(identifierNode.getIdentifier());
        }
        HashMap<String, String> methodParametersToRename = new HashMap<String, String>();
        HashSet<Integer> usedMethodParameterIndexes = new HashSet<Integer>();
        Iterator itr = methodParametersUsedInExpression.iterator();
        MatchType matchType = MatchType.STRICT;
        HashMap<String, Integer> paramToIndex = new HashMap<String, Integer>();
        block17: while (itr.hasNext()) {
            String param = (String)itr.next();
            int j = -1;
            for (i = 0; i < definition.getHeader().getSignature().getNumberOfParameters(); ++i) {
                if (!param.equals(definition.getHeader().getSignature().getParameterName(i))) continue;
                j = i;
                break;
            }
            if (j < 0) {
                itr.remove();
                continue;
            }
            paramToIndex.put(param, j);
            IOpenClass type = definition.getHeader().getSignature().getParameterType(j);
            for (int i2 = 0; i2 < header.getSignature().getNumberOfParameters(); ++i2) {
                if (!param.equals(header.getSignature().getParameterName(i2)) || !type.equals(header.getSignature().getParameterType(i2))) continue;
                usedMethodParameterIndexes.add(i2);
                methodParametersToRename.put(param, param);
                continue block17;
            }
        }
        for (MatchType mt : matchTypes = new MatchType[]{MatchType.STRICT_CASTED, MatchType.METHOD_PARAMS_RENAMED, MatchType.METHOD_PARAMS_RENAMED_CASTED}) {
            for (String param : methodParametersUsedInExpression) {
                if (methodParametersToRename.containsKey(param)) continue;
                int j = (Integer)paramToIndex.get(param);
                IOpenClass type = definition.getHeader().getSignature().getParameterType(j);
                boolean duplicatedMatch = false;
                for (int i3 = 0; i3 < header.getSignature().getNumberOfParameters(); ++i3) {
                    boolean predicate = true;
                    IOpenCast openCast = bindingContext.getCast(header.getSignature().getParameterType(i3), type);
                    switch (mt) {
                        case METHOD_PARAMS_RENAMED_CASTED: {
                            predicate = openCast != null && openCast.isImplicit();
                            break;
                        }
                        case STRICT_CASTED: {
                            predicate = openCast != null && openCast.isImplicit() && param.equals(header.getSignature().getParameterName(i3));
                            break;
                        }
                        case METHOD_PARAMS_RENAMED: {
                            predicate = type.equals(header.getSignature().getParameterType(i3));
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    if (usedMethodParameterIndexes.contains(i3) || !predicate) continue;
                    if (duplicatedMatch) {
                        return null;
                    }
                    duplicatedMatch = true;
                    matchType = mt;
                    usedMethodParameterIndexes.add(i3);
                    String newParam = null;
                    switch (mt) {
                        case METHOD_PARAMS_RENAMED_CASTED: 
                        case STRICT_CASTED: {
                            String typeName = type.getInstanceClass().getSimpleName();
                            if (bindingContext.findType("org.openl.this", typeName) == null) {
                                typeName = type.getJavaName();
                            }
                            newParam = "((" + typeName + ")" + header.getSignature().getParameterName(i3) + ")";
                            break;
                        }
                        case METHOD_PARAMS_RENAMED: {
                            newParam = header.getSignature().getParameterName(i3);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    methodParametersToRename.put(param, newParam);
                }
            }
        }
        if (usedMethodParameterIndexes.size() != methodParametersUsedInExpression.size()) {
            return null;
        }
        HashSet<String> methodParameterNames = new HashSet<String>();
        for (i = 0; i < header.getSignature().getNumberOfParameters(); ++i) {
            methodParameterNames.add(header.getSignature().getParameterName(i));
        }
        HashMap<String, String> renamedLocalParameters = new HashMap<String, String>();
        for (String paramName : methodParameterNames) {
            if (!localParameters.containsKey(paramName)) continue;
            int k = 1;
            String newParamName = "_" + paramName;
            while (localParameters.containsKey(newParamName) || renamedLocalParameters.containsValue(newParamName) || methodParameterNames.contains(newParamName)) {
                newParamName = "_" + paramName + "_" + k;
                ++k;
            }
            renamedLocalParameters.put(paramName, newParamName);
        }
        String code = definition.getCompositeMethod().getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        String newCode = DecisionTableHelper.replaceIdentifierNodeNamesInCode(code, identifierNodes, methodParametersToRename, renamedLocalParameters);
        int[] usedMethodParameterIndexesArray = ArrayUtils.toPrimitive((Integer[])usedMethodParameterIndexes.toArray(new Integer[0]));
        switch (matchType) {
            case STRICT: {
                return new MatchedDefinition(definition, newCode, usedMethodParameterIndexesArray, renamedLocalParameters, renamedLocalParameters.isEmpty() ? MatchType.STRICT : MatchType.STRICT_LOCAL_PARAMS_RENAMED);
            }
            case STRICT_CASTED: {
                return new MatchedDefinition(definition, newCode, usedMethodParameterIndexesArray, renamedLocalParameters, renamedLocalParameters.isEmpty() ? MatchType.STRICT_CASTED : MatchType.STRICT_CASTED_LOCAL_PARAMS_RENAMED);
            }
            case METHOD_PARAMS_RENAMED: {
                return new MatchedDefinition(definition, newCode, usedMethodParameterIndexesArray, renamedLocalParameters, renamedLocalParameters.isEmpty() ? MatchType.METHOD_PARAMS_RENAMED : MatchType.METHOD_LOCAL_PARAMS_RENAMED);
            }
            case METHOD_PARAMS_RENAMED_CASTED: {
                return new MatchedDefinition(definition, newCode, usedMethodParameterIndexesArray, renamedLocalParameters, renamedLocalParameters.isEmpty() ? MatchType.METHOD_PARAMS_RENAMED_CASTED : MatchType.METHOD_LOCAL_PARAMS_RENAMED_CASTED);
            }
        }
        return null;
    }

    private static ParameterTokens buildParameterTokens(DecisionTable decisionTable) {
        int i;
        int numberOfParameters = decisionTable.getSignature().getNumberOfParameters();
        HashMap<Token, Integer> tokenToParameterIndex = new HashMap<Token, Integer>();
        HashMap<Token, IOpenMethod[]> tokenToMethodsChain = new HashMap<Token, IOpenMethod[]>();
        HashSet<Token> tokens = new HashSet<Token>();
        HashSet<Token> tokensToIgnore = new HashSet<Token>();
        for (i = 0; i < numberOfParameters; ++i) {
            IOpenClass parameterType = decisionTable.getSignature().getParameterType(i);
            if (!DecisionTableHelper.isCompoundInputType(parameterType) || parameterType.isArray()) continue;
            Map<Token, IOpenMethod[][]> openClassFuzzyTokens = OpenLFuzzyUtils.tokensMapToOpenClassGetterMethodsRecursively(parameterType, decisionTable.getSignature().getParameterName(i), 1);
            for (Map.Entry<Token, IOpenMethod[][]> entry : openClassFuzzyTokens.entrySet()) {
                if (entry.getValue().length != 1 || tokensToIgnore.contains(entry.getKey())) continue;
                if (!tokens.contains(entry.getKey())) {
                    tokens.add(entry.getKey());
                    tokenToParameterIndex.put(entry.getKey(), i);
                    tokenToMethodsChain.put(entry.getKey(), entry.getValue()[0]);
                    continue;
                }
                tokens.remove(entry.getKey());
                tokenToParameterIndex.remove(entry.getKey());
                tokenToMethodsChain.remove(entry.getKey());
                tokensToIgnore.add(entry.getKey());
            }
        }
        for (i = 0; i < numberOfParameters; ++i) {
            String tokenString = OpenLFuzzyUtils.toTokenString(decisionTable.getSignature().getParameterName(i));
            Token token = new Token(tokenString, 0);
            tokenToParameterIndex.put(token, i);
            tokens.add(token);
        }
        return new ParameterTokens(tokens.toArray(new Token[0]), tokenToParameterIndex, tokenToMethodsChain);
    }

    private static void matchWithFuzzySearchRec(DecisionTable decisionTable, IGridTable gridTable, FuzzyContext fuzzyContext, List<DTHeader> dtHeaders, int numberOfHcondition, int firstColumnHeight, int columnWidth, int w, int h, StringBuilder sb, int sourceTableColumn, IBindingContext bindingContext, boolean onlyReturns) {
        String d = gridTable.getCell(w, h).getStringValue();
        int w0 = gridTable.getCell(w, h).getWidth();
        int h0 = gridTable.getCell(w, h).getHeight();
        int prev = sb.length();
        if (sb.length() == 0) {
            sb.append(d);
        } else {
            sb.append(" ");
            sb.append("/");
            sb.append(" ");
            sb.append(d);
        }
        if (h + h0 < firstColumnHeight) {
            int w1;
            for (int w2 = w; w2 < w + w0; w2 += w1) {
                w1 = gridTable.getCell(w2, h + h0).getWidth();
                DecisionTableHelper.matchWithFuzzySearchRec(decisionTable, gridTable, fuzzyContext, dtHeaders, numberOfHcondition, firstColumnHeight, columnWidth, w2, h + h0, sb, sourceTableColumn, bindingContext, onlyReturns);
            }
        } else {
            List<OpenLFuzzyUtils.FuzzyResult> fuzzyResults;
            String tokenizedTitleString = OpenLFuzzyUtils.toTokenString(sb.toString());
            if (fuzzyContext.isFuzzySupportsForReturnType()) {
                fuzzyResults = OpenLFuzzyUtils.openlFuzzyExtract(sb.toString(), fuzzyContext.getFuzzyReturnTokens(), true);
                for (OpenLFuzzyUtils.FuzzyResult fuzzyResult : fuzzyResults) {
                    IOpenMethod[][] methodChains = fuzzyContext.getMethodChainsForReturnToken(fuzzyResult.getToken());
                    assert (methodChains != null);
                    for (int j = 0; j < methodChains.length; ++j) {
                        assert (methodChains[j] != null);
                        dtHeaders.add(new FuzzyDTHeader(-1, null, sb.toString(), methodChains[j], sourceTableColumn + w, w0, fuzzyResult, true));
                    }
                }
            }
            if (!onlyReturns) {
                fuzzyResults = OpenLFuzzyUtils.openlFuzzyExtract(tokenizedTitleString, fuzzyContext.getParameterTokens().getTokens(), true);
                for (OpenLFuzzyUtils.FuzzyResult fuzzyResult : fuzzyResults) {
                    int paramIndex = fuzzyContext.getParameterTokens().getParameterIndex(fuzzyResult.getToken());
                    IOpenMethod[] methodsChain = fuzzyContext.getParameterTokens().getMethodsChain(fuzzyResult.getToken());
                    StringBuilder conditionStatement = new StringBuilder(decisionTable.getSignature().getParameterName(paramIndex));
                    if (methodsChain != null) {
                        Pair<String, IOpenClass> c = DecisionTableHelper.buildStatementByMethodsChain(decisionTable.getSignature().getParameterType(paramIndex), methodsChain);
                        String chainStatement = (String)c.getLeft();
                        conditionStatement.append(".");
                        conditionStatement.append(chainStatement);
                    }
                    dtHeaders.add(new FuzzyDTHeader(paramIndex, conditionStatement.toString(), sb.toString(), methodsChain, sourceTableColumn + w, w0, fuzzyResult, false));
                }
            }
        }
        sb.delete(prev, sb.length());
    }

    private static List<DTHeader> matchWithFuzzySearch(DecisionTable decisionTable, ILogicalTable originalTable, FuzzyContext fuzzyContext, int column, int numberOfHcondition, List<DTHeader> dtHeaders, int firstColumnHeight, IBindingContext bindingContext, boolean onlyReturns) {
        if (onlyReturns && !fuzzyContext.isFuzzySupportsForReturnType()) {
            return Collections.emptyList();
        }
        int w = originalTable.getSource().getCell(column, 0).getWidth();
        IGridTable gt = (IGridTable)originalTable.getSource().getSubtable(column, 0, w, firstColumnHeight);
        ArrayList<DTHeader> newDtHeaders = new ArrayList<DTHeader>();
        DecisionTableHelper.matchWithFuzzySearchRec(decisionTable, gt, fuzzyContext, newDtHeaders, numberOfHcondition, firstColumnHeight, w, 0, 0, new StringBuilder(), column, bindingContext, onlyReturns);
        dtHeaders.addAll(newDtHeaders);
        return Collections.unmodifiableList(newDtHeaders);
    }

    private static boolean isCompatibleHeaders(DTHeader a, DTHeader b) {
        DTHeader b1;
        DTHeader a1;
        int c1 = a.getColumn();
        int c2 = a.getColumn() + a.getWidth() - 1;
        int d1 = b.getColumn();
        int d2 = b.getColumn() + b.getWidth() - 1;
        if (c1 <= d1 && d1 <= c2 || c1 <= d2 && d2 <= c2 || d1 <= c2 && c2 <= d2 || d1 <= c1 && c1 <= d2) {
            return false;
        }
        if ((a.isCondition() && b.isAction() || a.isAction() && b.isReturn() || a.isCondition() && b.isReturn()) && c1 >= d1) {
            return false;
        }
        if ((b.isCondition() && a.isAction() || b.isAction() && a.isReturn() || b.isCondition() && a.isReturn()) && d1 >= c1) {
            return false;
        }
        if (a instanceof FuzzyDTHeader && b instanceof FuzzyDTHeader) {
            a1 = (FuzzyDTHeader)a;
            b1 = (FuzzyDTHeader)b;
            if (((FuzzyDTHeader)a1).isCondition() && ((FuzzyDTHeader)b1).isCondition() && ((FuzzyDTHeader)a1).getMethodParameterIndex() == ((FuzzyDTHeader)b1).getMethodParameterIndex() && Arrays.deepEquals(((FuzzyDTHeader)a1).getMethodsChain(), ((FuzzyDTHeader)b1).getMethodsChain())) {
                return false;
            }
            if (((FuzzyDTHeader)a1).isReturn() && ((FuzzyDTHeader)b1).isReturn() && DecisionTableHelper.methodsChainsIsCrossed(((FuzzyDTHeader)a1).getMethodsChain(), ((FuzzyDTHeader)b1).getMethodsChain())) {
                return false;
            }
        }
        if (a instanceof DeclaredDTHeader && b instanceof DeclaredDTHeader) {
            a1 = (DeclaredDTHeader)a;
            b1 = (DeclaredDTHeader)b;
            if (((DeclaredDTHeader)a1).getMatchedDefinition().getDtColumnsDefinition().equals(((DeclaredDTHeader)b1).getMatchedDefinition().getDtColumnsDefinition())) {
                return false;
            }
        }
        return true;
    }

    private static void bruteForceHeaders(int column, int numberOfVConditionParameters, List<DTHeader> dtHeaders, boolean[][] matrix, Map<Integer, List<Integer>> columnToIndex, List<Integer> usedIndexes, Set<Integer> usedParameterIndexes, List<List<DTHeader>> fits, Set<Integer> failedToFit, int numberOfReturns, int fuzzyReturnsFlag) {
        if (fits.size() > 10000) {
            return;
        }
        List<Integer> indexes = columnToIndex.get(column);
        if (indexes == null || usedParameterIndexes.size() >= numberOfVConditionParameters) {
            ArrayList<DTHeader> fit = new ArrayList<DTHeader>();
            for (Integer index : usedIndexes) {
                fit.add(dtHeaders.get(index));
            }
            fits.add(Collections.unmodifiableList(fit));
            if (indexes == null) {
                return;
            }
        }
        boolean last = true;
        for (Integer index : indexes) {
            int fuzzyReturnsFlag1;
            int numberOfReturns1;
            FuzzyDTHeader fuzzyDTHeader;
            boolean f = true;
            for (Integer usedIndex : usedIndexes) {
                if (matrix[index][usedIndex]) continue;
                f = false;
                break;
            }
            if (!f) continue;
            DTHeader dtHeader = dtHeaders.get(index);
            boolean isFuzzyReturn = false;
            if (dtHeader instanceof FuzzyDTHeader && (fuzzyDTHeader = (FuzzyDTHeader)dtHeader).isReturn()) {
                isFuzzyReturn = true;
            }
            if (isFuzzyReturn && fuzzyReturnsFlag == 2) continue;
            HashSet<Integer> usedParameterIndexesTo = new HashSet<Integer>(usedParameterIndexes);
            for (int i : dtHeader.getMethodParameterIndexes()) {
                usedParameterIndexesTo.add(i);
            }
            if (usedParameterIndexesTo.size() > numberOfVConditionParameters || (numberOfReturns1 = dtHeader.isReturn() && !isFuzzyReturn ? numberOfReturns + 1 : numberOfReturns) + ((fuzzyReturnsFlag1 = isFuzzyReturn && fuzzyReturnsFlag != 1 ? fuzzyReturnsFlag + 1 : fuzzyReturnsFlag) > 1 ? 1 : 0) > 3) continue;
            last = false;
            usedIndexes.add(index);
            DecisionTableHelper.bruteForceHeaders(column + dtHeader.getWidth(), numberOfVConditionParameters, dtHeaders, matrix, columnToIndex, usedIndexes, usedParameterIndexesTo, fits, failedToFit, numberOfReturns1, fuzzyReturnsFlag1);
            usedIndexes.remove(usedIndexes.size() - 1);
        }
        if (indexes != null && !indexes.isEmpty() && last) {
            for (Integer index : indexes) {
                failedToFit.add(index);
            }
        }
    }

    private static List<List<DTHeader>> filterHeadersByMax(List<List<DTHeader>> fits, ToLongFunction<List<DTHeader>> function, Predicate<List<DTHeader>> predicate) {
        long max = Long.MIN_VALUE;
        HashSet<Integer> functionIndexes = new HashSet<Integer>();
        HashSet<Integer> matchIndexes = new HashSet<Integer>();
        int index = 0;
        for (List<DTHeader> fit : fits) {
            if (predicate.test(fit)) {
                long current = function.applyAsLong(fit);
                if (current > max) {
                    max = current;
                    functionIndexes.clear();
                    functionIndexes.add(index);
                } else if (current == max) {
                    functionIndexes.add(index);
                }
            } else {
                matchIndexes.add(index);
            }
            ++index;
        }
        HashSet<Integer> indexes = new HashSet<Integer>(matchIndexes);
        indexes.addAll(functionIndexes);
        ArrayList<List<DTHeader>> newFits = new ArrayList<List<DTHeader>>();
        for (Integer i : indexes) {
            newFits.add(fits.get(i));
        }
        return newFits;
    }

    private static List<List<DTHeader>> filterHeadersByMin(List<List<DTHeader>> fits, ToLongFunction<List<DTHeader>> function, Predicate<List<DTHeader>> predicate) {
        long min = Long.MAX_VALUE;
        HashSet<Integer> functionIndexes = new HashSet<Integer>();
        HashSet<Integer> matchIndexes = new HashSet<Integer>();
        int index = 0;
        for (List<DTHeader> fit : fits) {
            if (predicate.test(fit)) {
                long current = function.applyAsLong(fit);
                if (current < min) {
                    min = current;
                    functionIndexes.clear();
                    functionIndexes.add(index);
                } else if (current == min) {
                    functionIndexes.add(index);
                }
            } else {
                matchIndexes.add(index);
            }
            ++index;
        }
        HashSet<Integer> indexes = new HashSet<Integer>(matchIndexes);
        indexes.addAll(functionIndexes);
        ArrayList<List<DTHeader>> newFits = new ArrayList<List<DTHeader>>();
        for (Integer i : indexes) {
            newFits.add(fits.get(i));
        }
        return newFits;
    }

    private static List<List<DTHeader>> filterHeadersByMatchType(List<List<DTHeader>> fits) {
        MatchType[] matchTypes = MatchType.values();
        Arrays.sort(matchTypes, Comparator.comparingInt(MatchType::getPriority));
        for (MatchType type : matchTypes) {
            fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().filter(x -> x instanceof DeclaredDTHeader).map(x -> (DeclaredDTHeader)x).filter(x -> type.equals((Object)x.getMatchedDefinition().getMatchType())).mapToLong(x -> x.getMatchedDefinition().getDtColumnsDefinition().getNumberOfTitles()).sum(), e -> true);
        }
        return fits;
    }

    private static boolean isLastDtColumnValid(DTHeader dtHeader, int maxColumn, int columnsForReturn) {
        if (dtHeader.isReturn()) {
            return dtHeader.getColumn() + dtHeader.getWidth() == maxColumn;
        }
        if (dtHeader.isCondition() || dtHeader.isAction()) {
            return dtHeader.getColumn() + dtHeader.getWidth() < maxColumn - columnsForReturn;
        }
        return true;
    }

    private static List<List<DTHeader>> filterWithWrongStructure(ILogicalTable originalTable, List<List<DTHeader>> fits, boolean twoColumnsInReturn) {
        int maxColumn = originalTable.getSource().getWidth();
        int w = 0;
        if (maxColumn > 0 && twoColumnsInReturn && maxColumn - (w = originalTable.getSource().getCell(maxColumn - 1, 0).getWidth()) > 0) {
            w += originalTable.getSource().getCell(maxColumn - 1 - w, 0).getWidth();
        }
        int w1 = w;
        return fits.stream().filter(e -> e.isEmpty() || DecisionTableHelper.isLastDtColumnValid((DTHeader)e.get(e.size() - 1), maxColumn, twoColumnsInReturn ? w1 : 0)).collect(Collectors.toList());
    }

    private static boolean methodsChainsIsCrossed(IOpenMethod[] m1, IOpenMethod[] m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 != null && m2 != null) {
            int i;
            for (i = 0; i < m1.length && i < m2.length && m1[i].equals(m2[i]); ++i) {
            }
            if (i == m1.length || i == m2.length) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAmbiguousFits(List<List<DTHeader>> fits, Predicate<DTHeader> predicate) {
        if (fits.size() <= 1) {
            return false;
        }
        Object[] dtHeaders0 = (DTHeader[])fits.get(0).stream().filter(predicate::test).toArray(DTHeader[]::new);
        for (int i = 1; i < fits.size(); ++i) {
            Object[] dtHeaders1 = (DTHeader[])fits.get(i).stream().filter(predicate::test).toArray(DTHeader[]::new);
            if (Arrays.equals(dtHeaders0, dtHeaders1)) continue;
            return true;
        }
        return false;
    }

    private static boolean intersect(int b1, int e1, int b2, int e2) {
        return b2 <= b1 && b1 <= e2 || b2 <= e1 && e1 <= e2 || b1 <= b2 && b2 <= e1 || b1 <= e2 && e2 <= e1;
    }

    private static List<DTHeader> optimizeDtHeaders(List<DTHeader> dtHeaders) {
        boolean[] f = new boolean[dtHeaders.size()];
        Arrays.fill(f, false);
        for (int i = 0; i < dtHeaders.size() - 1; ++i) {
            for (int j = i + 1; j < dtHeaders.size(); ++j) {
                if (!(dtHeaders.get(i) instanceof DeclaredDTHeader) || !(dtHeaders.get(j) instanceof DeclaredDTHeader)) continue;
                DeclaredDTHeader d1 = (DeclaredDTHeader)dtHeaders.get(i);
                DeclaredDTHeader d2 = (DeclaredDTHeader)dtHeaders.get(j);
                if (d1.getColumn() == d2.getColumn() && d1.getWidth() == d2.getWidth() || !DecisionTableHelper.intersect(d1.getColumn(), d1.getColumn() + d1.getWidth() - 1, d2.getColumn(), d2.getColumn() + d2.getWidth() - 1)) continue;
                f[i] = true;
                f[j] = true;
            }
        }
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (int i = 0; i < dtHeaders.size(); ++i) {
            if (!(dtHeaders.get(i) instanceof DeclaredDTHeader) || f[i]) continue;
            indexes.add(i);
        }
        ArrayList<DTHeader> ret = new ArrayList<DTHeader>(dtHeaders);
        Iterator itr = ret.iterator();
        block3: while (itr.hasNext()) {
            DTHeader dtHeader = (DTHeader)itr.next();
            if (dtHeader instanceof DeclaredDTHeader) continue;
            for (Integer index : indexes) {
                DTHeader t = dtHeaders.get(index);
                if (!DecisionTableHelper.intersect(t.getColumn(), t.getColumn() + t.getWidth() - 1, dtHeader.getColumn(), dtHeader.getColumn() + dtHeader.getWidth() - 1)) continue;
                itr.remove();
                continue block3;
            }
        }
        return ret;
    }

    private static List<List<DTHeader>> fitFuzzyDtHeaders(List<List<DTHeader>> fits, Predicate<FuzzyDTHeader> predicate) {
        long fuzzyConditionsCounts = fits.stream().mapToLong(e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).filter(x -> predicate.test((FuzzyDTHeader)x)).count()).max().orElse(0L);
        int i = 0;
        while ((long)i < fuzzyConditionsCounts) {
            int currentFuzzyConditionsCounts = i++;
            fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).filter(x -> predicate.test((FuzzyDTHeader)x)).mapToInt(x -> x.getFuzzyResult().getMax()).sum(), e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).filter(x -> predicate.test((FuzzyDTHeader)x)).count() != (long)currentFuzzyConditionsCounts);
            fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).filter(x -> predicate.test((FuzzyDTHeader)x)).mapToInt(x -> x.getFuzzyResult().getMin()).sum(), e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).filter(x -> predicate.test((FuzzyDTHeader)x)).count() != (long)currentFuzzyConditionsCounts);
            fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).filter(x -> predicate.test((FuzzyDTHeader)x)).mapToInt(x -> x.getFuzzyResult().getToken().getDistance()).sum(), e -> e.stream().filter(x -> x instanceof FuzzyDTHeader).map(x -> (FuzzyDTHeader)x).filter(x -> predicate.test((FuzzyDTHeader)x)).count() != (long)currentFuzzyConditionsCounts);
        }
        return fits;
    }

    private static List<DTHeader> fitDtHeaders(TableSyntaxNode tableSyntaxNode, ILogicalTable originalTable, List<DTHeader> dtHeaders, int numberOfParameters, int numberOfHcondition, boolean twoColumnsForReturn, int firstColumnHeight, IBindingContext bindingContext) throws OpenLCompilationException {
        dtHeaders = DecisionTableHelper.optimizeDtHeaders(dtHeaders);
        int numberOfParametersForVCondition = numberOfParameters - numberOfHcondition;
        boolean[][] matrix = new boolean[dtHeaders.size()][dtHeaders.size()];
        for (int i = 0; i < dtHeaders.size(); ++i) {
            for (int j = 0; j < dtHeaders.size(); ++j) {
                matrix[i][j] = true;
            }
        }
        HashMap<Integer, List<Integer>> columnToIndex = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < dtHeaders.size(); ++i) {
            List indexes = columnToIndex.computeIfAbsent(dtHeaders.get(i).getColumn(), e -> new ArrayList());
            indexes.add(i);
            for (int j = i; j < dtHeaders.size(); ++j) {
                if (i != j && DecisionTableHelper.isCompatibleHeaders(dtHeaders.get(i), dtHeaders.get(j))) continue;
                matrix[i][j] = false;
                matrix[j][i] = false;
            }
        }
        List<List<DTHeader>> fits = new ArrayList<List<DTHeader>>();
        HashSet<Integer> failedToFit = new HashSet<Integer>();
        DecisionTableHelper.bruteForceHeaders(0, numberOfParametersForVCondition, dtHeaders, matrix, columnToIndex, new ArrayList<Integer>(), new HashSet<Integer>(), fits, failedToFit, 0, 0);
        if (fits.size() > 10000) {
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT conditions. Too many options are found.", (ISyntaxNode)tableSyntaxNode));
        }
        fits = DecisionTableHelper.filterWithWrongStructure(originalTable, fits, twoColumnsForReturn);
        fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().filter(x -> x instanceof DeclaredDTHeader).mapToLong(x -> ((DeclaredDTHeader)x).getMatchedDefinition().getDtColumnsDefinition().getNumberOfTitles()).sum(), e -> true);
        fits = DecisionTableHelper.filterHeadersByMatchType(fits);
        if (numberOfHcondition != numberOfParameters) {
            fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().anyMatch(DTHeader::isCondition) ? 1L : 0L, e -> true);
        }
        fits = numberOfHcondition == 0 ? fits.stream().filter(e -> e.stream().anyMatch(DTHeader::isReturn)).collect(Collectors.toList()) : fits.stream().filter(e -> e.stream().filter(DTHeader::isReturn).count() == 0L).collect(Collectors.toList());
        fits = DecisionTableHelper.filterHeadersByMax(fits, e -> e.stream().flatMapToInt(c -> Arrays.stream(c.getMethodParameterIndexes())).distinct().count(), e -> true);
        fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(x -> x instanceof SimpleReturnDTHeader).count(), e -> e.stream().filter(x -> x instanceof SimpleReturnDTHeader).count() > 0L);
        fits = DecisionTableHelper.fitFuzzyDtHeaders(fits, e -> !e.isReturn());
        fits = DecisionTableHelper.fitFuzzyDtHeaders(fits, FuzzyDTHeader::isReturn);
        if (numberOfHcondition == 0 && fits.isEmpty()) {
            List<DTHeader> dths = dtHeaders;
            OptionalInt c = failedToFit.stream().mapToInt(e -> ((DTHeader)dths.get((int)e)).getColumn()).max();
            StringBuilder message = new StringBuilder();
            message.append("Failed to compile decision table.");
            if (c.isPresent()) {
                int c0 = c.getAsInt();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < firstColumnHeight; ++i) {
                    if (i > 0) {
                        sb.append(" ");
                        sb.append("/");
                        sb.append(" ");
                    }
                    sb.append(originalTable.getCell(c0, i).getStringValue());
                }
                message.append(" ");
                message.append("There is no match for column '" + sb.toString() + "'.");
            }
            throw new OpenLCompilationException(message.toString());
        }
        if (!fits.isEmpty()) {
            if (fits.size() > 1) {
                if (DecisionTableHelper.isAmbiguousFits(fits, DTHeader::isCondition)) {
                    bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT conditions. Use more appropriate titles for condition columns.", (ISyntaxNode)tableSyntaxNode));
                }
                if (DecisionTableHelper.isAmbiguousFits(fits, DTHeader::isAction)) {
                    bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT action columns. Use more appropriate titles for action columns.", (ISyntaxNode)tableSyntaxNode));
                }
                if (DecisionTableHelper.isAmbiguousFits(fits, DTHeader::isReturn)) {
                    bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)"Ambiguous matching of column titles to DT return columns. Use more appropriate titles for return columns.", (ISyntaxNode)tableSyntaxNode));
                }
            }
            fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(DTHeader::isReturn).count(), e -> true);
            fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(DTHeader::isAction).count(), e -> true);
            fits = DecisionTableHelper.filterHeadersByMin(fits, e -> e.stream().filter(DTHeader::isCondition).count(), e -> true);
            return fits.get(0);
        }
        return Collections.emptyList();
    }

    private static int getFirstColumnForHCondition(ILogicalTable originalTable, int numberOfHcondition, int firstColumnHeight) {
        int w = originalTable.getSource().getWidth();
        int ret = -1;
        for (int column = 0; column < w; column += originalTable.getSource().getCell(column, 0).getWidth()) {
            int rowsCount = DecisionTableHelper.calculateRowsCount(originalTable, column, firstColumnHeight);
            if (rowsCount != numberOfHcondition) {
                ret = -1;
            }
            if (rowsCount <= 1 || rowsCount != numberOfHcondition || ret >= 0) continue;
            ret = column;
        }
        return ret;
    }

    private static boolean columnWithFormulas(ILogicalTable originalTable, int firstColumnHeight, int column) {
        ICell cell;
        int height = originalTable.getSource().getHeight();
        int c = 0;
        int t = 0;
        for (int h = firstColumnHeight; h < height; h += cell.getHeight()) {
            cell = originalTable.getSource().getCell(column, h);
            String s = cell.getStringValue();
            if (!StringUtils.isEmpty((CharSequence)(s != null ? s.trim() : s)) && !RuleRowHelper.isFormula(s)) {
                ++c;
            }
            ++t;
        }
        return c <= t / 2 + t % 2;
    }

    private static List<DTHeader> getDTHeaders(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable originalTable, FuzzyContext fuzzyContext, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, int numberOfHcondition, int firstColumnHeight, IBindingContext bindingContext) throws OpenLCompilationException {
        int firstColumnForHCondition;
        boolean isSmart = DecisionTableHelper.isSmart(tableSyntaxNode);
        int numberOfParameters = decisionTable.getSignature().getNumberOfParameters();
        boolean twoColumnsForReturn = DecisionTableHelper.isTwoColumnsForReturn(tableSyntaxNode, decisionTable);
        XlsDefinitions xlsDefinitions = ((XlsModuleOpenClass)decisionTable.getDeclaringClass()).getXlsDefinitions();
        int lastColumn = originalTable.getSource().getWidth();
        if (numberOfHcondition != 0 && (firstColumnForHCondition = DecisionTableHelper.getFirstColumnForHCondition(originalTable, numberOfHcondition, firstColumnHeight)) > 0) {
            lastColumn = firstColumnForHCondition;
        }
        String returnTokenString = fuzzyContext != null && fuzzyContext.isFuzzySupportsForReturnType() ? OpenLFuzzyUtils.toTokenString(fuzzyContext.getFuzzyReturnType().getName()) : null;
        ArrayList<DTHeader> dtHeaders = new ArrayList<DTHeader>();
        int i = 0;
        int column = 0;
        while (column < lastColumn) {
            int w = originalTable.getSource().getCell(column, 0).getWidth();
            if (isSmart) {
                DecisionTableHelper.matchWithDtColumnsDefinitions(decisionTable, originalTable, column, xlsDefinitions, numberOfColumnsUnderTitleCounter, dtHeaders, firstColumnHeight, bindingContext);
                List<DTHeader> fuzzyHeaders = DecisionTableHelper.matchWithFuzzySearch(decisionTable, originalTable, fuzzyContext, column, numberOfHcondition, dtHeaders, firstColumnHeight, bindingContext, false);
                if (numberOfHcondition == 0) {
                    String titleForColumn = DecisionTableHelper.getTitleForColumn(originalTable, firstColumnHeight, column);
                    boolean f = false;
                    if (fuzzyContext.isFuzzySupportsForReturnType()) {
                        if (fuzzyHeaders.stream().noneMatch(DTHeader::isReturn) && numberOfColumnsUnderTitleCounter.get(column) == 1 && DecisionTableHelper.columnWithFormulas(originalTable, firstColumnHeight, column) || !OpenLFuzzyUtils.openlFuzzyExtract(titleForColumn, new Token[]{new Token(returnTokenString, 0)}, true).isEmpty()) {
                            f = true;
                        }
                    } else {
                        f = true;
                    }
                    if (f) {
                        int width = originalTable.getSource().getCell(column, 0).getWidth();
                        dtHeaders.add(new SimpleReturnDTHeader(null, titleForColumn, column, width));
                    }
                }
            } else {
                if (numberOfHcondition == 0 && i >= numberOfParameters) {
                    DecisionTableHelper.matchWithFuzzySearch(decisionTable, originalTable, fuzzyContext, column, numberOfHcondition, dtHeaders, firstColumnHeight, bindingContext, true);
                }
                if (i < numberOfParameters - numberOfHcondition) {
                    SimpleDTHeader simpleDTHeader = new SimpleDTHeader(i, decisionTable.getSignature().getParameterName(i), null, column, w);
                    dtHeaders.add(simpleDTHeader);
                } else if (numberOfHcondition == 0) {
                    SimpleReturnDTHeader simpleReturnDTHeader = new SimpleReturnDTHeader(null, null, column, w);
                    dtHeaders.add(simpleReturnDTHeader);
                }
            }
            column += w;
            ++i;
        }
        List<DTHeader> fit = DecisionTableHelper.fitDtHeaders(tableSyntaxNode, originalTable, dtHeaders, decisionTable.getSignature().getNumberOfParameters(), numberOfHcondition, twoColumnsForReturn, firstColumnHeight, bindingContext);
        if (numberOfHcondition > 0) {
            boolean[] parameterIsUsed = new boolean[numberOfParameters];
            Arrays.fill(parameterIsUsed, false);
            for (DTHeader dtHeader : fit) {
                int[] width = dtHeader.getMethodParameterIndexes();
                int n = width.length;
                for (int j = 0; j < n; ++j) {
                    int paramIndex = width[j];
                    parameterIsUsed[paramIndex] = true;
                }
            }
            int k = 0;
            for (boolean f : parameterIsUsed) {
                if (f) continue;
                ++k;
            }
            if (k < numberOfHcondition) {
                throw new OpenLCompilationException("No input parameter found for horizontal condition!");
            }
            column = fit.stream().filter(e -> e.isCondition() || e.isAction()).mapToInt(e -> e.getColumn() + e.getWidth()).max().orElse(0);
            ArrayList<DTHeader> fitWithHConditions = new ArrayList<DTHeader>(fit);
            int j = 0;
            for (int w = 0; w < numberOfParameters && j < numberOfHcondition; ++w) {
                if (parameterIsUsed[w]) continue;
                fitWithHConditions.add(new SimpleDTHeader(w, decisionTable.getSignature().getParameterName(w), column + j, j));
                ++j;
            }
            return Collections.unmodifiableList(fitWithHConditions);
        }
        return fit;
    }

    private static String getTitleForColumn(ILogicalTable originalTable, int firstColumnHeight, int column) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < firstColumnHeight; ++j) {
            if (j > 0) {
                sb.append(" ");
            }
            sb.append(originalTable.getSource().getCell(column, 0).getStringValue());
        }
        return sb.toString();
    }

    private static int getNumberOfHConditions(ILogicalTable tableBody) {
        int w = tableBody.getSource().getWidth();
        int d = tableBody.getSource().getCell(0, 0).getHeight();
        int k = 0;
        int i = 0;
        while (i < d) {
            i += tableBody.getSource().getCell(w - 1, i).getHeight();
            ++k;
        }
        return k;
    }

    private static boolean isTwoColumnsForReturn(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable) {
        boolean twoColumnsForReturn = false;
        if (DecisionTableHelper.isCollect(tableSyntaxNode) && Map.class.isAssignableFrom(decisionTable.getType().getInstanceClass())) {
            twoColumnsForReturn = true;
        }
        return twoColumnsForReturn;
    }

    private static void matchWithDtColumnsDefinitions(DecisionTable decisionTable, ILogicalTable originalTable, int column, XlsDefinitions definitions, NumberOfColumnsUnderTitleCounter numberOfColumnsUnderTitleCounter, List<DTHeader> dtHeaders, int firstColumnHeight, IBindingContext bindingContext) {
        if (firstColumnHeight != originalTable.getSource().getCell(column, 0).getHeight()) {
            return;
        }
        for (DTColumnsDefinition definition : definitions.getDtColumnsDefinitions()) {
            MatchedDefinition matchedDefinition;
            int x;
            HashSet<String> titles = new HashSet<String>(definition.getTitles());
            String title = originalTable.getSource().getCell(column, 0).getStringValue();
            title = OpenLFuzzyUtils.toTokenString(title);
            int numberOfColumnsUnderTitle = numberOfColumnsUnderTitleCounter.get(column);
            int i = 0;
            IParameterDeclaration[][] columnParameters = new IParameterDeclaration[definition.getNumberOfTitles()][];
            for (x = column; titles.contains(title) && numberOfColumnsUnderTitle == definition.getLocalParameters(title).size() && x < originalTable.getSource().getWidth(); x += originalTable.getSource().getCell(x, 0).getWidth()) {
                titles.remove(title);
                for (String s : definition.getTitles()) {
                    if (!s.equals(title)) continue;
                    columnParameters[i] = definition.getLocalParameters(title).toArray(new IParameterDeclaration[0]);
                    break;
                }
                ++i;
                title = originalTable.getSource().getCell(x, 0).getStringValue();
                title = OpenLFuzzyUtils.toTokenString(title);
                numberOfColumnsUnderTitle = numberOfColumnsUnderTitleCounter.get(x);
            }
            if (!titles.isEmpty() || (matchedDefinition = DecisionTableHelper.matchByDTColumnDefinition(decisionTable, definition, bindingContext)) == null) continue;
            DeclaredDTHeader dtHeader = new DeclaredDTHeader(matchedDefinition.getUsedMethodParameterIndexes(), definition.getCompositeMethod(), columnParameters, column, x - column, matchedDefinition);
            dtHeaders.add(dtHeader);
        }
    }

    public static Pair<Boolean, String[]> parsableAsArray(String src, Class<?> clazz, IBindingContext bindingContext) {
        String[] values = StringTool.splitAndEscape((String)src, (String)",", (String)"\\");
        try {
            for (String value : values) {
                String2DataConvertorFactory.parse(clazz, value, bindingContext);
            }
        }
        catch (Exception e) {
            return Pair.of((Object)false, (Object)values);
        }
        return Pair.of((Object)true, (Object)values);
    }

    public static boolean parsableAs(String src, Class<?> clazz, IBindingContext bindingContext) {
        try {
            String2DataConvertorFactory.parse(clazz, src, bindingContext);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static int calculateRowsCount(ILogicalTable originalTable, int column, int height) {
        int h = 0;
        int k = 0;
        while (h < height && h < originalTable.getSource().getHeight()) {
            h += originalTable.getSource().getCell(column, h).getHeight();
            ++k;
        }
        return k;
    }

    private static int getLastRowHeader(ILogicalTable originalTable, int column, int height) {
        int hLast = 0;
        for (int h = 0; h < height && h < originalTable.getSource().getHeight(); h += originalTable.getSource().getCell(column, h).getHeight()) {
            hLast = h;
        }
        return hLast;
    }

    private static Triple<String[], IOpenClass, String> buildTripleForTypeForConditionColumn(Class<?> rangeClass, DTHeader condition, boolean isArray, boolean isMoreThanOneColumnIsUsed) {
        int type = 0;
        if (isArray) {
            type = isMoreThanOneColumnIsUsed ? 2 : 1;
        } else {
            int n = type = isMoreThanOneColumnIsUsed ? 1 : 0;
        }
        if (type == 0) {
            return Triple.of((Object)new String[]{rangeClass.getSimpleName()}, (Object)JavaOpenClass.getOpenClass(rangeClass), (Object)condition.getStatement());
        }
        if (type == 1) {
            String localParamName = "_" + condition.getStatement().replaceAll("\\.", "_");
            return Triple.of((Object)new String[]{rangeClass.getSimpleName() + "[]", localParamName}, (Object)AOpenClass.getArrayType((IOpenClass)JavaOpenClass.getOpenClass(rangeClass), (int)1), (Object)("contains(" + localParamName + ", " + condition.statement + ")"));
        }
        if (type == 2) {
            String localParamName = "_" + condition.getStatement().replaceAll("\\.", "_");
            return Triple.of((Object)new String[]{rangeClass.getSimpleName() + "[][]", localParamName}, (Object)AOpenClass.getArrayType((IOpenClass)JavaOpenClass.getOpenClass(rangeClass), (int)2), (Object)("contains(" + localParamName + ", " + condition.statement + ")"));
        }
        throw new IllegalStateException();
    }

    private static Triple<String[], IOpenClass, String> getTypeForConditionColumn(DecisionTable decisionTable, ILogicalTable originalTable, DTHeader condition, int indexOfHCondition, int firstColumnForHConditions, int numberOfColumnsUnderTitle, IBindingContext bindingContext) {
        String value;
        int cellNum;
        int valueNum;
        int numberOfColumnsForCondition;
        int skip;
        int width;
        ILogicalTable decisionValues;
        int column = condition.getColumn();
        IOpenClass type = DecisionTableHelper.getTypeForCondition(decisionTable, condition);
        if (DecisionTableHelper.isVCondition(condition)) {
            decisionValues = LogicalTableHelper.logicalTable((IGridTable)originalTable.getSource().getColumns(column, column + numberOfColumnsUnderTitle - 1));
            width = decisionValues.getHeight();
            int firstColumnHeight = originalTable.getSource().getCell(0, 0).getHeight();
            skip = DecisionTableHelper.calculateRowsCount(originalTable, column, firstColumnHeight);
            numberOfColumnsForCondition = numberOfColumnsUnderTitle;
        } else {
            decisionValues = LogicalTableHelper.logicalTable((IGridTable)originalTable.getSource().getRow(indexOfHCondition - 1));
            width = decisionValues.getWidth();
            skip = firstColumnForHConditions;
            numberOfColumnsForCondition = 1;
        }
        boolean isAllParsableAsRangeFlag = true;
        boolean isAllLikelyNotRangeFlag = true;
        boolean isAllElementsLikelyNotRangeFlag = true;
        boolean isAllParsableAsSingleFlag = true;
        boolean isAllParsableAsDomainFlag = true;
        boolean isAllParsableAsArrayFlag = true;
        boolean arraySeparatorFoundFlag = false;
        boolean isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = false;
        boolean zeroStartedNumbersFoundFlag = false;
        boolean isIntType = INT_TYPES.contains(type.getInstanceClass());
        boolean isDoubleType = DOUBLE_TYPES.contains(type.getInstanceClass());
        boolean isCharType = CHAR_TYPES.contains(type.getInstanceClass());
        boolean isDateType = DATE_TYPES.contains(type.getInstanceClass());
        boolean isStringType = STRING_TYPES.contains(type.getInstanceClass());
        boolean isRangeType = RANGE_TYPES.contains(type.getInstanceClass());
        boolean canMadeDecisionAboutSingle = true;
        boolean[][] h = new boolean[width][numberOfColumnsForCondition];
        for (int i = 0; i < width; ++i) {
            Arrays.fill(h[i], true);
        }
        boolean isMoreThanOneColumnIsUsed = numberOfColumnsForCondition > 1;
        for (valueNum = skip; valueNum < width; ++valueNum) {
            ILogicalTable cellValues = DecisionTableHelper.isVCondition(condition) ? (ILogicalTable)decisionValues.getRow(valueNum) : (ILogicalTable)decisionValues.getColumn(valueNum);
            for (cellNum = 0; cellNum < numberOfColumnsForCondition; ++cellNum) {
                value = cellValues.getSource().getCell(0, cellNum).getStringValue();
                if (value == null || StringUtils.isEmpty((CharSequence)value)) {
                    h[valueNum][cellNum] = false;
                    continue;
                }
                if (RuleRowHelper.isFormula(value) && !isRangeType) {
                    try {
                        StringSourceCodeModule expressionCellSourceCodeModule = new StringSourceCodeModule(value.substring(value.indexOf("=")).trim(), null);
                        CompositeMethod compositeMethod = OpenLManager.makeMethodWithUnknownType((OpenL)bindingContext.getOpenL(), (IOpenSourceCodeModule)expressionCellSourceCodeModule, (String)RandomStringUtils.random((int)16, (boolean)true, (boolean)false), (IMethodSignature)decisionTable.getSignature(), (IOpenClass)decisionTable.getDeclaringClass(), (IBindingContext)bindingContext);
                        IOpenClass cellType = compositeMethod.getType();
                        boolean bl = canMadeDecisionAboutSingle = canMadeDecisionAboutSingle && type.equals(cellType);
                        if (cellType.isArray() && RANGE_TYPES.contains(cellType.getComponentClass().getInstanceClass())) {
                            isAllParsableAsArrayFlag = false;
                            isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            isAllLikelyNotRangeFlag = false;
                            isAllElementsLikelyNotRangeFlag = false;
                        }
                        if (RANGE_TYPES.contains(cellType.getInstanceClass())) {
                            isAllParsableAsArrayFlag = false;
                            isAllLikelyNotRangeFlag = false;
                            isAllElementsLikelyNotRangeFlag = false;
                        }
                        if (cellType.isArray()) {
                            isAllParsableAsSingleFlag = false;
                            isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                        }
                    }
                    catch (CompositeSyntaxNodeException expressionCellSourceCodeModule) {
                        // empty catch block
                    }
                    h[valueNum][cellNum] = false;
                    continue;
                }
                ConstantOpenField constantOpenField = RuleRowHelper.findConstantField(bindingContext, value);
                if (constantOpenField != null) {
                    if (constantOpenField.getType().isArray() && RANGE_TYPES.contains(constantOpenField.getType().getComponentClass().getInstanceClass())) {
                        isAllParsableAsArrayFlag = false;
                        isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                        isAllLikelyNotRangeFlag = false;
                        isAllElementsLikelyNotRangeFlag = false;
                    }
                    if (RANGE_TYPES.contains(constantOpenField.getType().getInstanceClass())) {
                        isAllParsableAsArrayFlag = false;
                        isAllLikelyNotRangeFlag = false;
                        isAllElementsLikelyNotRangeFlag = false;
                    }
                    if (constantOpenField.getType().isArray()) {
                        isAllParsableAsSingleFlag = false;
                        isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                    }
                    h[valueNum][cellNum] = false;
                    canMadeDecisionAboutSingle = canMadeDecisionAboutSingle && type.equals(constantOpenField.getType());
                    continue;
                }
                if (value.indexOf(",") >= 0) {
                    arraySeparatorFoundFlag = true;
                }
                try {
                    if ((isIntType || isDoubleType || isCharType) && isAllParsableAsSingleFlag && !DecisionTableHelper.parsableAs(value, type.getInstanceClass(), bindingContext)) {
                        isAllParsableAsSingleFlag = false;
                        continue;
                    }
                    if (!isStringType || !isAllParsableAsDomainFlag || type.getDomain() != null && type.getDomain().selectObject((Object)value)) continue;
                    isAllParsableAsDomainFlag = false;
                    continue;
                }
                catch (Exception compositeMethod) {
                    // empty catch block
                }
            }
        }
        if (canMadeDecisionAboutSingle && ((isIntType || isDoubleType || isCharType) && isAllParsableAsSingleFlag || isStringType && isAllParsableAsDomainFlag)) {
            return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, false, isMoreThanOneColumnIsUsed);
        }
        for (valueNum = skip; valueNum < width; ++valueNum) {
            ILogicalTable cellValue = DecisionTableHelper.isVCondition(condition) ? (ILogicalTable)decisionValues.getRow(valueNum) : (ILogicalTable)decisionValues.getColumn(valueNum);
            block10: for (cellNum = 0; cellNum < numberOfColumnsForCondition; ++cellNum) {
                if (!h[valueNum][cellNum]) continue;
                value = cellValue.getSource().getCell(0, cellNum).getStringValue();
                try {
                    Pair<Boolean, String[]> g;
                    Pair<Boolean, String[]> f;
                    if (isIntType) {
                        if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                            f = DecisionTableHelper.parsableAsArray(value, IntRange.class, bindingContext);
                            boolean parsableAsSingleRange = DecisionTableHelper.parsableAs(value, IntRange.class, bindingContext);
                            if (!((Boolean)f.getKey()).booleanValue() && !parsableAsSingleRange) {
                                isAllParsableAsRangeFlag = false;
                            }
                            if (((Boolean)f.getKey()).booleanValue() && ((String[])f.getValue()).length > 1 && !parsableAsSingleRange) {
                                isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            }
                        }
                        if (!isAllParsableAsArrayFlag) continue;
                        g = DecisionTableHelper.parsableAsArray(value, type.getInstanceClass(), bindingContext);
                        if (((Boolean)g.getKey()).booleanValue() && !zeroStartedNumbersFoundFlag) {
                            zeroStartedNumbersFoundFlag = Arrays.stream((Object[])g.getRight()).anyMatch(e -> e != null && e.length() > 1 && e.startsWith("0"));
                        }
                        if (((Boolean)g.getKey()).booleanValue()) continue;
                        isAllParsableAsArrayFlag = false;
                        continue;
                    }
                    if (isDoubleType) {
                        if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                            f = DecisionTableHelper.parsableAsArray(value, DoubleRange.class, bindingContext);
                            boolean parsableAsSingleRange = DecisionTableHelper.parsableAs(value, DoubleRange.class, bindingContext);
                            if (!((Boolean)f.getKey()).booleanValue() && !parsableAsSingleRange) {
                                isAllParsableAsRangeFlag = false;
                            }
                            if (((Boolean)f.getKey()).booleanValue() && ((String[])f.getValue()).length > 1 && !parsableAsSingleRange) {
                                isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            }
                        }
                        if (!isAllParsableAsArrayFlag) continue;
                        g = DecisionTableHelper.parsableAsArray(value, type.getInstanceClass(), bindingContext);
                        if (((Boolean)g.getKey()).booleanValue() && !zeroStartedNumbersFoundFlag) {
                            zeroStartedNumbersFoundFlag = Arrays.stream((Object[])g.getRight()).anyMatch(e -> e != null && e.length() > 1 && e.startsWith("0"));
                        }
                        if (((Boolean)g.getKey()).booleanValue()) continue;
                        isAllParsableAsArrayFlag = false;
                        continue;
                    }
                    if (isCharType) {
                        if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                            f = DecisionTableHelper.parsableAsArray(value, CharRange.class, bindingContext);
                            boolean parsableAsSingleRange = DecisionTableHelper.parsableAs(value, CharRange.class, bindingContext);
                            if (!((Boolean)f.getKey()).booleanValue() && !parsableAsSingleRange) {
                                isAllParsableAsRangeFlag = false;
                            }
                            if (((Boolean)f.getKey()).booleanValue() && ((String[])f.getValue()).length > 1 && !parsableAsSingleRange) {
                                isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            }
                        }
                        if (!isAllParsableAsArrayFlag || ((Boolean)(g = DecisionTableHelper.parsableAsArray(value, type.getInstanceClass(), bindingContext)).getKey()).booleanValue()) continue;
                        isAllParsableAsArrayFlag = false;
                        continue;
                    }
                    if (isDateType) {
                        Pair<Boolean, String[]> g2;
                        Object o = cellValue.getSource().getCell(0, 0).getObjectValue();
                        if (o instanceof Date) continue;
                        if (o instanceof String && !DecisionTableHelper.parsableAs(value, type.getInstanceClass(), bindingContext)) {
                            isAllParsableAsSingleFlag = false;
                        }
                        Pair<Boolean, String[]> f2 = null;
                        if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                            f2 = DecisionTableHelper.parsableAsArray(value, DateRange.class, bindingContext);
                            boolean parsableAsSingleRange = DecisionTableHelper.parsableAs(value, DateRange.class, bindingContext);
                            if (isAllParsableAsRangeFlag && !((Boolean)f2.getKey()).booleanValue() && !parsableAsSingleRange) {
                                isAllParsableAsRangeFlag = false;
                            }
                            if (((Boolean)f2.getKey()).booleanValue() && ((String[])f2.getValue()).length > 1 && !parsableAsSingleRange) {
                                isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                            }
                        }
                        if (isAllLikelyNotRangeFlag && o instanceof String && DateRangeParser.getInstance().likelyRangeThanDate(value)) {
                            isAllLikelyNotRangeFlag = false;
                        }
                        if (isAllElementsLikelyNotRangeFlag) {
                            if (f2 == null) {
                                f2 = DecisionTableHelper.parsableAsArray(value, DateRange.class, bindingContext);
                            }
                            String[] parsableAsSingleRange = (String[])f2.getValue();
                            int n = parsableAsSingleRange.length;
                            for (int i = 0; i < n; ++i) {
                                String v = parsableAsSingleRange[i];
                                if (!DateRangeParser.getInstance().likelyRangeThanDate(v)) continue;
                                isAllElementsLikelyNotRangeFlag = false;
                                break;
                            }
                        }
                        if (!isAllParsableAsArrayFlag || ((Boolean)(g2 = DecisionTableHelper.parsableAsArray(value, type.getInstanceClass(), bindingContext)).getKey()).booleanValue()) continue;
                        isAllParsableAsArrayFlag = false;
                        continue;
                    }
                    if (!isStringType) continue;
                    f = null;
                    if (isAllParsableAsRangeFlag || !isNotParsableAsSingleRangeButParsableAsRangesArrayFlag) {
                        f = DecisionTableHelper.parsableAsArray(value, StringRange.class, bindingContext);
                        if (isAllParsableAsRangeFlag && !((Boolean)f.getKey()).booleanValue() && !DecisionTableHelper.parsableAs(value, StringRange.class, bindingContext)) {
                            isAllParsableAsRangeFlag = false;
                        }
                        if (!isNotParsableAsSingleRangeButParsableAsRangesArrayFlag && ((Boolean)f.getKey()).booleanValue() && ((String[])f.getValue()).length > 1) {
                            isNotParsableAsSingleRangeButParsableAsRangesArrayFlag = true;
                        }
                    }
                    if (isAllLikelyNotRangeFlag && StringRangeParser.getInstance().likelyRangeThanString(value)) {
                        isAllLikelyNotRangeFlag = false;
                    }
                    if (!isAllElementsLikelyNotRangeFlag) continue;
                    if (f == null) {
                        f = DecisionTableHelper.parsableAsArray(value, StringRange.class, bindingContext);
                    }
                    for (String v : (String[])f.getValue()) {
                        if (!StringRangeParser.getInstance().likelyRangeThanString(v)) continue;
                        isAllElementsLikelyNotRangeFlag = false;
                        continue block10;
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (isDateType && isAllParsableAsRangeFlag && ((!isNotParsableAsSingleRangeButParsableAsRangesArrayFlag ? !isAllLikelyNotRangeFlag : !isAllElementsLikelyNotRangeFlag) || !isAllParsableAsArrayFlag)) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(DateRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (isIntType && isAllParsableAsRangeFlag && (!isAllParsableAsArrayFlag || zeroStartedNumbersFoundFlag)) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(IntRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (isDoubleType && isAllParsableAsRangeFlag && (!isAllParsableAsArrayFlag || zeroStartedNumbersFoundFlag)) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(DoubleRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (isCharType && isAllParsableAsRangeFlag && !isAllParsableAsArrayFlag) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(CharRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (DecisionTableHelper.isSmart(decisionTable.getSyntaxNode()) && isStringType && !isAllParsableAsDomainFlag && isAllParsableAsRangeFlag && ((!isNotParsableAsSingleRangeButParsableAsRangesArrayFlag ? !isAllLikelyNotRangeFlag : !isAllElementsLikelyNotRangeFlag) || !isAllParsableAsArrayFlag)) {
            return DecisionTableHelper.buildTripleForTypeForConditionColumn(StringRange.class, condition, isNotParsableAsSingleRangeButParsableAsRangesArrayFlag, isMoreThanOneColumnIsUsed);
        }
        if (!type.isArray() && isAllParsableAsArrayFlag && (!isAllParsableAsSingleFlag || arraySeparatorFoundFlag)) {
            return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, true, isMoreThanOneColumnIsUsed);
        }
        if (isAllParsableAsSingleFlag) {
            return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, false, isMoreThanOneColumnIsUsed);
        }
        if (!type.isArray()) {
            if (isDateType) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(DateRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            if (isIntType) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(IntRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            if (isDoubleType) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(DoubleRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            if (isCharType) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(CharRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            if (isStringType && DecisionTableHelper.isSmart(decisionTable.getSyntaxNode()) && !isAllParsableAsDomainFlag) {
                return DecisionTableHelper.buildTripleForTypeForConditionColumn(StringRange.class, condition, true, isMoreThanOneColumnIsUsed);
            }
            return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, true, isMoreThanOneColumnIsUsed);
        }
        return DecisionTableHelper.buildTripleForConditionColumnWithSimpleType(condition, type, false, isMoreThanOneColumnIsUsed);
    }

    private static Triple<String[], IOpenClass, String> buildTripleForConditionColumnWithSimpleType(DTHeader condition, IOpenClass type, boolean isArray, boolean isMoreThanOneColumnIsUsed) {
        int v = 0;
        if (isArray) {
            v = isMoreThanOneColumnIsUsed ? 2 : 1;
        } else {
            int n = v = isMoreThanOneColumnIsUsed ? 1 : 0;
        }
        if (v == 0) {
            return Triple.of((Object)new String[]{type.getName()}, (Object)type, (Object)condition.getStatement());
        }
        if (v == 1) {
            return Triple.of((Object)new String[]{type.getName() + "[]"}, (Object)AOpenClass.getArrayType((IOpenClass)type, (int)1), (Object)condition.getStatement());
        }
        if (v == 2) {
            return Triple.of((Object)new String[]{type.getName() + "[][]"}, (Object)AOpenClass.getArrayType((IOpenClass)type, (int)2), (Object)condition.getStatement());
        }
        throw new IllegalArgumentException();
    }

    private static IOpenClass getTypeForCondition(DecisionTable decisionTable, DTHeader condition) {
        FuzzyDTHeader fuzzyCondition;
        IOpenClass type = decisionTable.getSignature().getParameterTypes()[condition.getMethodParameterIndex()];
        if (condition instanceof FuzzyDTHeader && (fuzzyCondition = (FuzzyDTHeader)condition).getMethodsChain() != null) {
            type = fuzzyCondition.getMethodsChain()[fuzzyCondition.getMethodsChain().length - 1].getType();
        }
        return type;
    }

    public static XlsSheetGridModel createVirtualGrid(String poiSheetName, int numberOfColumns) {
        XSSFWorkbook workbook = numberOfColumns > 256 ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = workbook.createSheet(poiSheetName);
        return DecisionTableHelper.createVirtualGrid(sheet);
    }

    public static boolean isCollect(TableSyntaxNode tableSyntaxNode) {
        return tableSyntaxNode.getHeader().isCollect();
    }

    public static boolean isSmart(TableSyntaxNode tableSyntaxNode) {
        return DecisionTableHelper.isSmartDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSmartLookupTable(tableSyntaxNode);
    }

    public static boolean isSimple(TableSyntaxNode tableSyntaxNode) {
        return DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode);
    }

    public static boolean isLookup(TableSyntaxNode tableSyntaxNode) {
        return DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode) || DecisionTableHelper.isSmartLookupTable(tableSyntaxNode);
    }

    public static boolean isSmartDecisionTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SmartRules".equals(dtType);
    }

    public static boolean isSimpleDecisionTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleRules".equals(dtType);
    }

    public static boolean isSmartLookupTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SmartLookup".equals(dtType);
    }

    public static boolean isSimpleLookupTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleLookup".equals(dtType) || DecisionTableHelper.isSmartLookupTable(tableSyntaxNode);
    }

    static int countHConditionsByHeaders(ILogicalTable table) {
        int width = table.getWidth();
        int cnt = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || !DecisionTableHelper.isValidHConditionHeader(value = value.toUpperCase())) continue;
            ++cnt;
        }
        return cnt;
    }

    static int countVConditionsByHeaders(ILogicalTable table) {
        int width = table.getWidth();
        int cnt = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || !DecisionTableHelper.isValidConditionHeader(value = value.toUpperCase()) && !DecisionTableHelper.isValidMergedConditionHeader(value)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static XlsSheetGridModel createVirtualGrid() {
        HSSFSheet sheet = new HSSFWorkbook().createSheet();
        return DecisionTableHelper.createVirtualGrid((Sheet)sheet);
    }

    private static XlsSheetGridModel createVirtualGrid(Sheet sheet) {
        StringSourceCodeModule sourceCodeModule = new StringSourceCodeModule("", null);
        SimpleWorkbookLoader workbookLoader = new SimpleWorkbookLoader(sheet.getWorkbook());
        XlsWorkbookSourceCodeModule mockWorkbookSource = new XlsWorkbookSourceCodeModule((IOpenSourceCodeModule)sourceCodeModule, workbookLoader);
        XlsSheetSourceCodeModule mockSheetSource = new XlsSheetSourceCodeModule(new SimpleSheetLoader(sheet), mockWorkbookSource);
        return new XlsSheetGridModel(mockSheetSource);
    }

    private static class FuzzyContext {
        ParameterTokens parameterTokens;
        Token[] returnTokens = null;
        Map<Token, IOpenMethod[][]> returnTypeFuzzyTokens = null;
        IOpenClass fuzzyReturnType;

        private FuzzyContext(ParameterTokens parameterTokens) {
            this.parameterTokens = parameterTokens;
        }

        private FuzzyContext(ParameterTokens parameterTokens, Token[] returnTokens, Map<Token, IOpenMethod[][]> returnTypeFuzzyTokens, IOpenClass returnType) {
            this(parameterTokens);
            this.returnTokens = returnTokens;
            this.returnTypeFuzzyTokens = returnTypeFuzzyTokens;
            this.fuzzyReturnType = returnType;
        }

        public ParameterTokens getParameterTokens() {
            return this.parameterTokens;
        }

        public Token[] getFuzzyReturnTokens() {
            return this.returnTokens;
        }

        public IOpenMethod[][] getMethodChainsForReturnToken(Token token) {
            return this.returnTypeFuzzyTokens.get(token);
        }

        public boolean isFuzzySupportsForReturnType() {
            return this.returnTypeFuzzyTokens != null && this.returnTokens != null && this.fuzzyReturnType != null;
        }

        public IOpenClass getFuzzyReturnType() {
            return this.fuzzyReturnType;
        }
    }

    private static class NumberOfColumnsUnderTitleCounter {
        ILogicalTable logicalTable;
        int firstColumnHeight;
        Map<Integer, List<Integer>> numberOfColumnsMap = new HashMap<Integer, List<Integer>>();

        private List<Integer> init(int column) {
            int w0;
            int w = this.logicalTable.getSource().getCell(column, 0).getWidth();
            ArrayList<Integer> w1 = new ArrayList<Integer>();
            for (int i = 0; i < w; i += w0) {
                w0 = this.logicalTable.getSource().getCell(column + i, this.firstColumnHeight).getWidth();
                w1.add(w0);
            }
            return w1;
        }

        private int get(int column) {
            List numberOfColumns = this.numberOfColumnsMap.computeIfAbsent(column, e -> this.init(column));
            return numberOfColumns.size();
        }

        private int getWidth(int column, int num) {
            List numberOfColumns = this.numberOfColumnsMap.computeIfAbsent(column, e -> this.init(column));
            return (Integer)numberOfColumns.get(num);
        }

        private NumberOfColumnsUnderTitleCounter(ILogicalTable logicalTable, int firstColumnHeight) {
            this.logicalTable = logicalTable;
            this.firstColumnHeight = firstColumnHeight;
        }
    }

    private static final class ParameterTokens {
        Token[] tokens;
        Map<Token, Integer> tokensToParameterIndex;
        Map<Token, IOpenMethod[]> tokenToMethodsChain;

        public ParameterTokens(Token[] tokens, Map<Token, Integer> tokensToParameterIndex, Map<Token, IOpenMethod[]> tokenToMethodsChain) {
            this.tokens = tokens;
            this.tokensToParameterIndex = tokensToParameterIndex;
            this.tokenToMethodsChain = tokenToMethodsChain;
        }

        public IOpenMethod[] getMethodsChain(Token value) {
            return this.tokenToMethodsChain.get(value);
        }

        public int getParameterIndex(Token value) {
            return this.tokensToParameterIndex.get(value);
        }

        public Token[] getTokens() {
            return this.tokens;
        }
    }
}

