/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import org.openl.binding.MethodUtil;
import org.openl.domain.IIntIterator;
import org.openl.rules.dt.ActionInvoker;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.IBaseAction;
import org.openl.rules.dt.algorithm.FailOnMissException;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.method.RulesMethodInvoker;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public class DecisionTableInvoker
extends RulesMethodInvoker<DecisionTable> {
    DecisionTableInvoker(DecisionTable decisionTable) {
        super(decisionTable);
    }

    @Override
    public boolean canInvoke() {
        return ((DecisionTable)this.getInvokableMethod()).getAlgorithm() != null;
    }

    @Override
    public Object invokeSimple(Object target, Object[] params, IRuntimeEnv env) {
        IDecisionTableAlgorithm algorithm = ((DecisionTable)this.getInvokableMethod()).getAlgorithm();
        IIntIterator rulesIntIterator = algorithm.checkedRules(target, params, env);
        boolean atLeastOneRuleFired = false;
        ArrayList<Integer> r = new ArrayList<Integer>();
        while (rulesIntIterator.hasNext()) {
            atLeastOneRuleFired = true;
            r.add(rulesIntIterator.nextInt());
        }
        int[] rules = new int[r.size()];
        int i = 0;
        for (Integer v : r) {
            rules[i++] = v;
        }
        IBaseAction[] actions = ((DecisionTable)this.getInvokableMethod()).getActionRows();
        Object returnValue = Tracer.invoke((Invokable)new ActionInvoker(rules, actions), (Object)target, (Object[])params, (IRuntimeEnv)env, (Object)this);
        if (returnValue != null) {
            return returnValue;
        }
        if (!atLeastOneRuleFired && ((DecisionTable)this.getInvokableMethod()).shouldFailOnMiss()) {
            String method = MethodUtil.printMethodWithParameterValues((IOpenMethodHeader)((DecisionTable)this.getInvokableMethod()).getMethod(), (Object[])params);
            String message = String.format("%s failed to match any rule condition", method);
            throw new FailOnMissException(message, (DecisionTable)this.getInvokableMethod());
        }
        return null;
    }
}

