/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.TypeBoundNode;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.algorithm.DecisionTableOptimizedAlgorithm;
import org.openl.rules.dt.algorithm.DependentParametersOptimizedAlgorithm;
import org.openl.rules.dt.algorithm.IAlgorithmBuilder;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm.TwoDimensionalAlgorithm;
import org.openl.rules.dt.algorithm.evaluator.DefaultConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.data.DecisionTableDataType;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeExceptionCollector;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.ParameterMethodCaller;
import org.openl.types.impl.SourceCodeMethodCaller;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.StringUtils;

public class DecisionTableAlgorithmBuilder
implements IAlgorithmBuilder {
    private static final Pattern ARRAY_ACCESS_PATTERN = Pattern.compile(".+\\[.+]$");
    private IndexInfo baseInfo;
    private DecisionTable table;
    private IConditionEvaluator[] evaluators;
    private IOpenMethodHeader header;
    private OpenL openl;
    private IMethodSignature signature;
    private RuleRow ruleRow;

    public DecisionTableAlgorithmBuilder(DecisionTable decisionTable, IOpenMethodHeader header, OpenL openl) {
        this.table = decisionTable;
        this.header = header;
        this.signature = header.getSignature();
        this.openl = openl;
        this.ruleRow = this.table.getRuleRow();
    }

    private static String cutExpressionRoot(String expression) {
        StringTokenizer stringTokenizer = new StringTokenizer(expression, ".");
        if (stringTokenizer.hasMoreTokens()) {
            String v = stringTokenizer.nextToken();
            boolean arrayAccess = StringUtils.matches((Pattern)ARRAY_ACCESS_PATTERN, (CharSequence)v);
            if (arrayAccess) {
                v = v.substring(0, v.indexOf("["));
            }
            return v;
        }
        return expression;
    }

    static IOpenClass findExpressionType(IOpenClass type, String expression) {
        StringTokenizer stringTokenizer = new StringTokenizer(expression, ".");
        boolean isFirst = true;
        while (stringTokenizer.hasMoreTokens()) {
            IOpenField field;
            String v = stringTokenizer.nextToken();
            boolean arrayAccess = StringUtils.matches((Pattern)ARRAY_ACCESS_PATTERN, (CharSequence)v);
            if (isFirst) {
                if (arrayAccess) {
                    type = type.getComponentClass();
                }
                isFirst = false;
                continue;
            }
            if (arrayAccess) {
                v = v.substring(0, v.indexOf("["));
            }
            if (!(type = (field = type.getField(v)).getType()).isArray() || !arrayAccess) continue;
            type = type.getComponentClass();
        }
        return type;
    }

    private IDecisionTableAlgorithm buildAlgorithm() {
        if (this.table.getDtInfo().getNumberHConditions() > 0) {
            IndexInfo vInfo = this.baseInfo.makeVerticalInfo();
            IndexInfo hInfo = this.baseInfo.makeHorizontalalInfo();
            DecisionTableOptimizedAlgorithm va = new DecisionTableOptimizedAlgorithm(this.evaluators, this.table, vInfo);
            DecisionTableOptimizedAlgorithm ha = new DecisionTableOptimizedAlgorithm(this.evaluators, this.table, hInfo);
            return new TwoDimensionalAlgorithm(va, ha);
        }
        return new DecisionTableOptimizedAlgorithm(this.evaluators, this.table, this.baseInfo);
    }

    @Override
    public IDecisionTableAlgorithm prepareAndBuildAlgorithm(IBindingContext bindingContext) throws Exception {
        this.evaluators = this.prepareConditions(bindingContext);
        this.prepareActions(bindingContext);
        this.baseInfo = new IndexInfo().withTable(this.table);
        return this.buildAlgorithm();
    }

    private void prepareActions(IBindingContext bindingContext) throws Exception {
        DecisionTableDataType ruleExecutionType = new DecisionTableDataType(this.table, this.table.getName() + "Type", this.openl, false);
        ComponentBindingContext actionBindingContext = new ComponentBindingContext(bindingContext, (ComponentOpenClass)ruleExecutionType);
        int nActions = this.table.getNumberOfActions();
        for (int i = 0; i < nActions; ++i) {
            IAction action = this.table.getAction(i);
            this.prepareAction(action, (IBindingContext)actionBindingContext, ruleExecutionType);
        }
    }

    private void prepareAction(IAction action, IBindingContext actionBindingContext, DecisionTableDataType ruleExecutionType) throws Exception {
        action.prepareAction(this.header, this.signature, this.openl, actionBindingContext, this.ruleRow, (IOpenClass)ruleExecutionType, this.table.getSyntaxNode());
    }

    private IConditionEvaluator[] prepareConditions(IBindingContext bindingContext) throws Exception {
        DecisionTableDataType ruleExecutionType = new DecisionTableDataType(this.table, this.table.getName() + "Type", this.openl, true);
        ComponentBindingContext conditionBindingContext = new ComponentBindingContext(bindingContext, (ComponentOpenClass)ruleExecutionType);
        int nConditions = this.table.getNumberOfConditions();
        IConditionEvaluator[] evaluators = new IConditionEvaluator[nConditions];
        SyntaxNodeExceptionCollector syntaxNodeExceptionCollector = new SyntaxNodeExceptionCollector();
        int i = 0;
        while (i < nConditions) {
            int index = i++;
            syntaxNodeExceptionCollector.run(() -> this.lambda$prepareConditions$0(evaluators, index, ruleExecutionType, (IBindingContext)conditionBindingContext));
        }
        syntaxNodeExceptionCollector.throwIfAny("Error:");
        return evaluators;
    }

    private IConditionEvaluator prepareCondition(DecisionTableDataType ruleExecutionType, IBindingContext bindingContext, int index) throws Exception {
        ICondition condition = this.table.getCondition(index);
        condition.prepare((IOpenClass)NullOpenClass.the, this.signature, this.openl, bindingContext, this.ruleRow, (IOpenClass)ruleExecutionType, this.table.getSyntaxNode());
        IBoundMethodNode methodNode = ((CompositeMethod)condition.getMethod()).getMethodBodyBoundNode();
        IOpenSourceCodeModule source = methodNode.getSyntaxNode().getModule();
        if (StringUtils.isEmpty((CharSequence)source.getCode())) {
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot execute empty expression", (IOpenSourceCodeModule)source);
        }
        IBoundNode[] children = methodNode.getChildren();
        if (children != null && children.length == 1 && children[0].getChildren()[0] instanceof TypeBoundNode) {
            String message = String.format("Cannot execute expression with only type definition %s", source.getCode());
            throw SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source);
        }
        IOpenClass methodType = ((CompositeMethod)condition.getMethod()).getBodyType();
        if (condition.isDependentOnAnyParams()) {
            if (methodType != JavaOpenClass.BOOLEAN && methodType != JavaOpenClass.getOpenClass(Boolean.class)) {
                throw SyntaxNodeExceptionUtils.createError((String)"Condition must have boolean type if it depends on it's parameters", (IOpenSourceCodeModule)source);
            }
            IConditionEvaluator conditionEvaluator = DependentParametersOptimizedAlgorithm.makeEvaluator(condition, this.signature, bindingContext);
            condition.setConditionEvaluator(conditionEvaluator);
            if (conditionEvaluator != null) {
                IMethodCaller evaluator = this.makeOptimizedConditionMethodEvaluator(condition, this.signature, conditionEvaluator.getOptimizedSourceCode());
                condition.setEvaluator(evaluator);
                if (evaluator == null) {
                    condition.setEvaluator(this.makeDependentParamsIndexedConditionMethodEvaluator(condition, this.signature, conditionEvaluator.getOptimizedSourceCode()));
                }
                return conditionEvaluator;
            }
            conditionEvaluator = new DefaultConditionEvaluator();
            condition.setConditionEvaluator(conditionEvaluator);
            return conditionEvaluator;
        }
        IConditionEvaluator dtcev = DecisionTableOptimizedAlgorithm.makeEvaluator(condition, methodType, bindingContext);
        condition.setEvaluator(this.makeOptimizedConditionMethodEvaluator(condition, this.signature));
        IConditionEvaluator conditionEvaluator = dtcev;
        condition.setConditionEvaluator(conditionEvaluator);
        return conditionEvaluator;
    }

    private IMethodCaller makeOptimizedConditionMethodEvaluator(ICondition condition, IMethodSignature signature) {
        String code = ((CompositeMethod)condition.getMethod()).getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        return this.makeOptimizedConditionMethodEvaluator(condition, signature, code);
    }

    private IMethodCaller makeOptimizedConditionMethodEvaluator(ICondition condition, IMethodSignature signature, String code) {
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            String pname = signature.getParameterName(i);
            if (!pname.equals(code)) continue;
            return new ParameterMethodCaller(condition.getMethod(), i);
        }
        return null;
    }

    private IMethodCaller makeDependentParamsIndexedConditionMethodEvaluator(ICondition condition, IMethodSignature signature, String optimizedCode) {
        String v = ((CompositeMethod)condition.getMethod()).getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        if (optimizedCode != null && !optimizedCode.equals(v)) {
            String p = DecisionTableAlgorithmBuilder.cutExpressionRoot(optimizedCode);
            for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
                String pname = signature.getParameterName(i);
                if (!pname.equals(p)) continue;
                IOpenClass type = DecisionTableAlgorithmBuilder.findExpressionType(signature.getParameterType(i), optimizedCode);
                return new SourceCodeMethodCaller(signature, type, optimizedCode);
            }
        }
        return null;
    }

    private /* synthetic */ void lambda$prepareConditions$0(IConditionEvaluator[] evaluators, int index, DecisionTableDataType ruleExecutionType, IBindingContext conditionBindingContext) throws Exception {
        evaluators[index] = this.prepareCondition(ruleExecutionType, conditionBindingContext, index);
    }
}

