/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.domain.IDomain;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.algorithm.IndexInfo;
import org.openl.rules.dt.algorithm.evaluator.AContainsInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.CombinedRangeIndexEvaluator;
import org.openl.rules.dt.algorithm.evaluator.ContainsInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.ContainsInArrayIndexedEvaluatorV2;
import org.openl.rules.dt.algorithm.evaluator.ContainsInOrNotInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.DefaultConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.DomainCanNotBeDefined;
import org.openl.rules.dt.algorithm.evaluator.EqualsIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.EqualsIndexedEvaluatorV2;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.data.ConditionOrActionParameterField;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.IRuleIndex;
import org.openl.rules.dt.type.BooleanAdaptorFactory;
import org.openl.rules.dt.type.BooleanTypeAdaptor;
import org.openl.rules.dt.type.CharRangeAdaptor;
import org.openl.rules.dt.type.DateRangeAdaptor;
import org.openl.rules.dt.type.DoubleRangeAdaptor;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.rules.dt.type.IntRangeAdaptor;
import org.openl.rules.dt.type.StringRangeAdaptor;
import org.openl.rules.helpers.CharRange;
import org.openl.rules.helpers.DateRange;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.helpers.StringRange;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public class DecisionTableOptimizedAlgorithm
implements IDecisionTableAlgorithm {
    private static final int MAX_INDEXED_ARRAY_SIZE = 1;
    private final ConditionToEvaluatorHolder[] evaluators;
    private final IRuleIndex indexRoot;
    private final IndexInfo info;
    private BindingDependencies dependencies;

    DecisionTableOptimizedAlgorithm(IConditionEvaluator[] evaluators, DecisionTable table, IndexInfo info) {
        this.evaluators = this.initEvaluators(evaluators, table, info);
        this.info = info;
        this.indexRoot = this.buildIndex(info);
        this.dependencies = new RulesBindingDependencies();
        table.updateDependency(this.dependencies);
    }

    static IRangeAdaptor<? extends Object, ? extends Comparable<?>> getRangeAdaptor(IOpenClass methodType, IOpenClass paramType) {
        if (DecisionTableOptimizedAlgorithm.isMethodTypeNumber(methodType)) {
            if (DecisionTableOptimizedAlgorithm.isParameterIntRange(paramType)) {
                return IntRangeAdaptor.getInstance();
            }
            if (DecisionTableOptimizedAlgorithm.isParameterDoubleRange(paramType)) {
                return DoubleRangeAdaptor.getInstance();
            }
        }
        if (DecisionTableOptimizedAlgorithm.isMethodTypeChar(methodType) && DecisionTableOptimizedAlgorithm.isParameterCharRange(paramType)) {
            return CharRangeAdaptor.getInstance();
        }
        if (DecisionTableOptimizedAlgorithm.isMethodTypeDate(methodType) && DecisionTableOptimizedAlgorithm.isParameterDateRange(paramType)) {
            return DateRangeAdaptor.getInstance();
        }
        if (DecisionTableOptimizedAlgorithm.isMethodTypeString(methodType) && DecisionTableOptimizedAlgorithm.isParameterStringRange(paramType)) {
            return StringRangeAdaptor.getInstance();
        }
        return null;
    }

    private static boolean isParameterDoubleRange(IOpenClass paramType) {
        return DoubleRange.class.equals((Object)paramType.getInstanceClass());
    }

    private static boolean isParameterIntRange(IOpenClass paramType) {
        return IntRange.class.equals((Object)paramType.getInstanceClass());
    }

    private static boolean isParameterCharRange(IOpenClass paramType) {
        return CharRange.class.equals((Object)paramType.getInstanceClass());
    }

    private static boolean isParameterStringRange(IOpenClass paramType) {
        return StringRange.class.equals((Object)paramType.getInstanceClass());
    }

    private static boolean isParameterDateRange(IOpenClass paramType) {
        return DateRange.class.equals((Object)paramType.getInstanceClass());
    }

    private static boolean isMethodTypeNumber(IOpenClass methodType) {
        return ClassUtils.isAssignable((Class)methodType.getInstanceClass(), Number.class);
    }

    private static boolean isMethodTypeChar(IOpenClass methodType) {
        return ClassUtils.isAssignable((Class)methodType.getInstanceClass(), Character.class);
    }

    private static boolean isMethodTypeString(IOpenClass methodType) {
        return ClassUtils.isAssignable((Class)methodType.getInstanceClass(), CharSequence.class);
    }

    private static boolean isMethodTypeDate(IOpenClass methodType) {
        return ClassUtils.isAssignable((Class)methodType.getInstanceClass(), Date.class);
    }

    public static IConditionEvaluator makeEvaluator(ICondition condition, IOpenClass methodType, IBindingContext bindingContext) throws SyntaxNodeException {
        if (condition.hasFormulas()) {
            return new DefaultConditionEvaluator();
        }
        IOpenCast params = condition.getParams();
        switch (((IParameterDeclaration[])params).length) {
            case 1: {
                IOpenClass paramType = params[0].getType();
                IOpenCast openCast = bindingContext.getCast(paramType, methodType);
                if (openCast != null) {
                    return condition.getNumberOfEmptyRules(0) > 1 ? new EqualsIndexedEvaluatorV2(openCast) : new EqualsIndexedEvaluator(openCast);
                }
                IAggregateInfo aggregateInfo = paramType.getAggregateInfo();
                if (aggregateInfo.isAggregate(paramType) && aggregateInfo.getComponentType(paramType).isAssignableFrom(methodType)) {
                    return condition.getNumberOfEmptyRules(0) > 1 ? new ContainsInArrayIndexedEvaluatorV2() : new ContainsInArrayIndexedEvaluator();
                }
                IRangeAdaptor<? extends Object, ? extends Comparable<?>> rangeAdaptor = DecisionTableOptimizedAlgorithm.getRangeAdaptor(methodType, paramType);
                if (rangeAdaptor != null) {
                    return new CombinedRangeIndexEvaluator(rangeAdaptor, 1);
                }
                if (!JavaOpenClass.BOOLEAN.equals((Object)methodType) && !JavaOpenClass.getOpenClass(Boolean.class).equals((Object)methodType)) break;
                return new DefaultConditionEvaluator();
            }
            case 2: {
                BooleanTypeAdaptor booleanTypeAdaptor;
                IOpenClass paramType0 = params[0].getType();
                IOpenClass paramType1 = params[1].getType();
                if (methodType == paramType0 && methodType == paramType1) {
                    Class clazz = methodType.getInstanceClass();
                    if (clazz != Short.TYPE && clazz != Byte.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE && clazz != Double.TYPE && clazz != Float.TYPE && !Comparable.class.isAssignableFrom(clazz)) {
                        String message = String.format("Type '%s' is not Comparable", methodType.getName());
                        throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)condition.getUserDefinedExpressionSource());
                    }
                    return new CombinedRangeIndexEvaluator(null, 2);
                }
                IAggregateInfo aggregateInfo = paramType1.getAggregateInfo();
                if (aggregateInfo.isAggregate(paramType1) && aggregateInfo.getComponentType(paramType1) == methodType && (booleanTypeAdaptor = BooleanAdaptorFactory.getAdaptor(paramType0)) != null) {
                    return new ContainsInOrNotInArrayIndexedEvaluator(booleanTypeAdaptor);
                }
                if (!JavaOpenClass.BOOLEAN.equals((Object)methodType) && !JavaOpenClass.getOpenClass(Boolean.class).equals((Object)methodType)) break;
                return new DefaultConditionEvaluator();
            }
        }
        ArrayList<String> names = new ArrayList<String>();
        for (IOpenCast parameterDeclaration : params) {
            String name = parameterDeclaration.getType().getName();
            names.add(name);
        }
        String parametersString = StringUtils.join(names, (String)",");
        String message = String.format("Can not make a Condition Evaluator for parameter %s and [%s]", methodType.getName(), parametersString);
        throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)condition.getUserDefinedExpressionSource());
    }

    private ConditionToEvaluatorHolder[] initEvaluators(IConditionEvaluator[] evaluators, DecisionTable table, IndexInfo info) {
        if (table.getNumberOfConditions() <= info.fromCondition || info.fromCondition > info.toCondition) {
            return new ConditionToEvaluatorHolder[0];
        }
        ArrayList<ConditionToEvaluatorHolder> evalToConds = new ArrayList<ConditionToEvaluatorHolder>(evaluators.length);
        for (int j = info.fromCondition; j <= info.toCondition; ++j) {
            int maxArrayLength;
            IConditionEvaluator eval = evaluators[j];
            ICondition condition = table.getCondition(j);
            if (eval instanceof AContainsInArrayIndexedEvaluator && (maxArrayLength = ((AContainsInArrayIndexedEvaluator)eval).getMaxArrayLength(condition, info.makeRuleIterator())) > 1) {
                eval = new ConditionEvaluatorDecoratorAsNotIndexed(eval);
            }
            ConditionToEvaluatorHolder pair = new ConditionToEvaluatorHolder(condition, eval, info);
            evalToConds.add(pair);
        }
        Collections.sort(evalToConds);
        return evalToConds.toArray(new ConditionToEvaluatorHolder[0]);
    }

    private IRuleIndex buildIndex(IndexInfo info) {
        if (this.evaluators.length == 0) {
            return null;
        }
        ConditionToEvaluatorHolder firstPair = this.evaluators[0];
        if (!firstPair.canIndex()) {
            return null;
        }
        IRuleIndex indexRoot = firstPair.makeIndex(info.makeRuleIterator());
        this.indexNodes(indexRoot, 1, info);
        return indexRoot;
    }

    private void indexNodes(IRuleIndex index, int condN, IndexInfo info) {
        if (index == null || condN >= this.evaluators.length) {
            return;
        }
        ConditionToEvaluatorHolder pair = this.evaluators[condN];
        if (!pair.canIndex()) {
            return;
        }
        for (DecisionTableRuleNode decisionTableRuleNode : index.nodes()) {
            this.indexNode(decisionTableRuleNode, condN, info);
        }
        this.indexNode(index.getEmptyOrFormulaNodes(), condN, info);
    }

    private void indexNode(DecisionTableRuleNode node, int condN, IndexInfo info) {
        ConditionToEvaluatorHolder pair = this.evaluators[condN];
        IRuleIndex nodeIndex = pair.makeIndex(node.getRulesIterator());
        node.setNextIndex(nodeIndex);
        this.indexNodes(nodeIndex, condN + 1, info);
    }

    private Object evaluateTestValue(ICondition condition, Object target, Object[] dtparams, IRuntimeEnv env) {
        return condition.getEvaluator().invoke(target, dtparams, env);
    }

    @Override
    public void removeParamValuesForIndexedConditions() {
        for (ConditionToEvaluatorHolder pair : this.evaluators) {
            if (pair.isIndexed()) {
                if (this.isDependecyOnConditionExists(pair.getCondition())) continue;
                pair.getCondition().clearParamValues();
                continue;
            }
            ConditionEvaluatorDecoratorAsNotIndexed decoratedEvaluator = new ConditionEvaluatorDecoratorAsNotIndexed(pair.getEvaluator());
            pair.setEvaluator(decoratedEvaluator);
            break;
        }
        this.dependencies = null;
    }

    private boolean isDependecyOnConditionExists(ICondition condition) {
        for (IOpenField field : this.dependencies.getFieldsMap().values()) {
            if (!(field instanceof ConditionOrActionParameterField) || ((ConditionOrActionParameterField)field).getConditionOrAction() != condition) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIntIterator checkedRules(Object target, Object[] params, IRuntimeEnv env) {
        int conditionNumber;
        IIntIterator iterator = null;
        if (this.indexRoot == null) {
            iterator = this.info.makeRuleIterator();
        } else {
            IRuleIndex index = this.indexRoot;
            DecisionTableRuleNode node = null;
            for (conditionNumber = 0; conditionNumber < this.evaluators.length; ++conditionNumber) {
                ICondition condition = this.evaluators[conditionNumber].getCondition();
                index = (IRuleIndex)Tracer.wrap((Object)this, (Object)index, (Object)condition);
                Object testValue = this.evaluateTestValue(condition, target, params, env);
                node = index.findNode(testValue, node);
                Tracer.put((Object)this, (String)"index", (Object)condition, (Object)node, (boolean)true);
                if (!node.hasIndex()) {
                    iterator = node.getRulesIterator();
                    ++conditionNumber;
                    break;
                }
                index = node.getNextIndex();
            }
        }
        while (conditionNumber < this.evaluators.length) {
            ConditionToEvaluatorHolder pair = this.evaluators[conditionNumber];
            ICondition condition = pair.getCondition();
            IConditionEvaluator evaluator = pair.getEvaluator();
            IIntSelector sel = evaluator.getSelector(condition, target, params, env);
            sel = (IIntSelector)Tracer.wrap((Object)this, (Object)sel, (Object)condition);
            iterator = iterator.select(sel);
            ++conditionNumber;
        }
        return iterator;
    }

    private static class ConditionToEvaluatorHolder
    implements Comparable<ConditionToEvaluatorHolder> {
        private final IndexInfo localInfo;
        private int uniqueKeysSize = -1;
        private final ICondition condition;
        private IConditionEvaluator evaluator;

        ConditionToEvaluatorHolder(ICondition condition, IConditionEvaluator evaluator, IndexInfo localInfo) {
            this.condition = condition;
            this.evaluator = evaluator;
            this.localInfo = localInfo;
        }

        public ICondition getCondition() {
            return this.condition;
        }

        public IConditionEvaluator getEvaluator() {
            return this.evaluator;
        }

        public void setEvaluator(IConditionEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public boolean canIndex() {
            return this.evaluator.isIndexed() && !this.condition.hasFormulas();
        }

        public IRuleIndex makeIndex(IIntIterator it) {
            return this.evaluator.makeIndex(this.condition, it);
        }

        public boolean isIndexed() {
            return this.evaluator.isIndexed();
        }

        @Override
        public int compareTo(ConditionToEvaluatorHolder o) {
            if (this.isEqualsIndex() && o.isEqualsIndex()) {
                return Integer.compare(this.getUniqueKeysSize(), o.getUniqueKeysSize());
            }
            return Integer.compare(this.evaluator.getPriority(), o.evaluator.getPriority());
        }

        private boolean isEqualsIndex() {
            return this.evaluator instanceof EqualsIndexedEvaluator || this.evaluator instanceof ContainsInArrayIndexedEvaluator;
        }

        private int getUniqueKeysSize() {
            if (this.uniqueKeysSize < 0) {
                this.uniqueKeysSize = this.evaluator.countUniqueKeys(this.condition, this.localInfo.makeRuleIterator());
            }
            return this.uniqueKeysSize;
        }
    }

    private static final class ConditionEvaluatorDecoratorAsNotIndexed
    implements IConditionEvaluator {
        IConditionEvaluator decorate;

        public ConditionEvaluatorDecoratorAsNotIndexed(IConditionEvaluator decorate) {
            if (decorate == null) {
                throw new IllegalArgumentException("decorate arg can't be null!");
            }
            this.decorate = decorate;
        }

        @Override
        public IRuleIndex makeIndex(ICondition condition, IIntIterator it) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isIndexed() {
            return false;
        }

        @Override
        public int countUniqueKeys(ICondition cond, IIntIterator it) {
            return 0;
        }

        @Override
        public IIntSelector getSelector(ICondition condition, Object target, Object[] dtparams, IRuntimeEnv env) {
            return this.decorate.getSelector(condition, target, dtparams, env);
        }

        public IDomain<? extends Object> getRuleParameterDomain(IBaseCondition condition) throws DomainCanNotBeDefined {
            return this.decorate.getRuleParameterDomain(condition);
        }

        @Override
        public String getOptimizedSourceCode() {
            return this.decorate.getOptimizedSourceCode();
        }

        @Override
        public void setOptimizedSourceCode(String code) {
            this.decorate.setOptimizedSourceCode(code);
        }

        @Override
        public IOpenSourceCodeModule getFormalSourceCode(IBaseCondition condition) {
            return this.decorate.getFormalSourceCode(condition);
        }

        public IDomain<? extends Object> getConditionParameterDomain(int paramIdx, IBaseCondition condition) throws DomainCanNotBeDefined {
            return this.decorate.getConditionParameterDomain(paramIdx, condition);
        }

        @Override
        public int getPriority() {
            return 100;
        }
    }
}

