/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import org.openl.domain.IIntSelector;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.vm.IRuntimeEnv;

public class RangeSelector
implements IIntSelector {
    private ICondition condition;
    private Object value;
    private Object target;
    private Object[] params;
    private IRuntimeEnv env;
    private IRangeAdaptor<Object, ? extends Comparable<Object>> adaptor;

    RangeSelector(ICondition condition, Object value, Object target, Object[] params, IRangeAdaptor<Object, ? extends Comparable<Object>> adaptor, IRuntimeEnv env) {
        this.condition = condition;
        this.adaptor = adaptor;
        this.value = adaptor != null ? this.adaptor.adaptValueType(value) : value;
        this.params = params;
        this.env = env;
        this.target = target;
    }

    public boolean select(int ruleN) {
        if (this.condition.isEmpty(ruleN)) {
            return true;
        }
        Object[] realParams = new Object[this.condition.getNumberOfParams()];
        this.condition.loadValues(realParams, 0, ruleN, this.target, this.params, this.env);
        Comparable<Object> vFrom = null;
        Comparable<Object> vTo = null;
        if (this.adaptor == null) {
            vFrom = (Comparable<Object>)realParams[0];
            vTo = (Comparable<Object>)realParams[1];
        } else {
            vFrom = this.adaptor.getMin(realParams[0]);
            vTo = realParams.length == 2 ? this.adaptor.getMax(realParams[1]) : this.adaptor.getMax(realParams[0]);
        }
        if (this.value == null) {
            return vFrom == null && vTo == null;
        }
        return !(vFrom != null && vFrom.compareTo(this.value) > 0 || vTo != null && ((Comparable)this.value).compareTo(vTo) >= 0);
    }
}

