/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.util.HashSet;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.engine.OpenLCellExpressionsCompiler;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.dt.element.IDecisionRow;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.IStorageBuilder;
import org.openl.rules.dt.storage.StorageFactory;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.SimpleLogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionCollector;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.vm.IRuntimeEnv;

public abstract class FunctionalRow
implements IDecisionRow {
    private static final String NO_PARAM = "P";
    private String name;
    private int row;
    protected CompositeMethod method;
    protected IOpenClass ruleExecutionType;
    private IParameterDeclaration[] params;
    protected IStorage<?>[] storage;
    private ILogicalTable decisionTable;
    private ILogicalTable paramsTable;
    private ILogicalTable codeTable;
    private ILogicalTable presentationTable;
    private DTScale.RowScale scale;
    private int noParamsIndex = 0;

    FunctionalRow(String name, int row, ILogicalTable decisionTable, DTScale.RowScale scale) {
        this.name = name;
        this.row = row;
        this.decisionTable = decisionTable;
        this.paramsTable = (ILogicalTable)decisionTable.getSubtable(2, row, 1, 1);
        this.codeTable = (ILogicalTable)decisionTable.getSubtable(1, row, 1, 1);
        this.presentationTable = (ILogicalTable)decisionTable.getSubtable(3, row, 1, 1);
        this.scale = scale;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CompositeMethod getMethod() {
        return this.method;
    }

    @Override
    public IParameterDeclaration[] getParams() {
        return this.params;
    }

    protected void setParams(IParameterDeclaration[] params) {
        this.params = params;
    }

    @Override
    public void clearParamValues() {
        this.storage = null;
    }

    @Override
    public IOpenSourceCodeModule getSourceCodeModule() {
        if (this.method != null) {
            return this.method.getMethodBodyBoundNode().getSyntaxNode().getModule();
        }
        return null;
    }

    @Override
    public int getNumberOfParams() {
        return this.params.length;
    }

    @Override
    public ILogicalTable getDecisionTable() {
        return this.decisionTable;
    }

    @Override
    public String[] getParamPresentation() {
        int length = this.paramsTable.getHeight();
        String[] result = new String[length];
        int fromHeight = 0;
        for (int i = 0; i < result.length; ++i) {
            int gridHeight = ((ILogicalTable)this.paramsTable.getRow(i)).getSource().getHeight();
            IGridTable singleParamGridTable = (IGridTable)this.presentationTable.getSource().getRows(fromHeight, fromHeight + gridHeight - 1);
            result[i] = singleParamGridTable.getCell(0, 0).getStringValue();
            fromHeight += gridHeight;
        }
        return result;
    }

    @Override
    public void prepare(IOpenClass methodType, IMethodSignature signature, OpenL openl, IBindingContext bindingContext, RuleRow ruleRow, IOpenClass ruleExecutionType, TableSyntaxNode tableSyntaxNode) throws Exception {
        this.ruleExecutionType = ruleExecutionType;
        this.method = this.generateMethod(signature, openl, bindingContext, methodType);
        OpenlToolAdaptor openlAdaptor = new OpenlToolAdaptor(openl, bindingContext, tableSyntaxNode);
        OpenMethodHeader header = new OpenMethodHeader(this.name, null, signature, null);
        openlAdaptor.setHeader((IOpenMethodHeader)header);
        this.prepareParamValues(this.method, openlAdaptor, ruleRow);
        if (bindingContext.isExecutionMode()) {
            this.decisionTable = null;
            this.paramsTable = null;
            this.codeTable = null;
            this.presentationTable = null;
        }
    }

    protected IParameterDeclaration[] getParams(IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, OpenL openl, IBindingContext bindingContext) throws Exception {
        if (this.params == null) {
            HashSet<String> paramNames = new HashSet<String>();
            int length = this.paramsTable.getHeight();
            this.params = new IParameterDeclaration[length];
            for (int i = 0; i < length; ++i) {
                ILogicalTable paramTable = (ILogicalTable)this.paramsTable.getRow(i);
                GridCellSourceCodeModule source = new GridCellSourceCodeModule(paramTable.getSource(), bindingContext);
                IParameterDeclaration parameterDeclaration = this.getParameterDeclaration(source, methodSource, signature, declaringClass, methodType, length == 1, openl, bindingContext);
                String paramName = parameterDeclaration.getName();
                if (paramNames.contains(paramName)) {
                    throw SyntaxNodeExceptionUtils.createError((String)("Duplicated parameter name: " + paramName), (IOpenSourceCodeModule)source);
                }
                paramNames.add(paramName);
                this.params[i] = parameterDeclaration;
            }
        }
        return this.params;
    }

    private void prepareParamValues(CompositeMethod method, OpenlToolAdaptor ota, RuleRow ruleRow) throws Exception {
        int i;
        int len = this.nValues();
        IParameterDeclaration[] paramDecl = this.getParams(method.getMethodBodyBoundNode().getSyntaxNode().getModule(), method.getSignature(), method.getDeclaringClass(), method.getType(), ota.getOpenl(), ota.getBindingContext());
        boolean[] paramIndexed = this.getParamIndexed(paramDecl);
        IStorageBuilder<?>[] builders = this.makeStorageBuilders(len, paramDecl);
        SyntaxNodeExceptionCollector syntaxNodeExceptionCollector = new SyntaxNodeExceptionCollector();
        int actualStorageSize = this.scale.getActualSize(len);
        for (i = 0; i < actualStorageSize; ++i) {
            int ruleN = this.scale.getLogicalIndex(i);
            this.loadParamsFromColumn(ota, ruleRow, paramDecl, paramIndexed, syntaxNodeExceptionCollector, ruleN, builders);
        }
        syntaxNodeExceptionCollector.throwIfAny("Error:");
        this.storage = new IStorage[builders.length];
        for (i = 0; i < builders.length; ++i) {
            this.storage[i] = builders[i].optimizeAndBuild();
        }
    }

    private IStorageBuilder<?>[] makeStorageBuilders(int len, IParameterDeclaration[] paramDecl) {
        int nparams = paramDecl.length;
        IStorageBuilder[] builders = new IStorageBuilder[nparams];
        for (int i = 0; i < builders.length; ++i) {
            builders[i] = StorageFactory.makeStorageBuilder(len, this.scale);
        }
        return builders;
    }

    private void loadParamsFromColumn(OpenlToolAdaptor ota, RuleRow ruleRow, IParameterDeclaration[] paramDecl, boolean[] paramIndexed, SyntaxNodeExceptionCollector syntaxNodeExceptionCollector, int ruleN, IStorageBuilder<?>[] builders) {
        IGridTable paramGridColumn = this.getValueCell(ruleN).getSource();
        int fromHeight = 0;
        boolean executionMode = ota.getBindingContext().isExecutionMode();
        String ruleName = null;
        if (!executionMode) {
            ruleName = ruleRow == null ? "R" + (ruleN + 1) : ruleRow.getRuleName(ruleN);
        }
        for (int j = 0; j < paramDecl.length; ++j) {
            if (paramDecl[j] == null) continue;
            int gridHeight = ((ILogicalTable)this.paramsTable.getRow(j)).getSource().getHeight();
            IGridTable singleParamGridTable = (IGridTable)paramGridColumn.getRows(fromHeight, fromHeight + gridHeight - 1);
            Object loadedValue = null;
            try {
                IOpenClass paramType = paramDecl[j].getType();
                loadedValue = RuleRowHelper.loadParam(LogicalTableHelper.logicalTable(singleParamGridTable), paramType, paramDecl[j].getName(), ruleName, ota, paramIndexed[j]);
            }
            catch (SyntaxNodeException e) {
                syntaxNodeExceptionCollector.addSyntaxNodeException(e);
            }
            builders[j].writeObject(loadedValue, ruleN);
            fromHeight += gridHeight;
        }
    }

    private boolean[] getParamIndexed(IParameterDeclaration[] paramDecl) {
        boolean[] paramIndexed = new boolean[paramDecl.length];
        for (int i = 0; i < paramIndexed.length; ++i) {
            paramIndexed[i] = paramDecl[i].getType().getAggregateInfo().isAggregate(paramDecl[i].getType());
        }
        return paramIndexed;
    }

    Object[] mergeParams(Object target, Object[] dtParams, IRuntimeEnv env, int ruleN) {
        if (dtParams == null) {
            dtParams = new Object[]{};
        }
        Object[] newParams = new Object[dtParams.length + this.getNumberOfParams()];
        System.arraycopy(dtParams, 0, newParams, 0, dtParams.length);
        this.loadValues(newParams, dtParams.length, ruleN, target, dtParams, env);
        return newParams;
    }

    @Override
    public ILogicalTable getValueCell(int column) {
        return (ILogicalTable)this.decisionTable.getSubtable(column + 4, this.row, 1, 1);
    }

    public ILogicalTable getCodeTable() {
        return this.codeTable;
    }

    public ILogicalTable getParamsTable() {
        return this.paramsTable;
    }

    public int nValues() {
        return this.decisionTable.getWidth() - 4;
    }

    private String makeParamName() {
        ++this.noParamsIndex;
        return (NO_PARAM + this.noParamsIndex).intern();
    }

    private CompositeMethod generateMethod(IMethodSignature signature, OpenL openl, IBindingContext bindingContext, IOpenClass methodType) throws Exception {
        IOpenSourceCodeModule source = this.getExpressionSource(bindingContext, openl, null, signature, methodType);
        IParameterDeclaration[] methodParams = this.getParams(source, signature, null, methodType, openl, bindingContext);
        MethodSignature newSignature = ((MethodSignature)signature).merge(methodParams);
        OpenMethodHeader methodHeader = new OpenMethodHeader(null, methodType, (IMethodSignature)newSignature, null);
        return OpenLCellExpressionsCompiler.makeMethod(openl, source, (IOpenMethodHeader)methodHeader, bindingContext);
    }

    protected IOpenSourceCodeModule getExpressionSource(IBindingContext bindingContext, OpenL openl, IOpenClass declaringClass, IMethodSignature signature, IOpenClass methodType) throws Exception {
        return new GridCellSourceCodeModule(this.codeTable.getSource(), bindingContext);
    }

    private IParameterDeclaration getParameterDeclaration(IOpenSourceCodeModule paramSource, IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, boolean allowEmpty, OpenL openl, IBindingContext bindingContext) throws OpenLCompilationException {
        IdentifierNode[] nodes = Tokenizer.tokenize((IOpenSourceCodeModule)paramSource, (String)" \n\r");
        if (nodes.length == 0) {
            if (allowEmpty) {
                try {
                    OpenMethodHeader methodHeader = new OpenMethodHeader(null, methodType, signature, declaringClass);
                    CompositeMethod method = OpenLCellExpressionsCompiler.makeMethod(openl, methodSource, (IOpenMethodHeader)methodHeader, bindingContext);
                    IOpenClass type = method.getBodyType();
                    if (type instanceof NullOpenClass) {
                        String message = "Cannot recognize type of local parameter for expression";
                        throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)methodSource);
                    }
                    String paramName = this.makeParamName();
                    return new ParameterDeclaration(type, paramName);
                }
                catch (Exception | LinkageError ex) {
                    throw SyntaxNodeExceptionUtils.createError((String)"Cannot compile expression", (Throwable)ex, null, (IOpenSourceCodeModule)methodSource);
                }
            }
            String errMsg = "Parameter cell format: <type> <name>";
            throw SyntaxNodeExceptionUtils.createError((String)errMsg, null, null, (IOpenSourceCodeModule)paramSource);
        }
        if (nodes.length > 2) {
            String errMsg = "Parameter cell format: <type> <name>";
            throw SyntaxNodeExceptionUtils.createError((String)errMsg, null, null, (IOpenSourceCodeModule)paramSource);
        }
        String typeCode = nodes[0].getText();
        IOpenClass type = RuleRowHelper.getType(typeCode, (ISyntaxNode)nodes[0], bindingContext);
        if (nodes.length == 1) {
            String paramName = this.makeParamName();
            return new ParameterDeclaration(type, paramName);
        }
        return new ParameterDeclaration(type, nodes[1].getIdentifier());
    }

    @Override
    public Object getParamValue(int paramIndex, int ruleN) {
        return this.storage[paramIndex].getValue(ruleN);
    }

    @Override
    public boolean isEmpty(int ruleN) {
        for (IStorage<?> aStorage : this.storage) {
            if (aStorage.isSpace(ruleN)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasFormula(int ruleN) {
        if (this.storage != null) {
            for (IStorage<?> aStorage : this.storage) {
                if (!aStorage.isFormula(ruleN)) continue;
                return true;
            }
        } else {
            IGridTable paramGridColumn = this.getValueCell(ruleN).getSource();
            return RuleRowHelper.isFormula(new SimpleLogicalTable(paramGridColumn));
        }
        return false;
    }

    @Override
    public int getNumberOfRules() {
        return this.storage == null || this.storage.length == 0 ? 0 : this.storage[0].size();
    }

    @Override
    public void loadValues(Object[] dest, int offset, int ruleN, Object target, Object[] tableParams, IRuntimeEnv env) {
        for (int i = 0; i < dest.length - offset; ++i) {
            Object value = this.storage[i].getValue(ruleN);
            if (value instanceof IOpenMethod) {
                value = ((IOpenMethod)value).invoke(target, tableParams, env);
            }
            if (value instanceof ArrayHolder) {
                value = ((ArrayHolder)value).invoke(target, tableParams, env);
            }
            dest[i + offset] = value;
        }
    }

    @Override
    public boolean hasFormulas() {
        if (this.storage != null) {
            for (IStorage<?> aStorage : this.storage) {
                if (aStorage.getInfo().getNumberOfFormulas() <= 0) continue;
                return true;
            }
        } else {
            int len = this.nValues();
            int actualStorageSize = this.scale.getActualSize(len);
            for (int i = 0; i < actualStorageSize; ++i) {
                int ruleN = this.scale.getLogicalIndex(i);
                if (!this.hasFormula(ruleN)) continue;
                return true;
            }
        }
        return false;
    }

    public Object getStorageValue(int paramNum, int ruleNum) {
        if (this.storage == null) {
            return null;
        }
        return this.storage[paramNum].getValue(ruleNum);
    }

    @Override
    public boolean isEqual(int rule1, int rule2) {
        int n = this.getNumberOfParams();
        for (int i = 0; i < n; ++i) {
            Object p2;
            Object p1 = this.getParamValue(i, rule1);
            if (p1 == (p2 = this.getParamValue(i, rule2)) || p1 == null || p1.equals(p2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name + " : " + this.codeTable;
    }
}

