/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.index;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.EqualsIndexDecisionTableRuleNode;
import org.openl.rules.dt.IDecisionTableRuleNodeV2;
import org.openl.rules.dt.algorithm.evaluator.FloatTypeComparator;
import org.openl.rules.dt.index.IRuleIndex;
import org.openl.rules.helpers.NumberUtils;

public class EqualsIndexV2
implements IRuleIndex {
    private static final int[] EMPTY_ARRAY = new int[0];
    private final DecisionTableRuleNode emptyNodeStub = new DecisionTableRuleNodeBuilder().makeNode();
    private Map<Object, int[]> index;
    private int[] emptyRules;
    private DecisionTableRuleNode nextNode;
    private int rulesTotalSize;

    public EqualsIndexV2(DecisionTableRuleNode nextNode, Map<Object, int[]> index, int[] emptyRules) {
        this.index = Collections.unmodifiableMap(index);
        this.emptyRules = emptyRules;
        this.nextNode = nextNode;
        this.rulesTotalSize = nextNode.getRules().length;
    }

    private int[] findIndex(Object value) {
        int[] result = null;
        if (value != null) {
            result = this.index.get(value);
        }
        return result == null ? EMPTY_ARRAY : result;
    }

    @Override
    public DecisionTableRuleNode findNode(Object value, DecisionTableRuleNode prevResult) {
        return new EqualsIndexDecisionTableRuleNode(this.findRules(value, prevResult), this.nextNode.getNextIndex());
    }

    private int[] findRules(Object value, DecisionTableRuleNode prevResult) {
        if (!(prevResult instanceof IDecisionTableRuleNodeV2)) {
            int[] rules = this.findIndex(value);
            rules = EqualsIndexV2.combineSortedArrays(rules, this.emptyRules);
            return rules;
        }
        return this.getResultAndIntersect(value, (IDecisionTableRuleNodeV2)((Object)prevResult));
    }

    private int[] getResultAndIntersect(Object value, IDecisionTableRuleNodeV2 prevResult) {
        int[] prevRes = prevResult.getRules();
        if (prevRes.length == 0) {
            return EMPTY_ARRAY;
        }
        int[] rules = this.findIndex(value);
        rules = EqualsIndexV2.combineSortedArrays(rules, this.emptyRules);
        return EqualsIndexV2.intersectionSortedArrays(rules, prevRes);
    }

    @Override
    public Iterable<? extends DecisionTableRuleNode> nodes() {
        return Collections.singletonList(this.nextNode);
    }

    @Override
    public int[] collectRules() {
        int[] result = new int[this.rulesTotalSize];
        int k = 0;
        for (int[] arr : this.index.values()) {
            for (int ruleN : arr) {
                result[k++] = ruleN;
            }
        }
        for (Object ruleN : (Object)this.emptyRules) {
            result[k++] = (int)ruleN;
        }
        Arrays.sort(result);
        return result;
    }

    @Override
    public DecisionTableRuleNode getEmptyOrFormulaNodes() {
        return this.emptyNodeStub;
    }

    private static int[] combineSortedArrays(int[] a, int[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        int[] result = new int[a.length + b.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < a.length && j < b.length) {
            result[k++] = a[i] < b[j] ? a[i++] : b[j++];
        }
        while (i < a.length) {
            result[k++] = a[i++];
        }
        while (j < b.length) {
            result[k++] = b[j++];
        }
        return result;
    }

    private static int[] intersectionSortedArrays(int[] a, int[] b) {
        int[] result = new int[Math.min(a.length, b.length)];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < a.length && j < b.length) {
            if (a[i] < b[j]) {
                ++i;
                continue;
            }
            if (b[j] < a[i]) {
                ++j;
                continue;
            }
            result[k++] = b[j++];
            ++i;
        }
        if (result.length != k) {
            int[] res = new int[k];
            System.arraycopy(result, 0, res, 0, k);
            return res;
        }
        return result;
    }

    public static class Builder {
        private DecisionTableRuleNodeBuilder nextNodeBuilder = new DecisionTableRuleNodeBuilder();
        private DecisionTableRuleNodeBuilder emptyBuilder = new DecisionTableRuleNodeBuilder();
        private Map<Object, DecisionTableRuleNodeBuilder> map = null;
        private Map<Object, int[]> result = null;
        private boolean comparatorBasedMap = false;

        public void addRule(int ruleN) {
            this.nextNodeBuilder.addRule(ruleN);
        }

        public void putEmptyRule(int ruleN) {
            this.emptyBuilder.addRule(ruleN);
        }

        public void putValueToRule(Object value, int ruleN) {
            if (this.comparatorBasedMap && !(value instanceof Comparable)) {
                throw new IllegalArgumentException("Invalid state! Index based on comparable interface!");
            }
            if (this.map == null) {
                if (NumberUtils.isFloatPointNumber(value)) {
                    if (value instanceof BigDecimal) {
                        this.map = new TreeMap<Object, DecisionTableRuleNodeBuilder>();
                        this.result = new TreeMap<Object, int[]>();
                    } else {
                        this.map = new TreeMap<Object, DecisionTableRuleNodeBuilder>(FloatTypeComparator.getInstance());
                        this.result = new TreeMap<Object, int[]>(FloatTypeComparator.getInstance());
                    }
                    this.comparatorBasedMap = true;
                } else {
                    this.map = new HashMap<Object, DecisionTableRuleNodeBuilder>();
                    this.result = new HashMap<Object, int[]>();
                }
            }
            DecisionTableRuleNodeBuilder builder = this.map.computeIfAbsent(value, e -> new DecisionTableRuleNodeBuilder());
            builder.addRule(ruleN);
        }

        public EqualsIndexV2 build() {
            if (this.map == null) {
                this.result = Collections.emptyMap();
            } else {
                for (Map.Entry<Object, DecisionTableRuleNodeBuilder> element : this.map.entrySet()) {
                    this.result.put(element.getKey(), element.getValue().makeRulesAry());
                }
            }
            return new EqualsIndexV2(this.nextNodeBuilder.makeNode(), this.result, this.emptyBuilder.makeRulesAry());
        }
    }
}

