/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.IDecisionTableRuleNodeV2;
import org.openl.rules.dt.RangeIndexDecisionTableRuleNode;
import org.openl.rules.dt.algorithm.evaluator.ARangeIndexEvaluator;
import org.openl.rules.dt.index.IRuleIndex;
import org.openl.rules.dt.type.IRangeAdaptor;

public class RangeAscIndex
implements IRuleIndex {
    protected final List<ARangeIndexEvaluator.IndexNode> index;
    private final DecisionTableRuleNode emptyNodeStub = new DecisionTableRuleNodeBuilder().makeNode();
    private final DecisionTableRuleNode nextNode;
    private final IRangeAdaptor<ARangeIndexEvaluator.IndexNode, ?> adaptor;
    private final Set<Integer> emptyRules;

    public RangeAscIndex(DecisionTableRuleNode nextNode, List<ARangeIndexEvaluator.IndexNode> index, IRangeAdaptor<ARangeIndexEvaluator.IndexNode, ?> adaptor, int[] emptyRules) {
        this.index = Collections.unmodifiableList(index);
        this.adaptor = adaptor;
        this.nextNode = nextNode;
        HashSet<Integer> emptyRuleSet = new HashSet<Integer>();
        for (int i : emptyRules) {
            emptyRuleSet.add(i);
        }
        this.emptyRules = Collections.unmodifiableSet(emptyRuleSet);
    }

    private Pair<Integer, Integer> findIndexRange(Object value) {
        if (value == null || this.index.isEmpty()) {
            return null;
        }
        value = this.adaptor.adaptValueType(value);
        int idx = Collections.binarySearch(this.index, (ARangeIndexEvaluator.IndexNode)value);
        return this.retrieveIndexRange(idx);
    }

    protected Pair<Integer, Integer> retrieveIndexRange(int idx) {
        if (idx >= 0) {
            return Pair.of((Object)0, (Object)(idx + 1));
        }
        int insertionPoint = -(idx + 1);
        if (insertionPoint <= this.index.size() && insertionPoint > 0) {
            return Pair.of((Object)0, (Object)insertionPoint);
        }
        return null;
    }

    @Override
    public DecisionTableRuleNode findNode(Object value, DecisionTableRuleNode prevResult) {
        return new RangeIndexDecisionTableRuleNode(this.findRules(value, prevResult), this.nextNode.getNextIndex());
    }

    Set<Integer> findRules(Object value, DecisionTableRuleNode prevResult) {
        if (!(prevResult instanceof IDecisionTableRuleNodeV2)) {
            Pair<Integer, Integer> range = this.findIndexRange(value);
            HashSet<Integer> result = new HashSet<Integer>(this.emptyRules);
            if (range != null) {
                for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                    result.addAll(this.index.get(i).getRules());
                }
            }
            return result;
        }
        return this.getResultAndIntersect(value, (IDecisionTableRuleNodeV2)((Object)prevResult));
    }

    private Set<Integer> getResultAndIntersect(Object value, IDecisionTableRuleNodeV2 prevResult) {
        Set<Integer> prevRes = prevResult.getRuleSet();
        if (prevRes.isEmpty()) {
            return prevRes;
        }
        Pair<Integer, Integer> range = this.findIndexRange(value);
        HashSet<Integer> result = new HashSet<Integer>();
        this.retainAll(this.emptyRules, prevRes, result);
        if (range != null) {
            for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                this.retainAll(this.index.get(i).getRules(), prevRes, result);
            }
        }
        return result;
    }

    private void retainAll(Set<Integer> a, Set<Integer> b, Set<Integer> result) {
        if (a.size() > b.size()) {
            Set<Integer> tmp = a;
            a = b;
            b = tmp;
        }
        for (Integer ruleN : a) {
            if (!b.contains(ruleN)) continue;
            result.add(ruleN);
        }
    }

    @Override
    public Iterable<? extends DecisionTableRuleNode> nodes() {
        return Collections.singletonList(this.nextNode);
    }

    @Override
    public DecisionTableRuleNode getEmptyOrFormulaNodes() {
        return this.emptyNodeStub;
    }

    @Override
    public int[] collectRules() {
        ArrayList<Integer> rules = new ArrayList<Integer>(this.emptyRules);
        for (ARangeIndexEvaluator.IndexNode indexNode : this.index) {
            rules.addAll(indexNode.getRules());
        }
        int[] result = new int[rules.size()];
        int i = 0;
        for (Integer ruleN : rules) {
            result[i++] = ruleN;
        }
        return result;
    }
}

