/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.IStorageBuilder;
import org.openl.rules.dt.storage.ScaledStorage;
import org.openl.rules.dt.storage.StorageBuilder;

public class ScaleStorageBuilder
implements IStorageBuilder {
    private DTScale.RowScale scale;
    private StorageBuilder sb;

    ScaleStorageBuilder(DTScale.RowScale scale, StorageBuilder sb) {
        this.scale = scale;
        this.sb = sb;
    }

    @Override
    public void writeObject(Object loadedValue, int index) {
        this.sb.writeObject(loadedValue, this.getStorageIndex(index));
    }

    private int getStorageIndex(int index) {
        return this.scale.getActualIndex(index);
    }

    @Override
    public int size() {
        return this.sb.size() * this.scale.getMultiplier();
    }

    public IStorage optimizeAndBuild() {
        IStorage storage = this.sb.optimizeAndBuild();
        return new ScaledStorage(this.scale, storage, this.sb.getInfo());
    }
}

