/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type;

import org.openl.binding.impl.NumericComparableString;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.rules.helpers.ARangeParser;
import org.openl.rules.helpers.StringRange;
import org.openl.rules.helpers.StringRangeParser;

public final class StringRangeAdaptor
implements IRangeAdaptor<StringRange, NumericComparableString> {
    private static final StringRangeAdaptor INSTANCE = new StringRangeAdaptor();

    private StringRangeAdaptor() {
    }

    public static IRangeAdaptor<StringRange, NumericComparableString> getInstance() {
        return INSTANCE;
    }

    @Override
    public NumericComparableString getMax(StringRange range) {
        if (range == null) {
            return null;
        }
        NumericComparableString max = range.getUpperBound();
        if (!StringRangeParser.MAX_VALUE.equals(max) && range.getUpperBoundType() == ARangeParser.ParseStruct.BoundType.INCLUDING) {
            max = NumericComparableString.valueOf((String)(max.getValue() + " "));
        }
        return max;
    }

    @Override
    public NumericComparableString getMin(StringRange range) {
        if (range == null) {
            return null;
        }
        NumericComparableString min = range.getLowerBound();
        if (!StringRangeParser.MAX_VALUE.equals(min) && range.getLowerBoundType() == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            min = NumericComparableString.valueOf((String)(min.getValue() + " "));
        }
        return min;
    }

    @Override
    public NumericComparableString adaptValueType(Object value) {
        return value == null ? null : NumericComparableString.valueOf((String)((CharSequence)value).toString());
    }

    @Override
    public boolean useOriginalSource() {
        return false;
    }
}

