/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import org.openl.rules.helpers.ARangeParser;
import org.openl.rules.helpers.CharRangeParser;
import org.openl.rules.helpers.IntRange;

public class CharRange
extends IntRange {
    public CharRange(char min, char max) {
        super(min, max);
    }

    public CharRange(char c) {
        super(c);
    }

    public CharRange(String range) {
        super(0L, 0L);
        if (range == null) {
            throw new NullPointerException("CharRange value can not be null");
        }
        ARangeParser.ParseStruct parsed = CharRangeParser.getInstance().parse(range);
        this.min = ((Character)parsed.min).charValue();
        if (parsed.leftBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            ++this.min;
        }
        this.max = ((Character)parsed.max).charValue();
        if (parsed.rightBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            --this.max;
        }
        if (this.min > this.max) {
            throw new RuntimeException(parsed.max + " must be more or equal than " + parsed.min);
        }
    }

    @Override
    public String toString() {
        return this.printChar(this.min) + "-" + this.printChar(this.max);
    }

    private String printChar(long ch) {
        return this.isPrintable(ch) ? String.valueOf((char)ch) : "'u" + Integer.toHexString((char)ch) + "'";
    }

    private boolean isPrintable(long ch) {
        if (Character.isWhitespace((char)ch) || Character.isISOControl((char)ch)) {
            return false;
        }
        if (ch < 255L) {
            return true;
        }
        return Character.isUnicodeIdentifierPart((char)ch);
    }

    public static CharRange autocast(char x, CharRange y) {
        return new CharRange(x);
    }
}

