/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.regex.Pattern;
import org.openl.rules.helpers.ARangeParser;

public final class CharRangeParser
extends ARangeParser<Character> {
    private final ARangeParser.RangeParser[] parsers;
    private final Pattern[] patterns;
    private static final String MIN_MAX_PATTERN = "\\s*(\\S)\\s*([-;\u2026]|\\.{3}|\\.{2})\\s*(\\S)\\s*";
    private static final String BRACKETS_PATTERN = "\\s*([\\[(])\\s*(\\S)\\s*(?:[-;\u2026]|\\.{3}|\\.{2})\\s*(\\S)\\s*([])])\\s*";
    private static final String VERBAL_PATTERN = "\\s*(\\S)\\s*(\\+|and more|or less)\\s*";
    private static final String MORE_LESS_PATTERN = "\\s*(<|>|>=|<=|less than|more than)\\s*(\\S)\\s*";
    private static final String RANGE_MORE_LESS_PATTERN = "\\s*(<=?|>=?)\\s*(\\S)\\s*(<=?|>=?)\\s*(\\S)\\s*";
    private static final String SIMPLE_PATTERN = "\\s*(\\S)\\s*";

    private CharRangeParser() {
        CharacterRangeBoundAdapter adapter = new CharacterRangeBoundAdapter();
        this.patterns = new Pattern[]{Pattern.compile(BRACKETS_PATTERN), Pattern.compile(MIN_MAX_PATTERN), Pattern.compile(VERBAL_PATTERN), Pattern.compile(MORE_LESS_PATTERN), Pattern.compile(RANGE_MORE_LESS_PATTERN), Pattern.compile(SIMPLE_PATTERN)};
        this.parsers = new ARangeParser.RangeParser[]{new ARangeParser.BracketsParser<Character>(this.patterns[0], adapter), new ARangeParser.MinMaxParser<Character>(this.patterns[1], adapter), new ARangeParser.VerbalParser<Character>(this.patterns[2], adapter), new ARangeParser.MoreLessParser<Character>(this.patterns[3], adapter), new ARangeParser.RangeWithMoreLessParser<Character>(this.patterns[4], adapter), new ARangeParser.SimpleParser<Character>(this.patterns[5], adapter)};
    }

    public static CharRangeParser getInstance() {
        return CharRangeParserHolder.INSTANCE;
    }

    @Override
    ARangeParser.RangeParser[] getRangeParsers() {
        return this.parsers;
    }

    private static final class CharacterRangeBoundAdapter
    implements ARangeParser.RangeBoundAdapter<Character> {
        private CharacterRangeBoundAdapter() {
        }

        @Override
        public Character adaptValue(String s) {
            return Character.valueOf(s.charAt(0));
        }

        @Override
        public Character getMinLeftBound() {
            return Character.valueOf('\u0000');
        }

        @Override
        public Character getMaxRightBound() {
            return Character.valueOf('\uffff');
        }
    }

    private static class CharRangeParserHolder {
        private static final CharRangeParser INSTANCE = new CharRangeParser();

        private CharRangeParserHolder() {
        }
    }
}

