/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import org.openl.conf.ConfigurableResourceContext;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IUserContext;
import org.openl.rules.lang.xls.BaseParser;
import org.openl.rules.lang.xls.IncludeSearcher;
import org.openl.rules.lang.xls.XlsLoader;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.code.IParsedCode;

public class XlsParser
extends BaseParser {
    private IUserContext userContext;

    public XlsParser(IUserContext userContext) {
        this.userContext = userContext;
    }

    @Override
    public IParsedCode parseAsModule(IOpenSourceCodeModule source) {
        String[] roots = new String[]{this.userContext.getUserHome()};
        ClassLoader classLoader = this.userContext.getUserClassLoader();
        IncludeSearcher includeSeeker = new IncludeSearcher((IConfigurableResourceContext)new ConfigurableResourceContext(classLoader, roots));
        XlsLoader xlsLoader = new XlsLoader(includeSeeker);
        return xlsLoader.parse(source);
    }

    @Override
    protected IParsedCode getNotSupportedCode(IOpenSourceCodeModule source, String sourceType) {
        String message = String.format(".xls files can not be parsed as %s", sourceType);
        return this.getInvalidCode(message, source);
    }
}

