/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.meta.IMetaInfo;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ICell;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.MethodDelegator;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.util.StringUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;
import org.openl.vm.IRuntimeEnv;

public abstract class AMethodBasedNode
extends ATableBoundNode
implements IMemberBoundNode {
    private OpenL openl;
    private IOpenMethodHeader header;
    private ExecutableRulesMethod method;
    private ModuleOpenClass module;

    public AMethodBasedNode(TableSyntaxNode methodNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(methodNode);
        this.header = header;
        this.openl = openl;
        this.module = module;
    }

    public OpenL getOpenl() {
        return this.openl;
    }

    public IOpenMethodHeader getHeader() {
        return this.header;
    }

    public ExecutableRulesMethod getMethod() {
        return this.method;
    }

    public ModuleOpenClass getModule() {
        return this.module;
    }

    protected Object evaluateRuntime(IRuntimeEnv env) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public IOpenClass getType() {
        return this.header.getType();
    }

    public void addTo(ModuleOpenClass openClass) {
        this.method = this.createMethodShell();
        openClass.addMethod((IOpenMethod)this.method);
        this.getTableSyntaxNode().setMember((IOpenMember)this.method);
        if (this.hasServiceName()) {
            openClass.addMethod(this.getServiceMethod(this.method));
        }
    }

    protected boolean hasServiceName() {
        return StringUtils.isNotBlank((CharSequence)this.getTableSyntaxNode().getTableProperties().getId());
    }

    protected IOpenMethod getServiceMethod(ExecutableRulesMethod originalMethod) {
        String serviceMethodName = this.getTableSyntaxNode().getTableProperties().getId();
        return new AMethodBasedNodeServiceMethod(originalMethod, serviceMethodName);
    }

    protected abstract ExecutableRulesMethod createMethodShell();

    public void removeDebugInformation(IBindingContext cxt) throws Exception {
        if (cxt.isExecutionMode()) {
            this.getMethod().setBoundNode(null);
            this.getMethod().getMethodProperties().setModulePropertiesTableSyntaxNode(null);
            this.getMethod().getMethodProperties().setCategoryPropertiesTableSyntaxNode(null);
            this.getMethod().getMethodProperties().setPropertiesSection(null);
        }
    }

    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        if (!bindingContext.isExecutionMode() && this.header instanceof OpenMethodHeader) {
            ILocation[] paramTypeLocations;
            OpenMethodHeader tableHeader = (OpenMethodHeader)this.header;
            int startPosition = this.getSignatureStartIndex();
            IOpenClass type = tableHeader.getType();
            IMetaInfo metaInfo = type.getMetaInfo();
            while (metaInfo == null && type.isArray()) {
                type = type.getComponentClass();
                metaInfo = type.getMetaInfo();
            }
            GridCellSourceCodeModule src = new GridCellSourceCodeModule(this.getTableSyntaxNode().getGridTable(), bindingContext);
            SubTextSourceCodeModule headerSyntaxNode = new SubTextSourceCodeModule((IOpenSourceCodeModule)src, startPosition, src.getCode().length());
            ILocation typeLocation = tableHeader.getTypeLocation();
            if (metaInfo != null && typeLocation != null && type.getInstanceClass() == null) {
                this.addTypeError(bindingContext, type, typeLocation, (IOpenSourceCodeModule)headerSyntaxNode);
            }
            if ((paramTypeLocations = tableHeader.getParamTypeLocations()) != null) {
                for (int i = 0; i < this.header.getSignature().getNumberOfParameters(); ++i) {
                    IOpenClass parameterType = this.header.getSignature().getParameterType(i);
                    metaInfo = parameterType.getMetaInfo();
                    while (metaInfo == null && parameterType.isArray()) {
                        parameterType = parameterType.getComponentClass();
                        metaInfo = parameterType.getMetaInfo();
                    }
                    if (metaInfo == null) continue;
                    ILocation sourceLocation = paramTypeLocations[i];
                    if (parameterType.getInstanceClass() != null) continue;
                    this.addTypeError(bindingContext, parameterType, sourceLocation, (IOpenSourceCodeModule)headerSyntaxNode);
                }
            }
        }
    }

    protected void addTypeError(IBindingContext bindingContext, IOpenClass type, ILocation location, IOpenSourceCodeModule syntaxNode) {
        String message = String.format("Type '%s' was defined with errors", type.getName());
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, null, (ILocation)location, (IOpenSourceCodeModule)syntaxNode);
        this.getTableSyntaxNode().addError(error);
        bindingContext.addError(error);
    }

    public int getSignatureStartIndex() {
        ICell cell = this.getTableSyntaxNode().getGridTable().getCell(0, 0);
        TextInfo tableHeaderText = new TextInfo(cell.getStringValue());
        return this.getTableSyntaxNode().getHeader().getHeaderToken().getLocation().getEnd().getAbsolutePosition(tableHeaderText);
    }

    private static final class AMethodBasedNodeServiceMethod
    extends MethodDelegator
    implements IMemberMetaInfo {
        private String serviceMethodName;

        public AMethodBasedNodeServiceMethod(ExecutableRulesMethod originalMethod, String serviceMethodName) {
            super((IMethodCaller)originalMethod);
            this.serviceMethodName = serviceMethodName;
        }

        public String getName() {
            return this.serviceMethodName;
        }

        public String getDisplayName(int mode) {
            return this.serviceMethodName;
        }

        public BindingDependencies getDependencies() {
            return ((ExecutableRulesMethod)this.methodCaller).getDependencies();
        }

        public ISyntaxNode getSyntaxNode() {
            return ((ExecutableRulesMethod)this.methodCaller).getSyntaxNode();
        }

        public Map<String, Object> getProperties() {
            return ((ExecutableRulesMethod)this.methodCaller).getProperties();
        }

        public String getSourceUrl() {
            return ((ExecutableRulesMethod)this.methodCaller).getSourceUrl();
        }
    }
}

