/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import com.rits.cloning.Cloner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.binding.exception.DuplicatedFieldException;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.dependency.CompiledDependency;
import org.openl.engine.ExtendableModuleOpenClass;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.binding.DuplicatedTableException;
import org.openl.rules.lang.xls.binding.XlsDefinitions;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.wrapper.IOpenMethodWrapper;
import org.openl.rules.lang.xls.binding.wrapper.WrapperLogic;
import org.openl.rules.lang.xls.prebind.ILazyMember;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.OpenLArgumentsCloner;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.types.IUriMember;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.types.UriMemberHelper;
import org.openl.rules.types.ValidationMessages;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.rules.types.impl.OverloadedMethodsDispatcherTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IModuleInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AMethod;
import org.openl.util.Log;
import org.openl.util.StringUtils;

public class XlsModuleOpenClass
extends ModuleOpenClass
implements ExtendableModuleOpenClass {
    private IDataBase dataBase = null;
    private boolean useDescisionTableDispatcher;
    private boolean dispatchingValidationEnabled;
    private Collection<String> imports = new HashSet<String>();
    private ClassLoader classLoader;
    private RulesModuleBindingContext rulesModuleBindingContext;
    private XlsDefinitions xlsDefinitions = new XlsDefinitions();
    private Map<String, IOpenField> constantFields = new HashMap<String, IOpenField>();
    private volatile OpenLArgumentsCloner cloner = null;

    public RulesModuleBindingContext getRulesModuleBindingContext() {
        return this.rulesModuleBindingContext;
    }

    public void setRulesModuleBindingContext(RulesModuleBindingContext rulesModuleBindingContext) {
        this.rulesModuleBindingContext = rulesModuleBindingContext;
    }

    public XlsModuleOpenClass(String name, XlsMetaInfo metaInfo, OpenL openl, IDataBase dbase, Set<CompiledDependency> usingModules, ClassLoader classLoader, boolean useDescisionTableDispatcher, boolean dispatchingValidationEnabled) {
        super(name, openl);
        this.dataBase = dbase;
        this.metaInfo = metaInfo;
        this.useDescisionTableDispatcher = useDescisionTableDispatcher;
        this.dispatchingValidationEnabled = dispatchingValidationEnabled;
        this.classLoader = classLoader;
        if (usingModules != null) {
            this.setDependencies(usingModules);
            this.initDependencies();
        }
        this.initImports(metaInfo.getXlsModuleNode());
    }

    public boolean isUseDescisionTableDispatcher() {
        return this.useDescisionTableDispatcher;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void initImports(XlsModuleSyntaxNode xlsModuleSyntaxNode) {
        this.imports.addAll(xlsModuleSyntaxNode.getImports());
    }

    public IDataBase getDataBase() {
        return this.dataBase;
    }

    protected void addXlsDefinitions(CompiledDependency dependency) {
        IOpenClass openClass = dependency.getCompiledOpenClass().getOpenClassWithErrors();
        if (openClass instanceof XlsModuleOpenClass) {
            XlsModuleOpenClass xlsModuleOpenClass = (XlsModuleOpenClass)openClass;
            this.xlsDefinitions.addAll(xlsModuleOpenClass.getXlsDefinitions());
        }
    }

    public XlsDefinitions getXlsDefinitions() {
        return this.xlsDefinitions;
    }

    protected void initDependencies() {
        for (CompiledDependency dependency : this.getDependencies()) {
            this.addDependencyTypes(dependency);
            this.addXlsDefinitions(dependency);
            this.addMethods(dependency);
            this.addDataTables(dependency.getCompiledOpenClass());
            this.addFields(dependency);
        }
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    protected IOpenMethod extractNonLazyMethod(IOpenMethod method) {
        if (method instanceof ILazyMember) {
            return this.extractNonLazyMethod((IOpenMethod)((ILazyMember)method).getOriginal());
        }
        return method;
    }

    protected boolean isDependencyMethodInheritable(IOpenMethod openMethod) {
        IOpenMethod method = this.extractNonLazyMethod(openMethod);
        if (method instanceof TestSuiteMethod) {
            return false;
        }
        return super.isDependencyMethodInheritable(method);
    }

    protected IOpenField extractNonLazyMember(IOpenField openField) {
        if (openField instanceof ILazyMember) {
            return this.extractNonLazyMember((IOpenField)((ILazyMember)openField).getOriginal());
        }
        return openField;
    }

    protected boolean isDependencyFieldInheritable(IOpenField openField) {
        IOpenField field = this.extractNonLazyMember(openField);
        if (field instanceof ConstantOpenField) {
            return true;
        }
        return super.isDependencyFieldInheritable(field);
    }

    public void applyToDependentParsedCode(IParsedCode parsedCode) {
        if (parsedCode == null) {
            throw new IllegalArgumentException("parsedCode argument can't be null!");
        }
        if (parsedCode.getTopNode() instanceof XlsModuleSyntaxNode) {
            XlsModuleSyntaxNode xlsModuleSyntaxNode = (XlsModuleSyntaxNode)parsedCode.getTopNode();
            for (String value : this.getImports()) {
                xlsModuleSyntaxNode.addImport(value);
            }
        }
    }

    private void addDataTables(CompiledOpenClass dependency) {
        XlsModuleOpenClass xlsModuleOpenClass;
        IOpenClass openClass = dependency.getOpenClassWithErrors();
        if (openClass instanceof XlsModuleOpenClass && (xlsModuleOpenClass = (XlsModuleOpenClass)openClass).getDataBase() != null) {
            for (ITable table : xlsModuleOpenClass.getDataBase().getTables()) {
                if (!XlsNodeTypes.XLS_DATA.toString().equals(table.getTableSyntaxNode().getType())) continue;
                try {
                    this.getDataBase().registerTable(table);
                }
                catch (DuplicatedTableException e) {
                    this.addError((Exception)((Object)e));
                }
                catch (OpenlNotCheckedException e) {
                    this.addError((Exception)((Object)e));
                }
            }
        }
    }

    public XlsMetaInfo getXlsMetaInfo() {
        return (XlsMetaInfo)this.metaInfo;
    }

    protected IOpenMethod undecorateForMultimoduleDispatching(IOpenMethod openMethod) {
        if (openMethod instanceof IOpenMethodWrapper) {
            IOpenMethodWrapper dispatchWrapper = (IOpenMethodWrapper)openMethod;
            return dispatchWrapper.getDelegate();
        }
        return openMethod;
    }

    protected IOpenMethod decorateForMultimoduleDispatching(IOpenMethod openMethod) {
        return WrapperLogic.wrapOpenMethod(openMethod, this);
    }

    public void addField(IOpenField openField) {
        Map fields = this.fieldMap();
        IOpenField field = this.extractNonLazyMember(openField);
        if (fields.containsKey(openField.getName())) {
            IOpenField existedField = this.extractNonLazyMember((IOpenField)fields.get(openField.getName()));
            if (field instanceof ConstantOpenField && existedField instanceof ConstantOpenField) {
                if (field.getType().equals(existedField.getType()) && Objects.equals(((ConstantOpenField)field).getValue(), ((ConstantOpenField)existedField).getValue())) {
                    return;
                }
                throw new DuplicatedFieldException("", field.getName());
            }
            if (openField instanceof IUriMember && existedField instanceof IUriMember) {
                if (!UriMemberHelper.isTheSame((IUriMember)openField, (IUriMember)existedField)) {
                    throw new DuplicatedFieldException("", openField.getName());
                }
            } else {
                if (existedField != openField) {
                    throw new DuplicatedFieldException("", openField.getName());
                }
                return;
            }
        }
        this.fieldMap().put(openField.getName(), openField);
        if (field instanceof ConstantOpenField) {
            this.constantFields.put(openField.getName(), openField);
        }
        this.addFieldToLowerCaseMap(openField);
    }

    public ConstantOpenField getConstantField(String fname) {
        IOpenField openField = this.constantFields.get(fname);
        return (ConstantOpenField)this.extractNonLazyMember(openField);
    }

    public Map<String, IOpenField> getConstantFields() {
        return Collections.unmodifiableMap(this.constantFields);
    }

    public void addMethod(IOpenMethod method) {
        block16: {
            OpenMethodDispatcher dispatcher;
            IOpenMethod existedMethod;
            IOpenSourceCodeModule sourceCodeModule;
            XlsMetaInfo metaInfo;
            if (method instanceof OpenMethodDispatcher) {
                this.addDispatcherMethod((OpenMethodDispatcher)method);
                return;
            }
            IOpenMethod m = this.decorateForMultimoduleDispatching(method);
            if (m instanceof AMethod && ((AMethod)m).getModuleName() == null && (metaInfo = this.getXlsMetaInfo()) != null && (sourceCodeModule = metaInfo.getXlsModuleNode().getModule()) instanceof IModuleInfo) {
                ((AMethod)m).setModuleName(((IModuleInfo)sourceCodeModule).getModuleName());
            }
            if ((existedMethod = this.getDeclaredMethod(method.getName(), method.getSignature().getParameterTypes())) != null) {
                if (!existedMethod.getType().equals(method.getType())) {
                    String message = String.format("Method \"%s\" with return type \"%s\" is already defined with another return type (\"%s\")", method.getName(), method.getType().getDisplayName(0), existedMethod.getType().getDisplayName(0));
                    throw new DuplicatedMethodException(message, existedMethod, method);
                }
                if (method != existedMethod && method instanceof TestSuiteMethod) {
                    this.validateTestSuiteMethod(method, existedMethod);
                    return;
                }
                try {
                    if (existedMethod instanceof OpenMethodDispatcher) {
                        OpenMethodDispatcher decorator = (OpenMethodDispatcher)existedMethod;
                        decorator.addMethod(this.undecorateForMultimoduleDispatching(m));
                    } else if (m != existedMethod) {
                        dispatcher = this.getOpenMethodDispatcher(existedMethod);
                        IOpenMethod openMethod = this.decorateForMultimoduleDispatching(dispatcher);
                        this.overrideMethod(openMethod);
                        dispatcher.addMethod(this.undecorateForMultimoduleDispatching(m));
                    }
                }
                catch (DuplicatedMethodException e) {
                    IMemberMetaInfo memberMetaInfo;
                    SyntaxNodeException error = null;
                    if (m instanceof IMemberMetaInfo && (memberMetaInfo = (IMemberMetaInfo)m).getSyntaxNode() != null && memberMetaInfo.getSyntaxNode() instanceof TableSyntaxNode) {
                        error = SyntaxNodeExceptionUtils.createError((String)e.getMessage(), (Throwable)e, (ISyntaxNode)memberMetaInfo.getSyntaxNode());
                        ((TableSyntaxNode)memberMetaInfo.getSyntaxNode()).addError(error);
                    }
                    boolean f = false;
                    for (Throwable t : this.getErrors()) {
                        if (!t.getMessage().equals(e.getMessage())) continue;
                        f = true;
                        break;
                    }
                    if (f) break block16;
                    if (error != null) {
                        this.addError((Exception)error);
                        break block16;
                    }
                    this.addError((Exception)((Object)e));
                }
            } else if (this.dispatchingValidationEnabled && !(m instanceof TestSuiteMethod) && this.dimensionalPropertyPresented(m)) {
                dispatcher = this.getOpenMethodDispatcher(m);
                IOpenMethod openMethod = this.decorateForMultimoduleDispatching(dispatcher);
                super.addMethod(openMethod);
            } else {
                super.addMethod(m);
            }
        }
    }

    private void validateTestSuiteMethod(IOpenMethod method, IOpenMethod existedMethod) {
        if (method instanceof IUriMember && existedMethod instanceof IUriMember) {
            if (!UriMemberHelper.isTheSame((IUriMember)method, (IUriMember)existedMethod)) {
                String message = ValidationMessages.getDuplicatedMethodMessage(existedMethod, method);
                throw new DuplicatedMethodException(message, existedMethod, method);
            }
        } else {
            throw new IllegalStateException("Implementation supports only IUriMember!");
        }
    }

    private boolean dimensionalPropertyPresented(IOpenMethod m) {
        List<TablePropertyDefinition> dimensionalPropertiesDef = TablePropertyDefinitionUtils.getDimensionalTableProperties();
        ITableProperties propertiesFromMethod = PropertiesHelper.getTableProperties(m);
        for (TablePropertyDefinition dimensionProperty : dimensionalPropertiesDef) {
            String propertyValue = propertiesFromMethod.getPropertyValueAsString(dimensionProperty.getName());
            if (!StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
            return true;
        }
        return false;
    }

    public void addDispatcherMethod(OpenMethodDispatcher dispatcher) {
        for (IOpenMethod candidate : dispatcher.getCandidates()) {
            this.addMethod(candidate);
        }
    }

    private OpenMethodDispatcher getOpenMethodDispatcher(IOpenMethod method) {
        IOpenMethod decorated = this.undecorateForMultimoduleDispatching(method);
        MatchingOpenMethodDispatcher decorator = this.useDescisionTableDispatcher ? new OverloadedMethodsDispatcherTable(decorated, this) : new MatchingOpenMethodDispatcher(decorated, this);
        return decorator;
    }

    public void clearOddDataForExecutionMode() {
        super.clearOddDataForExecutionMode();
        this.dataBase = null;
        this.rulesModuleBindingContext = null;
    }

    public void completeOpenClassBuilding() {
        this.addTestSuiteMethodsFromDependencies();
    }

    private TestSuiteMethod createNewTestSuiteMethod(TestSuiteMethod testSuiteMethod) {
        IOpenMethod method = testSuiteMethod.getTestedMethod();
        IOpenMethod newTargetMethod = this.getDeclaredMethod(method.getName(), method.getSignature().getParameterTypes());
        TestSuiteMethod copy = new TestSuiteMethod(newTargetMethod, testSuiteMethod);
        copy.setModuleName(testSuiteMethod.getModuleName());
        return copy;
    }

    protected void addTestSuiteMethodsFromDependencies() {
        for (CompiledDependency dependency : this.getDependencies()) {
            for (IOpenMethod depMethod : dependency.getCompiledOpenClass().getOpenClassWithErrors().getMethods()) {
                if (!(depMethod instanceof TestSuiteMethod)) continue;
                TestSuiteMethod testSuiteMethod = (TestSuiteMethod)depMethod;
                try {
                    if (testSuiteMethod.getModuleName() == null) {
                        testSuiteMethod.setModuleName(dependency.getDependencyName());
                    }
                    TestSuiteMethod newTestSuiteMethod = this.createNewTestSuiteMethod(testSuiteMethod);
                    this.addMethod((IOpenMethod)newTestSuiteMethod);
                }
                catch (OpenlNotCheckedException e) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    this.addError((Exception)((Object)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cloner getCloner() {
        if (this.cloner == null) {
            XlsModuleOpenClass xlsModuleOpenClass = this;
            synchronized (xlsModuleOpenClass) {
                if (this.cloner == null) {
                    this.cloner = new OpenLArgumentsCloner();
                }
            }
        }
        return this.cloner;
    }
}

