/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.util.Collection;
import java.util.Objects;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.rules.table.xls.XlsUrlParser;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenMember;
import org.openl.util.StringUtils;

public class TableSyntaxNodeAdapter
implements IOpenLTable {
    private TableSyntaxNode tsn;

    public TableSyntaxNodeAdapter(TableSyntaxNode tsn) {
        if (tsn == null) {
            throw new IllegalArgumentException("TableSyntaxNode is null");
        }
        this.tsn = tsn;
    }

    @Override
    public IGridTable getGridTable() {
        return this.tsn.getGridTable();
    }

    @Override
    public IGridTable getGridTable(String view) {
        ILogicalTable gtx;
        if (view != null && (gtx = this.tsn.getTable(view)) != null) {
            return gtx.getSource();
        }
        return this.getGridTable();
    }

    @Override
    public ITableProperties getProperties() {
        return this.tsn.getTableProperties();
    }

    @Override
    public String getType() {
        return this.tsn.getType();
    }

    @Override
    public Collection<OpenLMessage> getMessages() {
        SyntaxNodeException[] errors = this.tsn.getErrors();
        return OpenLMessagesUtils.newErrorMessages((OpenLCompilationException[])errors);
    }

    @Override
    public String getName() {
        IOpenMember member = this.tsn.getMember();
        if (member != null) {
            return member.getName();
        }
        return "";
    }

    @Override
    public String getDisplayName() {
        String name;
        ITableProperties properties = this.getProperties();
        if (properties != null && StringUtils.isNotBlank((CharSequence)(name = properties.getName()))) {
            String version = properties.getVersion();
            if (StringUtils.isNotBlank((CharSequence)version)) {
                return String.format("%s: %s", name, version);
            }
            return name;
        }
        return this.getName();
    }

    @Override
    public boolean isExecutable() {
        return this.tsn.isExecutableNode();
    }

    @Override
    public String getUri() {
        return this.tsn.getUri();
    }

    @Override
    public XlsUrlParser getUriParser() {
        return this.tsn.getUriParser();
    }

    @Override
    public String getId() {
        return this.tsn.getId();
    }

    @Override
    public boolean isVersionable() {
        return PropertiesChecker.isPropertySuitableForTableType("version", this.tsn.getType());
    }

    public int hashCode() {
        return Objects.hashCode(this.getUri());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TableSyntaxNodeAdapter table = (TableSyntaxNodeAdapter)obj;
        return Objects.equals(this.getUri(), table.getUri());
    }

    @Override
    public boolean isCanContainProperties() {
        String tableType = this.getType();
        return tableType != null && !tableType.equals(XlsNodeTypes.XLS_OTHER.toString()) && !tableType.equals(XlsNodeTypes.XLS_ENVIRONMENT.toString()) && !tableType.equals(XlsNodeTypes.XLS_PROPERTIES.toString());
    }

    @Override
    public MetaInfoReader getMetaInfoReader() {
        return this.tsn.getMetaInfoReader();
    }
}

