/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;

public final class TableSyntaxNodeHelper {
    private static final Pattern REGEX = Pattern.compile("[ ,()\t\n\r\\[\\]]");

    private TableSyntaxNodeHelper() {
    }

    public static String getSignature(TableSyntaxNode rableSyntaxNode) {
        return rableSyntaxNode.getHeader().getHeaderToken().getModule().getCode();
    }

    public static String getTableName(TableSyntaxNode tableSyntaxNode) {
        String methodName = "";
        String[] tokens = REGEX.split(TableSyntaxNodeHelper.getSignature(tableSyntaxNode));
        if (tokens.length > 3) {
            ArrayList<String> notEmptyTokens = new ArrayList<String>();
            for (String token : tokens) {
                if (token.isEmpty()) continue;
                notEmptyTokens.add(token);
            }
            tokens = notEmptyTokens.toArray(new String[0]);
        }
        if (tokens != null && tokens.length > 2) {
            int bracketIndex = tokens[2].indexOf(40);
            methodName = bracketIndex >= 0 ? tokens[2].substring(0, bracketIndex) : tokens[2];
        }
        return methodName;
    }
}

